/*******************************************************************************
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nokia Corporation - initial implementation
 *******************************************************************************/

#include <eikenv.h>
#include <apgwgnam.h> // For CApaWindowGroupName
#include <coemain.h>
#include <eikappui.h>
#include <w32std.h>
#include <avkon.hrh>
#include <QVariant>
#include <eikbtgpc.h> // for cba
#include <avkon.rsg> // for cba

#include "eventcallback.h"
#include "swts60.h"
#include "swt.h"
#include "os.h"

static const char* const EVENT_FILTER = "swt_event_filter";

using namespace Java::eSWT;

typedef struct
    {
    jint uid;
    TTrapHandler* t;
    }
SwtTlsData;

TUid CSwtQtS60MainApplication::AppDllUid() const
    {
    SwtTlsData* data = reinterpret_cast<SwtTlsData*>(Dll::Tls());
    TUid uid;
    uid.iUid = static_cast<TInt>(data ? data->uid : 0);
    return uid;
    }

CApaDocument* CSwtQtS60MainApplication::CreateDocumentL()
    {
    return (static_cast<CApaDocument*>( CSwtS60Document::NewL( *this ) ) );
    }

void CSwtQtS60MainAppUi::ConstructL()
    {
    // Do the same thing as CSwtQtS60MainAppUi would do except don't activate
    // the CAsyncCallback to call main().
    BaseConstructL(CAknAppUi::EAknEnableSkin);
    }

// following method handles default exit command which comes with qt app
// this method needs to be removed after command mapping is done
void CSwtQtS60MainAppUi::HandleCommandL(TInt aCommand)
    {
    QApplication* app = static_cast<QApplication*>(QCoreApplication::instance());
    if(!app)return;
    app->symbianHandleCommand(aCommand);
    if( aCommand == EEikCmdExit || aCommand == EAknSoftkeyExit )
        {
        QVariant data = app->property(EVENT_FILTER);
        EventCallback* filter = reinterpret_cast<EventCallback*> (data.toInt());
        if (filter)
            {
            filter->eventFilter(app, 0, org_eclipse_swt_internal_qt_OS_QSWTEVENT_ENDKEYCLOSE);
            }
        }
    }

CSwtS60Document* CSwtS60Document::NewL( CEikApplication& aApp )
    {
    CSwtS60Document* self = NewLC( aApp );
    CleanupStack::Pop( self );
    return self;
    }

CSwtS60Document* CSwtS60Document::NewLC( CEikApplication& aApp )
    {
    CSwtS60Document* self = new ( ELeave ) CSwtS60Document( aApp );
    CleanupStack::PushL( self );
    self->ConstructL();
    return self;
    }

void CSwtS60Document::ConstructL()
    {
    }

CSwtS60Document::CSwtS60Document( CEikApplication& aApp )
    : CAknDocument( aApp )
    {
    }

CSwtS60Document::~CSwtS60Document()
    {
    }

CEikAppUi* CSwtS60Document::CreateAppUiL()
    {
    return static_cast<CEikAppUi*>(new (ELeave)CSwtQtS60MainAppUi);
    }

bool CSwtS60EventCallback::eventFilter(QObject* object, TWsEvent* aEvent)
{
    int swtEventType = -1;
	switch (aEvent->Type())
	{
 	case KAknUidValueEndKeyCloseEvent:
	    swtEventType = org_eclipse_swt_internal_qt_OS_QSWTEVENT_ENDKEYCLOSE;
	    break;
    case KAknShutOrHideApp: //The event is received when exit from task list, 
                            //which terminates application straight away
        swtEventType = org_eclipse_swt_internal_qt_OS_QSWTEVENT_SYSTEMSHUTDOWN;
        break;
     case EEventUser:
        if ( ( *reinterpret_cast<TApaSystemEvent*>( aEvent->EventData() ) ) == EApaSystemEventShutdown )
            {
            // other system exit (e.g. when out of memory). 
            if( !CEikonEnv::Static()->IsSystem() )
                {
                swtEventType = org_eclipse_swt_internal_qt_OS_QSWTEVENT_SYSTEMSHUTDOWN;
                }
            }
        break;
	default:
		break;
	}
	
	if (swtEventType > -1)
        {
        QVariant data = object->property(EVENT_FILTER);
        if (data.isValid())
            {
            EventCallback* filter = reinterpret_cast<EventCallback*> (data.toInt());
            if (filter)
                {
                return filter->eventFilter(object, 0, swtEventType);
                }
            }
        }
	return false;
}


LOCAL_C CApaApplication* NewApplication()
    {
    return new CSwtQtS60MainApplication;
    }

/**
 * This is here just so that QtMainWrapper can be compiled. It should never
 * get called.
 */
int main()
    {
    __ASSERT_ALWAYS(EFalse, User::Invariant());
    return 0;
    }

void swtCreateUikon(const TInt& aUid)
    {
    SwtTlsData* data = new SwtTlsData();
    data->uid = aUid;
    Dll::SetTls(data);

    TApaApplicationFactory factory( NewApplication );
    CApaCommandLine* commandLine = NULL;
    TInt err = CApaCommandLine::GetCommandLineFromProcessEnvironment( commandLine );

    // Creates a CleanupStack, doesn't mark it
    CEikonEnv* coe = new CEikonEnv;

    TRAP(err, coe->ConstructAppFromCommandLineL(factory,*commandLine));
    delete commandLine;

    // Exit checks temporarily disabled to prevent panics due to memory leaks 
    // when Display is disposed. 
    coe->DisableExitChecks(ETrue);
    
    // Mark the CleanupStack created by EikonEnv in CCoeEnv constructor.
    TTrapHandler* t = User::MarkCleanupStack();
    data->t = t;
    }

void swtDestroyUikon()
    {
    SwtTlsData* data = reinterpret_cast<SwtTlsData*>(Dll::Tls());
    CCoeEnv* coe = CCoeEnv::Static();
    if(coe)
        {
        // Unmark the CleanupStack created by EikonEnv in CCoeEnv constructor.
        User::UnMarkCleanupStack(data->t);
        coe->DestroyEnvironment();
        }

    Dll::SetTls(NULL);
    delete data;
    data = NULL;
    }

void fixWindowGroup()
    {
    CApaWindowGroupName* wgn = NULL;
    TRAPD( err, wgn = CApaWindowGroupName::NewL(CCoeEnv::Static()->WsSession()));
    if(err != KErrNone) return;
    wgn->SetAppUid(CEikonEnv::Static()->EikAppUi()->Application()->AppDllUid());
    wgn->SetWindowGroupName(CCoeEnv::Static()->RootWin());
    delete wgn;
    }

void setAppName(const TInt& aUid, const TDesC& aAppName)
    {
    CCoeEnv* coe = CCoeEnv::Static();
    //CEikonEnv* coe = new CEikonEnv;
    CApaWindowGroupName* wgn = NULL;
    TRAPD( err, wgn = CApaWindowGroupName::NewL(coe->WsSession()));
    if(err == KErrNone)
        {
        wgn->SetAppUid(TUid::Uid(aUid));
        TRAP_IGNORE(wgn->SetCaptionL(aAppName));
        wgn->SetWindowGroupName(coe->RootWin());
        delete wgn;
        }
    }


// remove following method when invisible problem of menu and command has been solved with new s60 qt release                }
void CSwtS60SoftKey::setSoftkeys()
{
    CEikButtonGroupContainer* cba = CEikonEnv::Static()->AppUiFactory()->Cba();
    if (cba){
        cba->SetCommandSetL(R_AVKON_SOFTKEYS_OPTIONS_EXIT);
    }
}


