/*******************************************************************************
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nokia Corporation - initial implementation
 *******************************************************************************/

#ifndef _SWTS60_H_
#define _SWTS60_H_

/*
 * This is a temporary solution for being able to construct the application with
 * the Java MIDP app's uid. It must be replaced with a proper solution once Qt
 * provides means for nicer integration.
 */

#include <qts60mainapplication.h>
#include <qts60maindocument.h>
#include <qts60mainappui.h>
#include <jni.h>


/*
 * Creates and destroys the Symbian UI environment in the current thread.
 */
void swtCreateUikon(const TInt& aUid);
void swtDestroyUikon();
void fixWindowGroup();
void setAppName(const TInt& aUid, const TDesC& aAppName);

/*
 * This is a temporary solution for being able to construct the application with
 * the Java MIDP app's uid. It must be replaced with a proper solution once Qt
 * provides means for nicer integration.
 */
class CSwtQtS60MainApplication : public CQtS60MainApplication
    {
public:
    TUid AppDllUid() const;
    CApaDocument* CreateDocumentL();
    };

/*
 * This is a temporary solution for being able to construct S60 environment for
 * Qt without it scheduling a main-callback and calling Exit after it returns.
 * This causes a leave which causes further problems.
 */
class CSwtQtS60MainAppUi : public CQtS60MainAppUi
    {
public:
    void ConstructL();
    void HandleCommandL(TInt aCommand);
    };

/*
 * We need to override CreateAppUiL to get rid of CAsyncCallback trying to call
 * main() and then Exit(). Can't derive from CQtS60MainDocument because they
 * have made the constructor private. Derive straight from CAknDocument as
 * there doesn't seem to be anything useful in CQtS60MainDocument anyway.
 */
class CSwtS60Document : public CAknDocument
    {
    public:
        static CSwtS60Document* NewL( CEikApplication& aApp );
        static CSwtS60Document* NewLC( CEikApplication& aApp );
        virtual ~CSwtS60Document();
    public:
        CEikAppUi* CreateAppUiL();
    private:
        void ConstructL();
        CSwtS60Document( CEikApplication& aApp );
    };
namespace Java { namespace eSWT {

class CSwtS60EventCallback 
    {
    public:
        static bool eventFilter(QObject* object, TWsEvent* aEvent);
    };
// remove following class when invisible problem of menu and command has been solved with new s60 qt release                }
class CSwtS60SoftKey
    {
public:
    static void setSoftkeys();
    };
}}


#endif /* _SWTS60_H_ */
