/*******************************************************************************
 * Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia Corporation - initial implementation 
 *******************************************************************************/
package org.eclipse.swt.internal.qt.graphics;

/**
 * 
 * Wrapper for rendering target related data.
 * 
 * @author sampkaar
 *
 */
final class RenderingTarget {
    
    /**
     * Native handle of rendering target
     */
    private int handle;
    
    /**
     * The type of rendering target, 
     * one of types defined in GraphicsContext
     */
    private int type;
    
    /**
     * The target
     */
    private java.lang.Object target;
       
    /**
     * Constructor
     */
    RenderingTarget() {
        reset();
    }
    
    /**
     * Gets targets native handle.
     * @return the native handle
     */
    int getHandle() {
        return handle;
    }
    
    /**
     * Gets the type of rendering target.
     * @return The type of rendering target, which is one of defined in GraphicsContext
     */
    int getType() {
        return type;
    }
    
    /**
     * Gets the actual target object
     * @return The rendering target object
     */
    java.lang.Object getTarget() {
        return target;
    }
    
    /**
     * Sets the native handle of rendering target
     * @param handle The native handle
     */
    void setHandle(int targetHandle) {
        handle = targetHandle;
    }
    
    /**
     * Sets the type of rendering target
     * @param type The type of target, one of defined in GraphicsContext
     */
    void setType(int targetType) {
        type = targetType;
    }
    
    /**
     * Sets the rendering target object
     * @param target The rendering target object
     */
    void setTarget(java.lang.Object renderingTarget) {
        target = renderingTarget;
    }
    
    /**
     * Resets all stored fields and data
     */
    void reset() {
        handle = 0;
        type = GraphicsContext.TYPE_NONE;
        target = null;
    }

}
