package org.eclipse.swt.internal.qt.graphics;

import org.eclipse.swt.widgets.Display;

/** 
 * Class for general utilities for common graphics
 */
final class Utils {
	
	/**
	 * Validates that ui thread is created and execution is 
	 * currently in ui thread.
	 * 
	 * @throws java.lang.Error if ui thread is not initialized or 
	 * this method is not called within ui thread.
	 */
	static void validateUiThread() {
		if (!Config.ENABLE_UI_THREAD_VALIDATION) {
			return;
		}
		if (Display.getCurrent() == null) {
			throw new Error("Ui thread not initialized or call was made outside ui thread");
		} else {
			Display display = Display.getCurrent();
			if (Thread.currentThread() != display.getThread()) {
				throw new Error("Call to common graphics object occured outside ui thread");
			}
		}
	}

}
