/*******************************************************************************
 * Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia Corporation - initial implementation 
 *******************************************************************************/
package org.eclipse.swt.internal.qt.graphics;

public final class WindowSurface {
     
    final static int QImage = 1; 
    final static int PBuffer = 2;
     
    /**
     * Handle of native peer
     */  
    private int handle;
    private boolean disposed;

    /**
     * Constructor
     */            
    WindowSurface(int nativeHandle) {
        handle = nativeHandle;
        disposed = false;
    }
    
    /**
     * Gets the type of window surface
     */ 
    public int getType() {
    	checkState();
        int type = OS.windowsurface_getType(handle);
        return type;
    } 
    
    /**
     * Gets the handle of the native peer
     */     
    public int getHandle() {
    	checkState();
        return handle;
    }
    
    /**
     * Disposes this instance
     */ 
    public void dispose() {
    	Utils.validateUiThread();
        if (handle != 0) {
            OS.windowsurface_dispose(handle);
            handle = 0;
        }
    }
    
    private void checkState() {
    	Utils.validateUiThread();
    	if (disposed) {
            throw new IllegalStateException("WindowSurface already disposed");
        }
    }
    
}