/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ui.internal;

//import java.io.IOException;
//import java.io.Reader;
//import java.io.StringReader;
//import java.util.HashMap;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent;

//import org.eclipse.jface.preference.IPreferenceStore;

//import org.eclipse.ui.IEditorDescriptor;
//import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferenceConstants;
//import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
//import org.eclipse.ui.WorkbenchException;

//import org.eclipse.ui.internal.decorators.DecoratorManager;
//import org.eclipse.ui.internal.progress.ProgressManager;
//import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.util.PrefUtil;

/**
 * The PlatformUIPreferenceListener is a class that listens to changes in the
 * org.eclipse.jface.preference store and propogates the change for any special cases that require
 * updating of other values within the workbench.
 */
public class PlatformUIPreferenceListener implements
		IEclipsePreferences.IPreferenceChangeListener {
	
	private static PlatformUIPreferenceListener singleton;
	
	public static IEclipsePreferences.IPreferenceChangeListener getSingleton(){
		if(singleton == null)
			singleton = new PlatformUIPreferenceListener();
	    return singleton;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.IEclipsePreferences.IPreferenceChangeListener#preferenceChange(org.eclipse.core.runtime.preferences.IEclipsePreferences.PreferenceChangeEvent)
	 */
	public void preferenceChange(PreferenceChangeEvent event) {

		String propertyName = event.getKey();

		if (IWorkbenchPreferenceConstants.SHOW_SYSTEM_JOBS.equals(propertyName)) {
			boolean setting = PrefUtil.getAPIPreferenceStore().getBoolean(
					IWorkbenchPreferenceConstants.SHOW_SYSTEM_JOBS);

//			ProgressManager.getInstance().setShowSystemJobs(setting);
		}
		
		if (IWorkbenchPreferenceConstants.DEFAULT_PERSPECTIVE_ID.equals(propertyName)) {
			IWorkbench workbench = PlatformUI.getWorkbench();

			workbench.getPerspectiveRegistry().setDefaultPerspective(
					PrefUtil.getAPIPreferenceStore().getString(
							IWorkbenchPreferenceConstants.DEFAULT_PERSPECTIVE_ID));
			return;
		}

//		if (IWorkbenchPreferenceConstants.DOCK_PERSPECTIVE_BAR
//				.equals(propertyName)) {
//			IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
//			IWorkbench workbench = PlatformUI.getWorkbench();
//			IWorkbenchWindow[] workbenchWindows = workbench
//					.getWorkbenchWindows();
//			for (int i = 0; i < workbenchWindows.length; i++) {
//				IWorkbenchWindow org.eclipse.jface.window = workbenchWindows[i];
//				if (org.eclipse.jface.window instanceof WorkbenchWindow)
//					((WorkbenchWindow) org.eclipse.jface.window)
//							.setPerspectiveBarLocation(apiStore
//									.getString(IWorkbenchPreferenceConstants.DOCK_PERSPECTIVE_BAR));
//			}
//			return;
//		}

		// TODO the banner apperance should have its own org.eclipse.jface.preference
		if (IWorkbenchPreferenceConstants.SHOW_TRADITIONAL_STYLE_TABS
				.equals(propertyName)) {
			boolean newValue = PrefUtil.getAPIPreferenceStore().getBoolean(
					IWorkbenchPreferenceConstants.SHOW_TRADITIONAL_STYLE_TABS);

/*			IWorkbench workbench = PlatformUI.getWorkbench();
			IWorkbenchWindow[] workbenchWindows = workbench
					.getWorkbenchWindows();
			for (int i = 0; i < workbenchWindows.length; i++) {
				IWorkbenchWindow org.eclipse.jface.window = workbenchWindows[i];
				if (org.eclipse.jface.window instanceof WorkbenchWindow)
					((WorkbenchWindow) org.eclipse.jface.window).setBannerCurve(newValue);
			}
*/
			return;
		}
	}

}
