/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/package org.eclipse.ui.internal;

import java.net.URL;

import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.BundleUtility;

public class ProxyImageDescriptor extends ImageDescriptor {

  private ImageDescriptor desc;
  private String key = null;
  private String path = null;
  private boolean shared = false;
  private boolean init = false;

  public ProxyImageDescriptor(String key, String path, boolean shared) {
    super();
    this.key = key;
    this.path = path;
    this.shared = shared;
  }

  public void init(String key, String path, boolean shared) {
    URL url = BundleUtility.find(PlatformUI.PLUGIN_ID, path);
    desc = ImageDescriptor.createFromURL(url);
    init = true;
  }

  public ImageData getImageData() {
    if (!init) {
      init(key, path, shared);
    }
    return desc.getImageData();
  }

  public Object createResource(Device device) throws DeviceResourceException {
    if (!init) {
      init(key, path, shared);
    }
    return desc.createResource(device);
  }

  public void destroyResource(Object previouslyCreatedObject) {
    if (!init) {
      init(key, path, shared);
    }
    desc.destroyResource(previouslyCreatedObject);
  }

  public Image createImage() {
    if (!init) {
      init(key, path, shared);
    }
    return desc.createImage(true);
  }

  public Image createImage(boolean returnMissingImageOnError) {
    if (!init) {
      init(key, path, shared);
    }
    return desc.createImage(returnMissingImageOnError);
  }

  public Image createImage(Device device) {
    if (!init) {
      init(key, path, shared);
    }
    return desc.createImage(device);
  }

  public Image createImage(boolean returnMissingImageOnError, Device device) {
    if (!init) {
      init(key, path, shared);
    }
    return desc.createImage(returnMissingImageOnError, device);
  }
}