/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ui.internal.dialogs;

//import java.util.Collection;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.CategorizedPageRegistryReader;
import org.eclipse.ui.internal.registry.IWorkbenchRegistryConstants;
import org.eclipse.jface.resource.ImageDescriptor;
//import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;


/**
 * A proxy for a preference page to avoid creation of preference page just to
 * show a node in the preference dialog tree.
 */
public class WorkbenchPreferenceNode extends PreferenceNode implements IPluginContribution {

	IConfigurationElement element;
	String nodeId;
//	private Collection keywordLabelCache;
	private ImageDescriptor imageDescriptor;
//	private Image image;

	
	/**
	 * Create a new instance of the receiver.
	 * @param nodeId
	 * @param element
	 */
	public WorkbenchPreferenceNode(String nodeId, IConfigurationElement element) {
		super(nodeId);
		this.element = element;
	}

	/**
	 * Creates the preference page this node stands for.
	 */
	public void createPage() {
		PreferencePage page;
		try {
			page = (PreferencePage) WorkbenchPlugin.createExtension(
					getConfigurationElement(), IWorkbenchRegistryConstants.ATT_CLASS);
		} catch (CoreException e) {
			System.out.println("Error creating preference page extension"); //$NON-NLS-1$

//			ErrorDialog.openError((Shell) null, WorkbenchMessages.PreferenceNode_errorTitle, 
//					WorkbenchMessages.PreferenceNode_errorMessage, 
//					e.getStatus());
			page = null; //new ErrorPreferencePage();
			return;
		}

//		page.init(PlatformUI.getWorkbench());
		page.setImageDescriptor(getImageDescriptor());
     	page.setTitle(getLabelText());
		setPage(page);
	}

	public IConfigurationElement getConfigurationElement() {
		return element;
	}

	public String getLocalId() {
		return this.nodeId;
	}

	public String getPluginId() {
		return getConfigurationElement().getNamespace();
	}

	/**
	 * Return the category name for the node.
	 * @return java.lang.String
	 */
	public String getCategory() {
		return getConfigurationElement().getAttribute(
				CategorizedPageRegistryReader.ATT_CATEGORY);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.IPreferenceNode#getLabelText()
	 */
	public String getLabelText() {
		return getConfigurationElement().getAttribute(IWorkbenchRegistryConstants.ATT_NAME);
	}

    /**
     * Returns the image descriptor for this node.
     * 
     * @return the image descriptor
     */
    public ImageDescriptor getImageDescriptor() {
    	if (imageDescriptor != null) 
    		return imageDescriptor;
    	
    	String imageName = getConfigurationElement().getAttribute(IWorkbenchRegistryConstants.ATT_ICON);
		if (imageName != null) {
			String contributingPluginId = getConfigurationElement().getNamespace();
			imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(contributingPluginId, imageName);
		}
		return imageDescriptor;
    }

	
	/**
	 * Get the labels of all of the keywords of the receiver.
	 * 
	 * @return Collection of <code>String</code>.  Never <code>null</code>.
	 */
	/*public Collection getKeywordLabels() {
		if (keywordLabelCache != null)
			return keywordLabelCache;
		
		Collection refs = getKeywordReferences();
		
		if(refs == Collections.EMPTY_SET) {
			keywordLabelCache = Collections.EMPTY_SET; 
			return keywordLabelCache;
		}
		
		keywordLabelCache = new ArrayList(refs.size());
		Iterator referenceIterator = refs.iterator();
		while(referenceIterator.hasNext()){
			Object label = KeywordRegistry.getInstance().getKeywordLabel(
					(String) referenceIterator.next());
			if(label != null)
				keywordLabelCache.add(label);
		}
		
		return keywordLabelCache;
	}*/
	
	/**
	 * Clear the keyword cache, if any.
	 */
//	public void clearKeywords() {
//		keywordLabelCache = null;
//	}

}
