package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.IPreferenceConstants;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackPresentation;

public class NativeStackPresentation extends StackPresentation {
	private Composite tabFolder;
	private Listener dragListener;

	private IPresentablePart current;

	// private MenuManager systemMenuManager = new MenuManager();

	private IPreferenceStore preferenceStore = WorkbenchPlugin.getDefault()
			.getPreferenceStore();

	private final static String TAB_DATA = NativeStackPresentation.class
			.getName()
			+ ".partId"; //$NON-NLS-1$

	public NativeStackPresentation(Composite parent,
			IStackPresentationSite stackSite) {
		super(stackSite);
		int tabPos = preferenceStore
				.getInt(IPreferenceConstants.VIEW_TAB_POSITION);
		tabFolder = new Composite(parent, tabPos);
		// listener to switch between visible tabItems
		// tabFolder.addListener(SWT.Selection, selectionListener);

	}

	public void setBounds(Rectangle bounds) {
		// TODO Auto-generated method stub
		tabFolder.setBounds(bounds);
		setControlSize();
	}

	private void setControlSize() {
		if (current == null || tabFolder == null)
			return;
		// Rectangle bounds;
		// @issue as above, the mere presence of a theme should not change the
		// behaviour
		// if ((mapTabToPart.size() > 1)
		// || ((tabThemeDescriptor != null) && (mapTabToPart.size() >= 1)))
		// bounds = calculatePageBounds(tabFolder);
		// else
		// bounds = tabFolder.getBounds();
		current.setBounds(calculatePageBounds(tabFolder));
		// current.moveAbove(tabFolder);
	}

	public static Rectangle calculatePageBounds(Composite folder) {
		if (folder == null)
			return new Rectangle(0, 0, 0, 0);
		Rectangle bounds = folder.getBounds();
		Rectangle offset = folder.getClientArea();
		bounds.x += offset.x;
		bounds.y += offset.y;
		bounds.width = offset.width;
		bounds.height = offset.height;
		return bounds;
	}

	public void dispose() {
		// TODO Auto-generated method stub
		if (isDisposed()) {
			return;
		}
		// PresentationUtil.removeDragListener(tabFolder, dragListener);

		// systemMenuManager.dispose();

		tabFolder.dispose();
		tabFolder = null;

	}

	public boolean isDisposed() {
		return tabFolder == null || tabFolder.isDisposed();
	}

	public void setActive(int newState) {
		// TODO Auto-generated method stub

	}

	public void setVisible(boolean isVisible) {
		// TODO Auto-generated method stub
		if (current != null) {
			current.setVisible(isVisible);
		}
		tabFolder.setVisible(isVisible);
	
	}

	public void setState(int state) {
		// TODO Auto-generated method stub

	}

	public Control getControl() {
		return tabFolder;
	}

	public void addPart(IPresentablePart newPart, Object cookie) {
		// TODO Auto-generated method stub
		
	}

	public void removePart(IPresentablePart oldPart) {
		// TODO Auto-generated method stub
		// TabItem item = getTab(oldPart);
		// if (item == null) {
		// return;
		// }
		oldPart.setVisible(false);

		// item.dispose();

	}

	public void selectPart(IPresentablePart toSelect) {
		// TODO Auto-generated method stub
//		System.out.println("select part"); //$NON-NLS-1$
		if (toSelect == current) {
			return;
		}

		if (current != null) {
			current.setVisible(false);
		}
		current = toSelect;

		if (current != null) {
			// tabFolder.setSelection(indexOf(current));
			current.setVisible(true);
			setControlSize();
		}

	}

	public void showSystemMenu() {
		// TODO Auto-generated method stub

	}

	public void showPaneMenu() {
		// TODO Auto-generated method stub

	}

	public Control[] getTabList(IPresentablePart part) {
		// TODO Auto-generated method stub
		ArrayList list = new ArrayList();
		if (getControl() != null)
			list.add(getControl());
		// if (part.getToolBar() != null)
		// list.add(part.getToolBar());
		if (part.getControl() != null)
			list.add(part.getControl());
		return (Control[]) list.toArray(new Control[list.size()]);
	}


}
