/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.app.preferences;

import java.io.IOException;

import org.eclipse.ercp.app.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


public class SamplePage extends PreferencePage implements IWorkbenchPreferencePage {

	private static final String ONE = "page1.field1"; //$NON-NLS-1$
	private static final String TWO = "page1.field2"; //$NON-NLS-1$
	private static final String THREE = "page1.field3"; //$NON-NLS-1$
	
	private Text field1, field2, field3;
	
	private PreferenceStore preferenceStore;
	  
	
	public void init(IWorkbench workbench) {}
		
	protected Control createContents(Composite parent) {
	    Composite composite = new Composite(parent, SWT.NONE);
	    composite.setLayout(new GridLayout(2, false));

	    // get preference store
	    preferenceStore = new PreferenceStore("org.eclipse.ercp.app.page1.properties"); //$NON-NLS-1$
	    try {
	      preferenceStore.load();
	    } catch (IOException e) {}
	    
	    new Label(composite, SWT.LEFT).setText(Messages.getString("SamplePage.4")); //$NON-NLS-1$
	    field1 = new Text(composite, SWT.BORDER);
	    field1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    field1.setText(preferenceStore.getString(ONE));

	    new Label(composite, SWT.LEFT).setText(Messages.getString("SamplePage.5")); //$NON-NLS-1$
	    field2 = new Text(composite, SWT.BORDER);
	    field2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    field2.setText(preferenceStore.getString(TWO));

	    new Label(composite, SWT.LEFT).setText(Messages.getString("SamplePage.6")); //$NON-NLS-1$
	    field3 = new Text(composite, SWT.BORDER);
	    field3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	    field3.setText(preferenceStore.getString(THREE));

	    return composite;
	}
	
	public boolean performOk() {
		
		// save values
	    if (field1 != null) preferenceStore.setValue(ONE, field1.getText());
	    if (field2 != null) preferenceStore.setValue(TWO, field2.getText());
	    if (field3 != null) preferenceStore.setValue(THREE, field3.getText());
	    
	    try {
	        preferenceStore.save();
	      } catch (IOException e) {
	        return false;
	      }
	   
	    return true;
    }
	
	public boolean performCancel() {
		return true;
    }

}
