/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.app.preferences;

import java.io.IOException;

import org.eclipse.ercp.app.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;


public class SampleSubPage extends PreferencePage implements IWorkbenchPreferencePage {
	
	private static final String ONE = "page2.check"; //$NON-NLS-1$
	private static final String TWO = "page2.check2"; //$NON-NLS-1$
	private static final String THREE = "page2.check3"; //$NON-NLS-1$
	
	private Button check1, check2, check3;

	private PreferenceStore preferenceStore;

	
	public void init(IWorkbench workbench) {}
		
	protected Control createContents(Composite parent) {
	    Composite composite = new Composite(parent, SWT.NONE);
	    composite.setLayout(new RowLayout(SWT.VERTICAL));

	    // get preference store
	    preferenceStore = new PreferenceStore("org.eclipse.ercp.app.page2.properties"); //$NON-NLS-1$
	    try {
	      preferenceStore.load();
	    } catch (IOException e) {}
	    
	    // Create three checkboxes
	    check1 = new Button(composite, SWT.CHECK);
	    check1.setText(Messages.getString("SampleSubPage.4")); //$NON-NLS-1$
	    check1.setSelection(preferenceStore.getBoolean(ONE));

	    check2 = new Button(composite, SWT.CHECK);
	    check2.setText(Messages.getString("SampleSubPage.5")); //$NON-NLS-1$
	    check2.setSelection(preferenceStore.getBoolean(TWO));

	    check3 = new Button(composite, SWT.CHECK);
	    check3.setText(Messages.getString("SampleSubPage.6")); //$NON-NLS-1$
	    check3.setSelection(preferenceStore.getBoolean(THREE));

	    return composite;
	}
	
	public boolean performOk() {
	    
		// save values
	    if (check1 != null) preferenceStore.setValue(ONE, check1.getSelection());
	    if (check2 != null) preferenceStore.setValue(TWO, check2.getSelection());
	    if (check3 != null) preferenceStore.setValue(THREE, check3.getSelection());

		try {
	        preferenceStore.save();
	      } catch (IOException e) {
	        return false;
	      }
	   
	    return true;
    }
	
	public boolean performCancel() {
        return true;
    }

}
