/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ercp.app.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.eclipse.ercp.app.Messages;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;


/**
 * This sample class demonstrates how to plug-in a new
 * workbench view. The view shows data obtained from the
 * model. The sample creates a dummy model on the fly,
 * but a real implementation would connect to the model
 * available either in this or another plug-in (e.g. the workspace).
 * The view is connected to the model using a content provider.
 * <p>
 * The view uses a label provider to define how model
 * objects should be presented in the view. Each
 * view can present the same model objects using
 * different labels and icons, if needed. Alternatively,
 * a single label provider can be shared between views
 * in order to ensure that objects of the same type are
 * presented in the same way everywhere.
 * <p>
 */

public class LargeView extends ViewPart implements ControlListener,IOpenListener,SelectionListener {
	private TableViewer viewer;
	private EmailTableModel model;
	private Composite parent, c1, c2, current;
	private Command emaiListCommand;
	private Command viewMessageCommand;

	
	/*
	 * The content provider class is responsible for
	 * providing objects to the view. It can wrap
	 * existing objects in adapters or simply return
	 * objects as-is. These objects may be sensitive
	 * to the current input of the view, or ignore
	 * it and always show the same content 
	 * (like Task List, for example).
	 */
	 
	class ViewContentProvider implements IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}
		public void dispose() {
		}
		public Object[] getElements(Object parent) {
			// Returns all the emails
			return (Email[]) parent;
		}
	}
	
	class ViewLabelProvider extends LabelProvider implements
			ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			Email email = (Email) obj;
			String text = ""; //$NON-NLS-1$
			switch (index) {
			case 0:
				text = email.getName();
				break;
			case 1:
				text = email.getDate();
				break;
			case 2:
				text = String.valueOf(email.getSize());
				break;
			case 3:
				text = email.getSubject();
				break;
			}
			return text;

		}

		public Image getColumnImage(Object obj, int index) {
			// return getImage(obj);
			return null;
		}

		public Image getImage(Object obj) {
			return PlatformUI.getWorkbench().getSharedImages().getImage(
					ISharedImages.IMG_OBJ_ELEMENT);
		}

		public void addListener(ILabelProviderListener listener) {

		}

	}

	class EmailTableModel {
		Email[] emails;

		public EmailTableModel() {
			emails = new Email[5];
			emails[0] = new Email("Markleo Ruben", getDate(2005, //$NON-NLS-1$
					Calendar.OCTOBER, 16, 9, 32), 3165, "Eclipse site is up"); //$NON-NLS-1$
			emails[1] = new Email("Michelle Guang", getDate(2005, //$NON-NLS-1$
					Calendar.OCTOBER, 8, 4, 21), 316545,
					Messages.getString("LargeView.5")); //$NON-NLS-1$
			emails[2] = new Email("Aggrawal Vijjay", getDate(2005, //$NON-NLS-1$
					Calendar.SEPTEMBER, 7, 19, 2), 212345, Messages.getString("LargeView.4")); //$NON-NLS-1$
			emails[3] = new Email("Kevin Ma", getDate(2005, //$NON-NLS-1$
					Calendar.SEPTEMBER, 1, 12, 3), 45645, Messages.getString("LargeView.3")); //$NON-NLS-1$
			emails[4] = new Email("Paris Edgare", getDate(2005, //$NON-NLS-1$
					Calendar.AUGUST, 19, 9, 1), 42345, Messages.getString("LargeView.10")); //$NON-NLS-1$
		}

		public String getDate(int year, int month, int date, int hour,
				int minute) {
			GregorianCalendar liftOffApollo11 = new GregorianCalendar(year,
					month, date, hour, minute);

			Date d = liftOffApollo11.getTime();

			DateFormat df1 = new SimpleDateFormat("MM/dd/yy"); //$NON-NLS-1$
			DateFormat df2 = DateFormat.getTimeInstance(DateFormat.SHORT);
			String s1 = df1.format(d);

			String s2 = df2.format(d);

			return s1 + " " + s2; //$NON-NLS-1$
		}

	}

	class Email {
		private String date;

		private String name;

		private int size;

		private String subject;

	
		public Email(String name, String date, int size, String subject) {
			setName(name);
			setDate(date);
			setSize(size);
			setSubject(subject);
		}
		
		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public int getSize() {
			return size;
		}

		public void setSize(int size) {
			this.size = size;
		}

		public String getSubject() {
			return subject;
		}

		public void setSubject(String subject) {
			this.subject = subject;
		}

		public String getDate() {
			return date;
		}

		public void setDate(String date) {
			this.date = date;
		}
	}
	

	/**
	 * The constructor.
	 */
	public LargeView() {
//		create the data model
		model = new EmailTableModel();
	}
	
	
	private void enableListCommand(boolean enable) {
		
    	if (enable) {
    		
    		emaiListCommand = new Command(c1, Command.SELECT, 1);
            emaiListCommand.setText(Messages.getString("LargeView.13")); //$NON-NLS-1$
            emaiListCommand.addSelectionListener(this);
            current = c1;
            c1.setFocus();
           
    	} else {
    		if(emaiListCommand!=null)
    			emaiListCommand.dispose();
    	}
    }	
	
	private void enableLaunchCommand(boolean enable) {
				
	    	if (enable) {
	    		
	    		viewMessageCommand = new Command(c2, Command.SELECT, 1);	
	    		viewMessageCommand.setText(Messages.getString("LargeView.14")); //$NON-NLS-1$
	    		//viewMessageCommand.setLongLabel("view the message");
	    		viewMessageCommand.addSelectionListener(this);
	    		current = c2;
	    		c2.setFocus();
	    	} else {
	    		viewMessageCommand.dispose();
	    	}
	  }	

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
			
			this.parent = parent;
			parent.addControlListener(this);
			parent.setLayout(null);
		
			c2 = new Composite(parent, SWT.NONE);
			c2.setLayout(new FillLayout ());
			c2.setVisible(true);

//		    Create the table viewer to display the players
		    viewer = new TableViewer(c2, SWT.MULTI | SWT.H_SCROLL
					| SWT.V_SCROLL);
		   
			Table table = viewer.getTable();
			table.setLayoutData(new GridData(GridData.FILL_BOTH));

			// Add the who column
			TableColumn tc = new TableColumn(table, SWT.LEFT);
			tc.setText(Messages.getString("LargeView.15")); //$NON-NLS-1$

			// Add the date column
			tc = new TableColumn(table, SWT.LEFT);
			tc.setText(Messages.getString("LargeView.16")); //$NON-NLS-1$

			// Add the size column
			tc = new TableColumn(table, SWT.LEFT);
			tc.setText(Messages.getString("LargeView.17")); //$NON-NLS-1$

			// Add the subject column
			tc = new TableColumn(table, SWT.LEFT);
			tc.setText(Messages.getString("LargeView.18")); //$NON-NLS-1$

			viewer.setContentProvider(new ViewContentProvider());
			viewer.setLabelProvider(new ViewLabelProvider());
			viewer.setInput(model.emails);
			viewer.addOpenListener(this);

			// Pack the columns
			for (int i = 0, n = table.getColumnCount(); i < n; i++) {
				table.getColumn(i).pack();
			}

			// Turn on the header and the lines
			table.setHeaderVisible(true);
//	        table.setLinesVisible(true);
			
			c1 = new Composite(parent, SWT.NONE);
	    	c1.setLayout(new FillLayout());
			c1.setVisible(false);
	    	Text text = new Text (c1,SWT.NONE);
	    	text.setText (Messages.getString("LargeView.19")); //$NON-NLS-1$
			enableLaunchCommand(true);
			c1.layout();
			c2.layout();
		}
		
	
	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		c1.setSize(parent.getSize());
		c2.setSize(parent.getSize());
		current.setFocus();
	}
	
	public void controlMoved(ControlEvent e) {
	}
	
	public void controlResized(ControlEvent e) {
		c1.setSize(parent.getSize());
		c2.setSize(parent.getSize());
	}
	
	public void open(OpenEvent event) {
		launchSelection(event.getSelection());
	}
	
	private void launchSelection(ISelection selection) {
		 if (selection.isEmpty())
			 return;
		 if (!(selection instanceof IStructuredSelection)) {
			return;
		}
		c1.setVisible(true);
		c2.setVisible(false);
		enableLaunchCommand(false);
		enableListCommand(true);
	 }

	public void widgetSelected(SelectionEvent e) {
		if (e.widget == viewMessageCommand) {
			launchSelection(viewer.getSelection());
		}
		else if (e.widget == emaiListCommand) {
			c1.setVisible(false);
			c2.setVisible(true);
			enableLaunchCommand(true);
			enableListCommand(false);
		}
	}

	public void widgetDefaultSelected(SelectionEvent arg0) {
		// TODO Auto-generated method stub
	}
}