/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *
 * The Javadoc comments are taken from Crimson 1.1 developed by The Apache Software Foundation
 * and are made available under the terms and conditions of the Apache Software License 1.1
 * which accompanies this distribution and is available at
 * http://www.apache.org/licenses/LICENSE-1.1.
 *
 * All other portions of this file including the functional Java code, are made available under 
 * the terms and conditions of the EPL.
 *******************************************************************************/ 
package javax.xml.parsers;

/**
 * Indicates a serious configuration error.
 *
 * @since JAXP 1.0
 * @version 1.0
 */

public class ParserConfigurationException extends Exception {

	private static final long serialVersionUID = -3688849216575373917L;

/**
 * Create a new <code>ParserConfigurationException</code> with no
 * detail mesage.
 */

public ParserConfigurationException() {
    super();
}

/**
 * Create a new <code>ParserConfigurationException</code> with
 * the <code>String</code> specified as an error message.
 *
 * @param msg The error message for the exception.
 */

public ParserConfigurationException(String msg) {
    super(msg);
}

}