/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.jaxp.implForCore;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.ercp.xml.parser.EXmlMsg;



/**
 * Implementation of the DocumentBuilderFactory
 */
public class DocumentBuilderFactoryImpl extends DocumentBuilderFactory {

/**
 * Constructor for DocumentBuilderFactoryImpl.
 */
public DocumentBuilderFactoryImpl() {
	super();
}

/**
 * @see javax.xml.parsers.DocumentBuilderFactory#getAttribute(String)
 */
public Object getAttribute(String name) throws IllegalArgumentException {
	throw new IllegalArgumentException(name);
}

/**
 * @see javax.xml.parsers.DocumentBuilderFactory#setAttribute(String, Object)
 */
public void setAttribute(String name, Object value) throws IllegalArgumentException {
	throw new IllegalArgumentException(name);
}

/**
 * @see javax.xml.parsers.DocumentBuilderFactory#newDocumentBuilder()
 */
public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
	if (isCoalescing()) {
		throw new ParserConfigurationException(EXmlMsg.getDefault().getString(EXmlMsg.COALESCING_NOT_SUPPORTED)); //$NON-NLS-1$
	} else
	if (isValidating()) {
		throw new ParserConfigurationException(EXmlMsg.getDefault().getString(EXmlMsg.VALIDATION_NOT_SUPPORTED)); //$NON-NLS-1$
	} else
	if (isExpandEntityReferences()) {
		throw new ParserConfigurationException(EXmlMsg.getDefault().getString(EXmlMsg.EXPAND_ENTITY_NOT_SUPPORTED)); //$NON-NLS-1$
	} else
	if (!isIgnoringComments()) {
		throw new ParserConfigurationException(EXmlMsg.getDefault().getString(EXmlMsg.COMMENTS_NOT_SUPPORTED)); //$NON-NLS-1$
	} else
	if (isIgnoringElementContentWhitespace()) {
		throw new ParserConfigurationException(EXmlMsg.getDefault().getString(EXmlMsg.WS_IGNORED_NOT_SUPPORTED)); //$NON-NLS-1$
	}
	return new DocumentBuilderImpl(this);}

}
