/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.jaxp.implForCore;

import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.ercp.xml.dom.DOMImplementationImpl;
import org.eclipse.ercp.xml.dom.DocumentImpl;
import org.eclipse.ercp.xml.parser.AbstractSAXParserImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;


/**
 * Implementation of DocumentBuilder
 */
public class DocumentBuilderImpl extends DocumentBuilder {
	SAXParserImpl parser;
	DOMBuilder builder;
	boolean namespaceAware;
	boolean validating;
	
	static final String LexicalHandlerFullID = AbstractSAXParserImpl.XmlOrgPropertiesPrefix+AbstractSAXParserImpl.LexicalHandlerID;
/**
 * Constructor for DocumentBuilderImpl.
 */
public DocumentBuilderImpl(DocumentBuilderFactory factory) {
	super();
	this.parser = new SAXParserImpl();
	this.builder = new DOMBuilder();
	builder.setNamespacePrefixes(factory.isNamespaceAware());
	builder.setNamespaces(factory.isNamespaceAware());
	parser.setContentHandler(builder);
	try {
		parser.setProperty(LexicalHandlerFullID, builder);
	} catch (SAXNotRecognizedException e) {
	} catch (SAXNotSupportedException e) {
	}
	
}

/**
 * @see javax.xml.parsers.DocumentBuilder#parse(InputSource)
 */
public Document parse(InputSource is) throws SAXException, IOException {
	parser.parse(is);
	return builder.getDocument();
}

/**
 * @see javax.xml.parsers.DocumentBuilder#isNamespaceAware()
 */
public boolean isNamespaceAware() {
	return namespaceAware;
}

/**
 * @see javax.xml.parsers.DocumentBuilder#isValidating()
 */
public boolean isValidating() {
	return validating;
}

/**
 * @see javax.xml.parsers.DocumentBuilder#setEntityResolver(EntityResolver)
 */
public void setEntityResolver(EntityResolver entityResolver) {
	parser.setEntityResolver(entityResolver);
}

/**
 * @see javax.xml.parsers.DocumentBuilder#setErrorHandler(ErrorHandler)
 */
public void setErrorHandler(ErrorHandler errorHandler) {
	parser.setErrorHandler(errorHandler);
}

/**
 * @see javax.xml.parsers.DocumentBuilder#newDocument()
 */
public Document newDocument() {
	return new DocumentImpl();
}

/**
 * @see javax.xml.parsers.DocumentBuilder#getDOMImplementation()
 */
public DOMImplementation getDOMImplementation() {
	return DOMImplementationImpl.getDOMImplementation();
}

}
