/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.jaxp.implForCore;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
/**
 * SAXParserFactory implementation for J2ME and eXML-j2me
 */
public class SAXParserFactoryImpl extends SAXParserFactory {
	SAXParserImpl parser;
/**
 * Constructor for SAXParserFactoryImpl.
 */
public SAXParserFactoryImpl() {
	super();
}
SAXParserImpl getParser() {
	if (parser != null) return parser;
	this.parser = new SAXParserImpl();
	return parser;
}
/**
 * @see javax.xml.parsers.SAXParserFactory#newSAXParser()
 */
public SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
	if (isValidating()) {
		// eXML Parser is not a Validating parser!
		throw new ParserConfigurationException(EXmlMsg.getDefault().getString(EXmlMsg.VALIDATION_NOT_SUPPORTED));
	}
	SAXParserImpl newParser = getParser();
	newParser.setNamespaceAware(isNamespaceAware());
	this.parser = null;
	return newParser;
}
/**
 * @see javax.xml.parsers.SAXParserFactory#getFeature(String)
 */
public boolean getFeature(String name) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
	return getParser().getFeature(name);
}
/**
 *
 * Sets the particular feature in the underlying implementation of
 * org.xml.sax.XMLReader.
 * A list of the core features and properties can be found at
 * <a href="http://www.megginson.com/SAX/Java/features.html"> http://www.megginson.com/SAX/Java/features.html </a>
 *
 * @param name The name of the feature to be set.
 * @param value The value of the feature to be set.
 * @exception SAXNotRecognizedException When the underlying XMLReader does
 *            not recognize the property name.
 *
 * @exception SAXNotSupportedException When the underlying XMLReader
 *            recognizes the property name but doesn't support the
 *            property.
 *
 * @see org.xml.sax.XMLReader#setFeature
 */
public void setFeature(String name, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
	getParser().setFeature(name, value);
}

}
