/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.dom;

import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListImpl implements NodeList {
	protected Vector nodes;
/**
 * Constructor for NodeListImpl
 */
public NodeListImpl() {
	super();
	this.nodes = new Vector(5);
}
/**
 * Returns the <code>index</code>th item in the collection. If 
 * <code>index</code> is greater than or equal to the number of nodes in 
 * the list, this returns <code>null</code>.
 * @param indexIndex into the collection.
 * @return The node at the <code>index</code>th position in the 
 *   <code>NodeList</code>, or <code>null</code> if that is not a valid 
 *   index.
 */
public Node item(int index) {
	try {
		return (Node)nodes.elementAt(index);
	} catch (IndexOutOfBoundsException e) {
		return null;
	}
}
/**
 * The number of nodes in the list. The range of valid child node indices 
 * is 0 to <code>length-1</code> inclusive. 
 */
public int getLength() {
	return nodes.size();
}
void addNode(Node node) {
	nodes.addElement(node);
}
}

