/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.dom;

import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ProcessingInstructionImpl extends CharacterDataImpl implements ProcessingInstruction {
	protected String target;
/**
 * Constructor for ProcessingInstructionImpl
 */
public ProcessingInstructionImpl(DocumentImpl ownerDocument, String target, String data) {
	super(ownerDocument, data);
	this.target = target;
}
/**
 * The target of this processing instruction. XML defines this as being 
 * the first token following the markup that begins the processing 
 * instruction.
 */
public String getTarget() {
	return target;
}
public short getNodeType() {
	return Node.PROCESSING_INSTRUCTION_NODE;
}
public String getNodeName() {
	return target;
}
/**
 * Returns a duplicate of this node, i.e., serves as a generic copy 
 * constructor for nodes. The duplicate node has no parent; (
 * <code>parentNode</code> is <code>null</code>.).
 * <br>Cloning an <code>Element</code> copies all attributes and their 
 * values, including those generated by the XML processor to represent 
 * defaulted attributes, but this method does not copy any text it 
 * contains unless it is a deep clone, since the text is contained in a 
 * child <code>Text</code> node. Cloning an <code>Attribute</code> 
 * directly, as opposed to be cloned as part of an <code>Element</code> 
 * cloning operation, returns a specified attribute (
 * <code>specified</code> is <code>true</code>). Cloning any other type 
 * of node simply returns a copy of this node.
 * <br>Note that cloning an immutable subtree results in a mutable copy, 
 * but the children of an <code>EntityReference</code> clone are readonly
 * . In addition, clones of unspecified <code>Attr</code> nodes are 
 * specified. And, cloning <code>Document</code>, 
 * <code>DocumentType</code>, <code>Entity</code>, and 
 * <code>Notation</code> nodes is implementation dependent.
 * @param deepIf <code>true</code>, recursively clone the subtree under 
 *   the specified node; if <code>false</code>, clone only the node 
 *   itself (and its attributes, if it is an <code>Element</code>). 
 * @return The duplicate node.
 */
public Node cloneNode(boolean deep) {
	return new ProcessingInstructionImpl(ownerDocument, target, data);
}
}

