/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;

/**
 * Defines a set of IO apis which are implemented differently
 * depending on the targetted JCL
 */
public abstract class AbstractIOSpecificCall {
	
	protected AbstractIOSpecificCall() {
		super();
	}

	/**
	 * Constructs a new InputStream on the file named <code>fileName</code>.
	 */
	public abstract InputStream openFileInputStream(String filename)throws IOException;

	/**
	 * Returns a system property wrapped or not by a PrivilegedAction
	 */
	public abstract String getSystemProperty(String property);

	/**
	 * Returns a Reader based on the parameter
	 * 
	 * @param systemID	- URL referencing the resource
	 * @param encoding	- Java encoding to use for the Reader
	 */
	public abstract Reader getReaderFromSystemID(String systemID, String encoding) throws IOException;


	/**
	 * Reads a property file and returns the corresponding Hashtable.
	 */
	public Hashtable readPropertyFile(String filename) {
		return readPropertyFile(filename, new Hashtable());
	}
	public abstract Hashtable readPropertyFile(String filename, Hashtable table);

	/**
	 * Reads a property file and returns the corresponding Hashtable.
	 */
	public Hashtable readPropertyFile(Class aClass, String resource) {
		return readPropertyFile(aClass, resource, new Hashtable());
	}
	public abstract Hashtable readPropertyFile(Class aClass, String resource, Hashtable table);

	/**
	 * Reads a property file from an InputStream,
	 * Stores the couples key-values in the provide Hashtable
	 * and returns the resulting Hashtable.
	 */
	public Hashtable readPropertyFile(InputStream is, Hashtable table) {
		try {
			if (is != null) new PropertyFileReader().read(is, table);
		} catch (IOException e) {
			// NOP
		}
		return table;
	}
}
