/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.io;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;


/**
 * EncodingMap handles conversions between 
 * IANA encoding names and Java encoding names.
 * The encoding names used in XML instance documents
 * be the IANA encoding names specified or one of
 * the aliases for those names which IANA defines.
 * @see ftp://ftp.isi.edu/in-notes/iana/assignments/character-sets
 */
public class IanaJavaMap {
	static Hashtable Iana2Java = null;
	static Hashtable Java2Iana = null;
/**
 * Returns the Java encoding corresponding
 * to the IANA name or alias
 */
public static String getIana2Java(String ianaEncoding) {
	if (ianaEncoding == null) return null;
	
	return (String)(getIana2JavaEncoding().get(ianaEncoding));
}
static Hashtable getIana2JavaEncoding() {
	if (Iana2Java != null) return Iana2Java;
	initializeIana2JavaEncoding();
	return Iana2Java;
}
/**
 * Returns the IANA encoding corresponding
 * to the Java name or alias
 */
public static String getJava2Iana(String javaEncoding) {
	if (javaEncoding == null) return null;
	return (String)getJava2IanaEncoding().get(javaEncoding);
}
static Hashtable getJava2IanaEncoding() {
	if (Java2Iana != null) return Java2Iana;
	initializeJava2IanaEncoding();
	return Java2Iana;
}
static void initializeIana2JavaEncoding() {
	Iana2Java = new Hashtable();
	// Some default IANA to Java keys!
	Iana2Java.put("US-ASCII",		"US-ASCII");
	Iana2Java.put("Big5",			"Big5");
	Iana2Java.put("euc-jp",			"eucjis");
	Iana2Java.put("EUC-KR",			"EUCKR");
	Iana2Java.put("iso-2020-jp", 	"JIS");
	Iana2Java.put("Shift_JIS",		"SJIS");
	Iana2Java.put("ISO-8859-1",		"ISO8859-1");
	Iana2Java.put("UTF-16",			"UTF-16");
	Iana2Java.put("UTF-16BE",		"UTF-16BE");
	Iana2Java.put("UTF-16LE",		"UTF-16LE");
	Iana2Java.put("UTF-8",			"UTF-8");	
	IOSpecificCall.getDefault().readPropertyFile(IanaJavaMap.class, "iana-to-java.properties", Iana2Java); //$NON-NLS-1
}
static void initializeJava2IanaEncoding() {
	Hashtable ianaTable = getIana2JavaEncoding();
	Java2Iana = new Hashtable();
	Enumeration keys = ianaTable.keys();
	String ianaKey;
	while (keys.hasMoreElements()) {
		ianaKey = (String)(keys.nextElement());
		Java2Iana.put(ianaTable.get(ianaKey), ianaKey);
	}
}
public static void appendIana2JavaFile(InputStream stream) {
	IOSpecificCall.getDefault().readPropertyFile(stream, getIana2JavaEncoding());
	updateJava2IanaEncoding();
}
static void updateJava2IanaEncoding() {
	String ianaKey, javaKey;
	Hashtable ianaTable = getIana2JavaEncoding();
	Enumeration keys = ianaTable.keys();
	Hashtable javaTable = getJava2IanaEncoding();
	while (keys.hasMoreElements()) {
		ianaKey = (String)(keys.nextElement());
		javaKey = (String)ianaTable.get(ianaKey);
		javaTable.put(javaKey, ianaKey);
	}
}
public static void putIana2Java(String ianaKey, String javaKey) {
	Hashtable ianaTable = getIana2JavaEncoding();
	Hashtable javaTable = getJava2IanaEncoding();
	ianaTable.put(ianaKey, javaKey);
	javaTable.put(javaKey, ianaKey);
}
}

