/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.io;

import java.io.IOException;
import java.io.Reader;
/**
 * Optimized CharacterConverter
 */
abstract class StreamDecoder extends Reader {
	protected SimpleBufferedInputStream stream;
	String encoding;
	char[] oneCharArray = new char[1];
	// Optimized Java Stream Decoding
	static final String UTF8_Encoding		= "UTF-8"; //$NON-NLS-1$
	static final String UTF16BE_Encoding	= "UTF-16BE"; //$NON-NLS-1$
	static final String UTF16LE_Encoding	= "UTF-16LE"; //$NON-NLS-1$
	static final String ASCII_Encoding	= "ASCII"; //$NON-NLS-1$
	static final String ISO8859_1_Encoding = "ISO8859_1"; //$NON-NLS-1$
/**
 * Constructor for StreamDecoder.
 */
protected StreamDecoder(SimpleBufferedInputStream stream, String encoding) {
	super();
	this.stream = stream;
	this.encoding = encoding;
}
/**
 * Close this Reader.  This must be implemented by any concrete subclasses.  The
 * implementation should free any resources associated with the Reader.
 *
 * @version		initial
 *
 *
 * @exception 	java.io.IOException	If an error occurs attempting to close this Reader.
 */
public void close() throws IOException {
	stream.close();
}
/**
 * Reads a single character from this reader and returns the result as
 * an int.  The 2 higher-order characters are set to 0. If the end of reader was encountered
 * then return -1.
 *
 * @return 		the character read or -1 if end of reader.
 *
 * @exception 	java.io.IOException If the Reader is already closed or some other IO error occurs.
 */
public int read() throws IOException {
	return (read(oneCharArray, 0, 1) != -1)?oneCharArray[0]:-1;
}
/**
 * Reads at most <code>count</code> characters from this Reader and stores them
 * at <code>offset</code> in the character array <code>buf</code>.  Returns the
 * number of characters actually read or -1 if the end of reader was encountered.
 *
 * @version		initial
 *
 * @param 		buf		character array to store the read characters
 * @param 		offset 	offset in buf to store the read characters
 * @param 		count 	maximum number of characters to read
 * @return		the number of characters read or -1 if end of reader.
 *
 * @exception 	java.io.IOException If the Reader is already closed or some other IO error occurs.
 */
public abstract int read(char buf[], int offset, int count) throws IOException;
/**
 * Return tru if the receiver didn't affect the InputStream
 * not allowing the switch to another encoding
 */
public boolean supportNewEncoding() {
	return true;
}
/**
 * If the decoder read too much bytes during the last read
 * (cf. UTF8) restore them!
 */
public void restore() {
	// NOP
}
/**
 * Return the encoding name
 */
public String getEncoding() {
	return encoding;
}
}
