/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.io;

import java.io.IOException;

/**
 * StreamDecoder for the ASCII encoding
 */
public class StreamDecoder_ASCII extends StreamDecoder {

/**
 * Constructor for StreamDecoder_ISO8859_1.
 * @param stream
 */
public StreamDecoder_ASCII(SimpleBufferedInputStream stream) {
	super(stream, ASCII_Encoding);
}

/**
 * @see org.eclipse.ercp.sax2.parser.StreamDecoder#close()
 */
public void close() throws IOException {
	stream.close();
}
/**
 * @see org.eclipse.ercp.sax2.parser.StreamDecoder#read()
 */
public int read() throws IOException {
	int c = stream.read();
	if (c == -1) return -1;
	char data = (char)c;
	return (data <= '\u007f')?data:0xfffd;
}

/**
 * @see org.eclipse.ercp.sax2.parser.StreamDecoder#read(char[], int, int)
 */
public int read(char[] buf, int offset, int count) throws IOException {
	byte[] bytes = new byte[count];
	int available = stream.read(bytes, 0, count);
	int charOffset = offset;
	char data;
	for (int i = 0; i < available; i++) {
		data = (char)(bytes[i]);
		buf[charOffset++] = (data <= '\u007f')?data:0xfffd;
	}
	return available;
}
}
