/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.io;

import java.io.IOException;

/**
 * StreamDecoder for the ISO8859_1 encoding
 * ==> One byte ==> One char!
 */
public class StreamDecoder_ISO8859_1 extends StreamDecoder {

/**
 * Constructor for StreamDecoder_ISO8859_1.
 * @param stream
 */
public StreamDecoder_ISO8859_1(SimpleBufferedInputStream stream) {
	super(stream, ISO8859_1_Encoding);
}
/**
 * @see org.eclipse.ercp.sax2.parser.StreamDecoder#read()
 */
public int read() throws IOException {
	return stream.read();
}

/**
 * @see org.eclipse.ercp.sax2.parser.StreamDecoder#read(char[], int, int)
 */
public int read(char[] buf, int offset, int count) throws IOException {
	byte[] bytes = new byte[count];
	int available = stream.read(bytes, 0, count);
	int charOffset = offset;
	for (int i = 0; i < available; i++) {
		buf[charOffset++] = (char)(bytes[i]);
	}
	return available;
}
}
