/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.io;

import java.io.IOException;

import org.eclipse.ercp.xml.parser.EXmlMsg;


/**
 * StreamDecoder for the UTF16 Big Endian encoding
 */
public class StreamDecoder_UTF16BE extends StreamDecoder {

/**
 * Constructor for StreamDecoder_UTF16BE.
 * @param stream
 */
public StreamDecoder_UTF16BE(SimpleBufferedInputStream stream) {
	super(stream, UTF16BE_Encoding);
}

/**
 * @see org.eclipse.ercp.xml.io.StreamDecoder#read(char[], int, int)
 */
public int read(char[] buf, int offset, int count) throws IOException {
	if (count <= 0) return count;
	int charOffset = offset;
	byte[] b = new byte[2*count];
	int available = stream.read(b, 0, 2*count);
	if (available == -1) return -1;
	int pos = 0;
	int end = available - 1;
	while (pos < end) {
		buf[charOffset++] = (char)(((0xFF & b[pos++]) << 8) | (0xFF & b[pos++]));
    }
	if (pos != available) throw new IOException(EXmlMsg.getDefault().getString(EXmlMsg.MALFORMED_UTF16BE, Integer.toHexString(b[available-1]))); //$NON-NLS-1$
    return charOffset - offset;
}

}
