/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.parser;
 
import java.util.Hashtable;

/**
 *	Decodes special XML characters like:
 *			&lt;
 *			&amp;
 *			&gt;
 *			&apos;
 *			&quot;
 *			&#nnnn;		Unicode character in decimal
 *			&#xnnnn;	Unicode character in hexadecimal
 *			&nbsp;
 *
 */
public class CharDecoder
{
	private Hashtable chars = new Hashtable();
/**
 * Constructor
 */
public CharDecoder() {
	super();
}
/**
 * Return the character associated to the name
 * if it exists, else return null.
 */
public String getCharValue(String name) {
	Object value = chars.get(name);
	if (value != null) return (String)value;	// Most frequent situation.
	try {
		if (name.charAt(0) == '#') {// It's a Unicode Character 
			if (name.charAt(1) == 'x') {// It's a Unicode Character specified in Hexadecimal.
				int cValue = Integer.parseInt(name.substring(2), 16);
				char[] character = new char[1];
				character[0] = (char)cValue;
				return new String(character, 0, 1);
			} else {
				int cValue = Integer.parseInt(name.substring(1), 10);
				char[] character = new char[1];
				character[0] = (char)cValue;
				return new String(character, 0, 1);
			}
		}
	} catch (NumberFormatException e) {
		// a parsing pb raised
	}
	return null;
}
/**
 * Return a copy of the current character table.
 */
public Hashtable getTable() {
//	return (Hashtable)chars.clone();
	return chars; // No clone available on CLDC !!!
}
/**
 * Return a new CharDecoder with the predefined entities
 */
public static CharDecoder forXml() {
	CharDecoder decoder = new CharDecoder();
	decoder.setCharValue("amp",		"&"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("lt",		"<"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("gt",		">"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("apos",	"'"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("quot", 	"\""); //$NON-NLS-2$ //$NON-NLS-1$
	return decoder;	
}
/**
 * Set a CharDecoder with the main HTML characters id
 */
public static CharDecoder htmlCharacters() {
	CharDecoder decoder = new CharDecoder();
	decoder.setCharValue("amp",		"&"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("lt",		"<"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("gt",		">"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("apos",	"'"); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("quot", 	"\""); //$NON-NLS-2$ //$NON-NLS-1$
	decoder.setCharValue("nbsp", 	"\u00a0"); // non breaking space //$NON-NLS-2$ //$NON-NLS-1$
	return decoder;	
}

/**
 * Set the key-value decoding association
 */
public void setCharValue(String name, String value) {
	chars.put(name,value);
}
}