/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ercp.xml.parser;

public class NSDeclaration {
	String tagNameOwnerPrefix;
	String tagNameOwner;
	NSDeclaration parent;
	String[][] declarations;
	String defaultNS;
	int elementCount;
	static int CapacityIncrement = 5;
/**
 * Constructors for NameSpaceDeclaration
 */
NSDeclaration() {
	super();
	this.tagNameOwnerPrefix = null;
	this.tagNameOwner = null;
	this.parent = null;
	this.defaultNS = "";
	//addDeclaration("xml", "http://www.w3.org/XML/1998/namespace");
	this.elementCount = 1;
	this.declarations = new String[][] {
		{"xml", "http://www.w3.org/XML/1998/namespace"}		//$NON-NLS-2$ //$NON-NLS-1$
	};
	
}
NSDeclaration(String tagName, NSDeclaration parent) {
	this(null, tagName, parent);
}
NSDeclaration(String prefix, String tagName, NSDeclaration parent) {
	super();
	this.tagNameOwnerPrefix = prefix;
	this.tagNameOwner = tagName;
	this.parent = parent;
	this.elementCount = 0;
	this.declarations = null;
	//this.defaultNS = parent.getDefaultNS();
	this.defaultNS = null;
}
public void addDeclaration(String prefix, String uri) {
	if (prefix.length() == 0) defaultNS = uri;
	if ((declarations == null) || (elementCount == declarations.length)) grow();
	declarations[elementCount++] = new String[]{prefix, uri};
}
private void grow() {
	String[][] newDecl = new String[elementCount+CapacityIncrement][2];
	if (declarations != null) {
		System.arraycopy(declarations, 0, newDecl, 0, elementCount);
	}
	declarations = newDecl;
}
public String[][] getDeclarations() {
	if (declarations == null) {
		return null;
	} else {
		String[][] res = new String[elementCount][2];
		System.arraycopy(declarations, 0, res, 0, elementCount);
		return res;
	}

}
/**
 * Return the URI associated to the prefix namespace for an attribute, "" if not!
 */
public String getUriFor(String prefix) {
	if ((prefix == null) || (prefix.length() == 0)) return getDefaultNS();
	return primGetUriFor(prefix);
}
public String getUriOnAttributeFor(String prefix) {
	// Fixing PR#176980: The spec says:
	// A default namespace declaration applies to all unprefixed element names within
	// its scope. Default namespace declarations do not apply directly to attribute
	// names; the interpretation of unprefixed attributes is determined by the element
	// on which they appear.
	if ((prefix == null) || (prefix.length() == 0)) return "";
	return primGetUriFor(prefix);
}
String getDefaultNS() {
	if (defaultNS != null) return defaultNS;
	if (parent != null) return parent.getDefaultNS();
	return "";
}
/**
 * 'prefix' is != ""
 */
private String primGetUriFor(String prefix) {
	if (declarations != null) {
		for (int i = 0; i < elementCount; i++) {
			if (prefix.equals(declarations[i][0])) return declarations[i][1];
		}
	}
	if (parent != null) {
		return parent.primGetUriFor(prefix);
	} else {
		return "";
	}				
}
/**
 */
public boolean isNamed(String namespace, String tagname) {
	if (namespace == null) {
		return (tagNameOwnerPrefix == null) && (tagname.equals(tagNameOwner));
	} else {
		return (namespace.equals(tagNameOwnerPrefix)) && (tagname.equals(tagNameOwner));
	}	
}
}