/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Browser;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;


public class BrowserShowCase extends ShowCase implements SelectionListener {

    Command commandBack;
    Command commandForward;
    Command commandExit;
    Browser browser;
    
    public BrowserShowCase(){
    }
    
    public String getName() {
        return Messages.getString("BrowserShowCase.0"); //$NON-NLS-1$
    }
    
    protected void show() {
        
        getComposite().setLayout(new FillLayout());
        browser = new Browser(getComposite(), SWT.NONE);
        browser.setUrl("http://www.eclipse.org/ercp/main.html"); //$NON-NLS-1$

        
        //  - Commands
        commandBack = new Command(getComposite(), Command.SELECT, 10);
        commandBack.setText(Messages.getString("BrowserShowCase.2")); //$NON-NLS-1$
        commandBack.setLongLabel(Messages.getString("BrowserShowCase.3")); //$NON-NLS-1$
        commandBack.addSelectionListener(this);
        
        commandForward = new Command(getComposite(), Command.SELECT, 9);
        commandForward.setText(Messages.getString("BrowserShowCase.4")); //$NON-NLS-1$
        commandForward.setLongLabel(Messages.getString("BrowserShowCase.5")); //$NON-NLS-1$
        commandForward.addSelectionListener(this);
        
        commandExit = new Command(getComposite(), Command.EXIT, 0);
        commandExit.setText(Messages.getString("BrowserShowCase.6")); //$NON-NLS-1$
        commandExit.setLongLabel(Messages.getString("BrowserShowCase.7")); //$NON-NLS-1$
        commandExit.addSelectionListener(this);
        
        browser.addLocationListener(new LocationListener() {
        	public void changing(LocationEvent e) {}
        	public void changed(LocationEvent e) {
        		commandBack.setEnabled(browser.isBackEnabled());
        		commandForward.setEnabled(browser.isForwardEnabled());
        	}
        });
	    
        getComposite().layout();
        browser.setFocus();
        
        return ;
    }
    
    public void widgetSelected(SelectionEvent e) {
    	if (e.widget == commandBack) {
    		browser.back();
    	} else if (e.widget == commandForward) {
    		browser.forward();
    	} else if (e.widget == commandExit) {
    	   	browser.dispose();
           	commandBack.dispose();
        	commandForward.dispose();
        	commandExit.dispose();
        	dispose();
    	}	
    }
 
    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

}
