/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;



import java.util.*;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;



public class CalendarDataBase {
	
	
	Vector entries;
	
	public CalendarDataBase() {
		entries = new Vector(); 
	}
	
	public void addEntry(CalendarDataBaseEntry entry) {

	    int index;
	    for (index = 0; index < entries.size(); index++){
	        if(entry.getStartDate().getTime() < ((CalendarDataBaseEntry)entries.get(index)).getStartDate().getTime())
	            break;
	    }
		entries.insertElementAt(entry,index);
	}
	
	public void removeEntry(CalendarDataBaseEntry entry) {
	    entries.remove(entry);
	}
	
	public Vector getEntriesOfTheDay(Date date) {
		Vector result = new Vector();
		for (int i=0;i<entries.size();i++) {
			CalendarDataBaseEntry entrytotest =( (CalendarDataBaseEntry)entries.get(i));
			Date startDate = entrytotest.getStartDate();
			GregorianCalendar g = new GregorianCalendar();
			g.setTime(date);
			GregorianCalendar gtotest = new GregorianCalendar();
			gtotest.setTime(startDate);
			if (((g.get(Calendar.YEAR)) == (gtotest.get(Calendar.YEAR))) &&
				((g.get(Calendar.DAY_OF_YEAR)) == (gtotest.get(Calendar.DAY_OF_YEAR)))) {
				result.addElement((CalendarDataBaseEntry)entries.get(i));
			}
		}
		return result;
	}
	
	boolean meetingThisDay(Date date) {
	    GregorianCalendar g = new GregorianCalendar();
		g.setTime(date);
		for (int i=0;i<entries.size();i++) {
			CalendarDataBaseEntry entrytotest =( (CalendarDataBaseEntry)entries.get(i));
			Date startDate = entrytotest.getStartDate();
			GregorianCalendar gtotest = new GregorianCalendar();
			gtotest.setTime(startDate);
			if (((g.get(Calendar.YEAR)) == (gtotest.get(Calendar.YEAR))) &&
				((g.get(Calendar.DAY_OF_YEAR)) == (gtotest.get(Calendar.DAY_OF_YEAR)))) {
				return true;
			}
		}	    
	    return false;
	}
	
	/**
	 * Fill the database with some meetings
	 *
	 */
	public void buildSample() {
		
		// clear
		entries.clear();
		
		Date startdate;
		Date enddate;
		GregorianCalendar cal = new GregorianCalendar(); 
		
		// one meeting today, now, for one hour
		cal.setTime(new Date());
		cal.set(Calendar.MINUTE,0);
		startdate = cal.getTime();
		cal.add(Calendar.HOUR_OF_DAY,1);
		enddate = cal.getTime();
		CalendarDataBaseEntry e1 = new CalendarDataBaseEntry(startdate, enddate, Messages.getString("CalendarDataBase.0"), Messages.getString("CalendarDataBase.1"), Messages.getString("CalendarDataBase.2"));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		
		// one meeting tomorrow, 12h00 for 30 minutes
		cal.setTime(new Date());
		cal.add(Calendar.DAY_OF_MONTH,1);
		cal.set(Calendar.HOUR_OF_DAY,12);
		cal.set(Calendar.MINUTE,0);
		startdate=cal.getTime();
		cal.add(Calendar.MINUTE,30);
		enddate = cal.getTime();
		CalendarDataBaseEntry e2 = new CalendarDataBaseEntry(startdate, enddate, Messages.getString("CalendarDataBase.3"), Messages.getString("CalendarDataBase.4"), null);  //$NON-NLS-1$ //$NON-NLS-2$
		
		// one meeting tomorrow, 16h30 for 15 minutes hour
		cal.setTime(new Date());
		cal.add(Calendar.DAY_OF_MONTH,1);
		cal.set(Calendar.HOUR_OF_DAY,16);
		cal.set(Calendar.MINUTE,30);
		startdate=cal.getTime();
		cal.add(Calendar.MINUTE,15);
		enddate = cal.getTime();
		CalendarDataBaseEntry e3 = new CalendarDataBaseEntry(startdate, enddate, Messages.getString("CalendarDataBase.5"), Messages.getString("CalendarDataBase.6"), null);  //$NON-NLS-1$ //$NON-NLS-2$
		
		// populate the database
		addEntry(e1);
		addEntry(e2);
		addEntry(e3);
	}
}
