/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;


import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;



public class CalendarDataBaseEntry {

	private Date 	startdate;
	private Date 	enddate;
	private String 	location;
	private String 	description;
	private String  notes;
	
	/**
	 * 
	 */
	public CalendarDataBaseEntry(Date startdate, Date enddate, String description, String location, String notes) {
		this.startdate = startdate;
		this.enddate = enddate;
		this.description = description;
		this.location = location;
		this.notes = notes;
	}
	
	public Object clone() {
	    try {
	        super.clone();
	    } catch (Throwable t) {
	        
	    }
	    return new CalendarDataBaseEntry(startdate, enddate, description , location, notes );
	}
	
	public Date getStartDate() {
		if (startdate == null) {
			System.out.println("startdate is null, returning cur date"); //$NON-NLS-1$
			return new Date();
		} else {
			return startdate;
		}
	}
	
	public Date getEndDate() {
		if (enddate == null) {
			System.out.println("enddate is null, returning cur date"); //$NON-NLS-1$
			return new Date();
		} else {
			return enddate;
		}
	}
	
	public String getDescription() {
		return description;
	}
	
	public String getLocation() {
		return location;
	}
	
	public String getNotes() {
	    return notes;
	}
	
	public void setStartDate(Date date) {
		startdate = date;
	}
	
	public void setEndDate(Date date) {
		enddate = date;
	}
	
	public void setDescription(String desc) {
		description = desc;
	}
	
	public void setLocation(String loc) {
		location = loc;
	}
	
	public void setNotes(String notes) {
	    this.notes = notes;
	}
	
	public String toString() {
	    String result = buildStartOfToString();
	    result = result += buildEnfOfToString();
	    return result;
	}
	
	private String buildStartOfToString(){
	    String result = ""; //$NON-NLS-1$
		if (startdate!=null) {
			GregorianCalendar g = new GregorianCalendar();
			g.setTime(startdate);
			Integer h = new Integer(g.get(Calendar.HOUR_OF_DAY));
			result+=h.toString();
			result+=":"; //$NON-NLS-1$
			Integer m = new Integer(g.get(Calendar.MINUTE));
			if (m.intValue()<10) {
				result+="0";	 //$NON-NLS-1$
			}
			result+=m.toString();
			if (enddate!=null) {
				result+="-"; //$NON-NLS-1$
			}
		}
		return result;
	}
	
	private String buildEnfOfToString(){
	    String result = ""; //$NON-NLS-1$
		if (description!=null) {
			result+=" "+description; //$NON-NLS-1$
		}
		if (location!=null) {
			result+=" @("+location+")"; //$NON-NLS-1$ //$NON-NLS-2$
		}
		return result;	    
	}
	
	public String toStringLarge() {
	    String result = buildStartOfToString();
		// do not display enddate for the moment (not enough space)
		if (enddate!=null) {
			GregorianCalendar g = new GregorianCalendar();
			g.setTime(enddate);
			Integer h = new Integer(g.get(Calendar.HOUR_OF_DAY));
			result+=h.toString();
			result+=":"; //$NON-NLS-1$
			Integer m = new Integer(g.get(Calendar.MINUTE));
			if (m.intValue()<10) {
				result+="0";	 //$NON-NLS-1$
			}
			result+=m.toString();
		}
	    result = result += buildEnfOfToString();
		return result;
	}
	
}
