/*
 * Created on Jul 20, 2005
 *
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale; 
import java.util.Vector;
import java.text.DateFormat;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;



public class CalendarDayViewScreen implements KeyListener, SelectionListener {


    static private final int column_first = 0;
    static private final int column_second = 1;
    static private final int hour_nb = 16;
    static private final int start_hour = 6;
    static private final int end_hour = 21;
	// TODO : making an class "util" with stringDaysoftheWeek and other usefull methods used in calendar to manage date
//	static private final String[] stringDaysoftheWeek = { "Monday", "Tuesday" ,"Wednesday" ,"Thursday", "Friday", "Saturday", "Sunday"};

    static private CalendarDayViewScreen singleton = null;
	
    private Vector entriesoftheday;
    private Vector entriesInTable;

    private Date displayedDate;
    
	private CalendarShowCase calendarShowCase;
    private CalendarDataBase calendardatabase;
    
    private Shell shell;
    private GregorianCalendar g;
    
	private Command commandEditEntry;
	private Command commandNewEntry;
	private Command commandGoToDate;
	private Command commandExit;
	private Command commandChangeView;		
	private Shell monthShell= null;
	
	// Table:
	private Table table;
	private Font fontColumn1;
	private Font fontColumn2;
	
	private boolean quit = false;
	
	
	static public CalendarDayViewScreen createUniqueInstance (CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase){
	    if (singleton == null) {
	        singleton = new CalendarDayViewScreen ( calendarShowCase,  calendardatabase);
	    }
	    return singleton;
	}
	
	private CalendarDayViewScreen (CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
 
	    this.calendarShowCase = calendarShowCase;
        this.calendardatabase = calendardatabase;
        entriesInTable = new Vector(); 
        quit = false;
    }
	
	private void  buildRessources(){
	    shell = new Shell(calendarShowCase.getComposite().getShell(), SWT.MAX | SWT.TITLE);
	    
	    Rectangle bgdArea = calendarShowCase.getComposite().getShell().getBounds();
	    	shell.setBounds(bgdArea);
	  	    
	    g = new GregorianCalendar();
	}
	
	// Method  call to switch to the calendar day view screen
    public void activate(Shell monthShell,Date currentDay) { 

    	this.monthShell=monthShell;
        displayedDate = new Date();
        displayedDate.setTime(currentDay.getTime());
        entriesoftheday = calendardatabase.getEntriesOfTheDay(displayedDate);
        buildRessources();
        build();
    }
    
    public Date getDisplayedDate(){
        return (Date)displayedDate.clone();
    }
    
     private void build() {
    	   	    
	    // create commands
	    commandExit = new Command(shell, Command.EXIT, 0);
		commandExit.setText(Messages.getString("CalendarDayViewScreen.0")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("CalendarDayViewScreen.1")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);
	    
		commandGoToDate = new Command(shell, Command.GENERAL, 2);
		commandGoToDate.setText(Messages.getString("CalendarDayViewScreen.2")); //$NON-NLS-1$
		commandGoToDate.addSelectionListener(this);
		
		commandChangeView = new Command (shell, Command.GENERAL, 3);
		commandChangeView.setText(Messages.getString("CalendarDayViewScreen.3")); //$NON-NLS-1$
		commandChangeView.addSelectionListener(this);
			   
        // build the table item
        buildTable();
        if(table != null)
	    	table.forceFocus();
        
        setInitialSelection();
        // now that the table exist we can create the Edit setEditCommands();
        setEditCommands();
	    
		
	    // shell settings
	    shell.setText(HeaderfromDate());
	    shell.setLayout(new FillLayout());
	    shell.open();
	    shell.layout();
	    
	 
		final Display display = shell.getDisplay();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
			    display.sleep();
			}
		}
		return ;
    }
    
    private void setInitialSelection() {
        //TODO : improve the way the initial selection is made
        table.select(0);
    }
    
    private void buildTable(){
	    if(table != null) {
	        table.dispose();
	    }
        table = new Table(shell, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);

	    final TableColumn testcolumn1 = new TableColumn(table, SWT.BORDER);
	    final TableColumn testcolumn2 = new TableColumn(table,SWT.BORDER);	    
	     
		// create fonts
        fontColumn1 = table.getFont();
        
        final FontData fontData[] = fontColumn1.getFontData();
        fontColumn2 = new Font(shell.getDisplay(), fontData[0]);
        
        fontData[0].setStyle(fontData[0].getStyle() | SWT.ITALIC);       
        fontColumn1 = new Font(shell.getDisplay(),fontData[0]);
        
	    // fill table with initial data
	    fillTable();

	    // Compute size...
	    testcolumn1.pack();
	
	    final int width = testcolumn1.getWidth();
        final Rectangle area = shell.getClientArea();
        testcolumn2.setWidth(area.width-width);

        // add listener
	    table.addKeyListener(this);
	    table.addSelectionListener(this);
    }

    public void dispose() {
        limitedDispose();
        if (shell != null)
            shell.dispose();
  }

    private void limitedDispose(){
        if (table != null){
            if (!table.isDisposed()){
	            table.setVisible(false);
	            table.removeAll();
	            table.dispose();
	        }
        }
        if (fontColumn1 != null)
            if(!fontColumn1.isDisposed())
                fontColumn1.dispose();
        if (fontColumn2 != null)
            if(!fontColumn2.isDisposed())
                fontColumn2.dispose();
    	if (commandEditEntry != null) commandEditEntry = null;
    	if (commandNewEntry != null ) commandNewEntry = null;
    	if (commandGoToDate != null) commandGoToDate = null;
    	if (commandExit != null ) commandExit = null;
    	if (commandChangeView != null) commandChangeView = null;
    	g=null;
    }
    

	/**
	 * Set the commands of the list (can be "New Entry" or "Edit") 
	 * depending on what item is focused in the list
	 */
	private void setEditCommands() {
	    
	    int index = table.getSelectionIndex();
	    //TODO : is this needed ?
	    if (index == -1) return;
	    
	    if (entriesInTable.get(index) != null ) {
			// tableItem containd data so edit is possible and new entry is not possible
	        if (commandEditEntry == null) {
				if (commandNewEntry!=null) {
					commandNewEntry.removeSelectionListener(this);
					commandNewEntry.dispose();
					commandNewEntry=null;
				}
				commandEditEntry = new Command(shell,Command.GENERAL,5);
				commandEditEntry.setText(Messages.getString("CalendarDayViewScreen.4")); //$NON-NLS-1$
				commandEditEntry.setLongLabel(Messages.getString("CalendarDayViewScreen.5")); //$NON-NLS-1$
				commandEditEntry.addSelectionListener(this);
				commandEditEntry.setDefaultCommand();
			}
		}
		else  {
			if (commandNewEntry==null) {
				if (commandEditEntry!=null) {
					commandEditEntry.removeSelectionListener(this);
					commandEditEntry.dispose();
					commandEditEntry=null;
				}
				commandNewEntry = new Command(shell,Command.GENERAL,5);
				commandNewEntry.setText(Messages.getString("CalendarDayViewScreen.6")); //$NON-NLS-1$
				commandNewEntry.setLongLabel(Messages.getString("CalendarDayViewScreen.7")); //$NON-NLS-1$
				commandNewEntry.addSelectionListener(this);
				commandNewEntry.setDefaultCommand();			
			}
		}
		
	}	

    private void resetTable() {
        resetVectors();
        table.setVisible(false);
        table.removeAll();
        fillTable();
        table.setVisible(true);
    }
    
    
    private String HeaderfromDate(){
        //  NTH : duplicated code in CalendartEditDayView.java. See: setTitle(Date date)
        g.setTime(displayedDate);
        String newTitle = ""; //= stringDaysoftheWeek[g.get(Calendar.DAY_OF_WEEK)-1]+" ";  //$NON-NLS-1$
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getDateInstance(DateFormat.FULL, locale);
        newTitle += dateFormat.format(displayedDate);
        return newTitle;
    }


    /*
     * This method fill the table with the database entry. Do not call it directly but prefer calling resetTable if needed.
     */
	private void fillTable() {
	    
	    int currentElement = 0;	// refers to entriesoftheday
	    int currentRow = 0;		// the number of row in tabel and in entriesInTable
	    
	    entriesInTable.clear();
	    for(int hour = start_hour ; hour < start_hour + hour_nb ; hour++) {

	        if (currentElement >= entriesoftheday.size()) {
	            fillRowsInTable(hour, currentRow);
	            break;
	        }
	        
            g.setTime(((CalendarDataBaseEntry)entriesoftheday.get(currentElement)).getStartDate());
            Integer entryHour = new Integer(g.get(Calendar.HOUR_OF_DAY));
            Integer integerHour = new Integer(hour);
            
            if(entryHour.intValue() < start_hour)
                entryHour = new Integer(start_hour);
            if(entryHour.intValue() > end_hour)
                entryHour = new Integer(end_hour);
            
	        if(entryHour.intValue() == hour ) {
	            // -1- create row with hour and related description
	            TableItem item = new TableItem(table, SWT.LEFT, currentRow);
	            item.setText(column_first,hourToTableHour(integerHour).toString());
	            item.setText(column_second, ((CalendarDataBaseEntry)entriesoftheday.get(currentElement)).toStringLarge());
	            entriesInTable.add(entriesoftheday.get(currentElement));
	            ++currentElement;
	            ++currentRow;
	            // -2- create rows whithout displaying hour but with meeting description if starting at the same hour
	            while( currentElement < entriesoftheday.size() ){
	                g.setTime( ((CalendarDataBaseEntry)entriesoftheday.get(currentElement)).getStartDate());
	                entryHour = new Integer(g.get(Calendar.HOUR_OF_DAY));
	                
	                if ( entryHour.intValue() == hour ) {
	    	            TableItem itemNoHour = new TableItem(table, SWT.LEFT, currentRow);
	    	            itemNoHour.setText(column_second, ((CalendarDataBaseEntry)entriesoftheday.get(currentElement)).toStringLarge());
	    	            entriesInTable.add(entriesoftheday.get(currentElement));
	    	            ++currentElement;
	    	            ++currentRow;
	                } else {
	                    break;
	                }
	            }

	        } else {
	            // create empty row with corresponding time
	            TableItem item = new TableItem(table, SWT.LEFT, currentRow);
	            item.setText(column_first,hourToTableHour(integerHour).toString());	
	            entriesInTable.add(null);
	            ++currentRow;
	        }
	   
	    }
	    decorateTable();
	}
	

	
	
	/*
	 * Build and Fill the first column (only) of the table whith corresponding hour
	 * hour : the current hour to insert into the table
	 * currentrow : the actual row of the table
	 */
	private void fillRowsInTable(int hour, int currentRow) {
	    for(int counter = hour; counter < hour_nb + start_hour ; counter++) {
            TableItem item = new TableItem(table, SWT.LEFT, currentRow);
            Integer integerHour = new Integer(counter);
            item.setText(column_first,hourToTableHour(integerHour).toString());	 
            entriesInTable.add(null);
            ++currentRow;
	    }
	}
	
	/**
	 * Converts a hour from the following format [0 to 24] towards the following one : [0 to 12 - 1 to 12 ]
	 */
	private Integer hourToTableHour(Integer actualHour){
	    if(actualHour.intValue() > 12){
	        return new Integer(actualHour.intValue()-12);
	    }
	    else return new Integer(actualHour.intValue());
	}
    /**
     * Converts a hour extracted from the table item at a specific row and then transform it into a hour in the following format: [0 to 24]  
     */
	private int tableHourtoHour(int selectedRowIndex){
	    TableItem currentItem = table.getItem(table.getSelectionIndex());
	    int result = Integer.parseInt(currentItem.getText(column_first));
	    
	    if (result == 12)
	        return 12;
	    
	    while(--selectedRowIndex > 0){
	        currentItem = table.getItem(selectedRowIndex);
	        if(Integer.parseInt(currentItem.getText(column_first)) == 12) {
	            // selected row was XX XX PM
	            return result+12;
	        }
	    }
	    return result;
	}
	
	private Date CreateDate (int hour){
	g.setTime(displayedDate);
	g.set(Calendar.HOUR_OF_DAY ,hour);
	g.set(Calendar.MINUTE,0);
	g.set(Calendar.SECOND,0);
	Date startDate = g.getTime();
	return startDate;
	}
	
	
	private void decorateTable() { 
	    for(int row = 0; row < table.getItemCount(); ++row){
	        TableItem item = table.getItem(row);
	           if(item == null)
	                break;
	        item.setFont(column_first,fontColumn1);
            item.setFont(column_second, fontColumn2);
            item.setBackground(column_first, shell.getDisplay().getSystemColor(SWT.COLOR_WIDGET_NORMAL_SHADOW ));
	    }
	}
	
	/**
	 * Creates a new entry.
	 */
	private void createNewEntry() {
	    // default dates for the new Entry
	    int indexOfSelected = table.getSelectionIndex();
	    int hour = tableHourtoHour(indexOfSelected);
	    Date startDate = CreateDate(hour);
	    
	    CalendarDataBaseEntry newentry = new CalendarDataBaseEntry(startDate, startDate, Messages.getString("CalendarDayViewScreen.9"), Messages.getString("CalendarDayViewScreen.10"), null); //$NON-NLS-1$ //$NON-NLS-2$
	    OpenEditDialogAndManageResult(newentry, indexOfSelected, true);
	    }
	
	private void editEntry(){
	    int indexOfSelected = table.getSelectionIndex();
	    CalendarDataBaseEntry entry = (CalendarDataBaseEntry)entriesInTable.get(indexOfSelected);
	    OpenEditDialogAndManageResult(entry,indexOfSelected, false);
	}

	private void OpenEditDialogAndManageResult(CalendarDataBaseEntry entry,  int indexOfSelected, boolean isNewEntry) {
	    CalendarEditEntryDialog dialogEditEntry = new CalendarEditEntryDialog(shell);
	    boolean result = dialogEditEntry.open(entry, isNewEntry);
	    if (result) {
	        // we have pressed Done
	        if (isNewEntry){
	            // the entry did not exist in database before now. So add it
	            calendardatabase.addEntry(entry);
                resetTable();
	        }
	    	else {
	    	    // done because the database stores object and sort them depending on the start date that may has been changed
	    	    CalendarDataBaseEntry clone = (CalendarDataBaseEntry)entry.clone();
	    	    calendardatabase.removeEntry(entry);
	    	    calendardatabase.addEntry(clone);  
	            resetTable();
	    	}
	    
	    } else {
	        if(!isNewEntry) {
	    	    calendardatabase.removeEntry(entry); 
	    	    entriesInTable.set(indexOfSelected,null);
	            resetTable();
	            if(indexOfSelected == entriesInTable.size())
	                --indexOfSelected;
	        }
	    }
        table.setSelection(indexOfSelected);
        table.showItem(table.getItem(indexOfSelected));
        setEditCommands();
	}

	
	private void updateView () {
		resetTable();
		shell.setText(HeaderfromDate());
		setInitialSelection();
	}

	private void resetVectors()  {
	    entriesoftheday.clear();
	    entriesInTable.clear();
		entriesoftheday = calendardatabase.getEntriesOfTheDay(displayedDate);	    
	}
	
	
 	public void widgetDefaultSelected(SelectionEvent e) {
 		setEditCommands();
	    if (e.widget.equals(table)) {
	        if (commandNewEntry != null) {
	            createNewEntry();
	        }
	        else if (commandEditEntry != null) {
	            editEntry();
	        }
	    }
 	}	

    public void widgetSelected(SelectionEvent e) {
        try {
    		if (e.widget.equals(commandChangeView)) {
    		    dispose();
    		    
    		    if(monthShell != null)
    		     monthShell.setFocus();
    		}
    		else if (e.widget.equals(commandExit)) {
    		    setQuit(true);
    		    dispose();
    		}
    		else if (e.widget.equals(commandNewEntry)) {
    		    createNewEntry();
    		}
    		else if (e.widget.equals(commandEditEntry)) {
    		    editEntry();
    		}
    		else if (e.widget.equals(table)) {
    			setEditCommands();
    		}
            else if (e.widget.equals(commandGoToDate)) {
                Date result = calendarShowCase.goToDate(shell);
                if (result != null){
                    displayedDate = result;
                    updateView();
                }
            }
        }
        catch (Exception error) {
        }    
     }    

	/**
	 * Key handling
	 */
	public void keyPressed(KeyEvent e) {
		
		g.setFirstDayOfWeek(Calendar.SUNDAY);
		g.setTime(displayedDate);
		if (e.keyCode == SWT.ARROW_RIGHT ) {
		    if(g.get(Calendar.MONTH)==Calendar.DECEMBER && g.get(Calendar.DAY_OF_MONTH)==31)
		        return;
			g.add(Calendar.DAY_OF_YEAR,1); 
			displayedDate = g.getTime();
			updateView();
		}
		else if (e.keyCode == SWT.ARROW_LEFT) {
		    if(g.get(Calendar.MONTH)==Calendar.JANUARY && g.get(Calendar.DAY_OF_MONTH)==1)
		        return;
			g.add(Calendar.DAY_OF_YEAR,-1);
			displayedDate = g.getTime();
			updateView();
		} 
	}

    public void keyReleased(KeyEvent e) {
    }
    
    
	public boolean quitWanted() {
	    return quit;
	}
	
	private void setQuit(boolean quitWanted){
	    quit = quitWanted;
	}

}
