/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/**
 *
 *
 */
public class CalendarEditDayView implements SelectionListener {
    CalendarShowCase	calendarShowCase;
    
    private CalendarDayViewScreen calendarDayViewScreen;
    
    Shell				background;
    Shell 				dayShell;
    
    private Vector 		entriesoftheday;
    
    private CalendarDataBase calendardatabase;
	
	private org.eclipse.swt.widgets.List editDayList;
	
	Date 				displayedDate;
	
//	String[] stringDaysoftheWeek = { "Monday", "Tuesday" ,"Wednesday" ,"Thursday", "Friday", "Saturday", "Sunday"};
	
	CalendarEditDayViewListener editdaylistener;
    
	// commands for this view
	private Command commandEditEntry;
	private Command commandNewEntry;
	private Command commandGoToDate;
	private Command commandExit;
	private Command commandBack;
	private Command commandEDVChangeView;
	
    public CalendarEditDayView(CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
       	this.calendarShowCase = calendarShowCase;
        background = calendarShowCase.getComposite().getShell();
        
        this.calendardatabase = calendardatabase;
        
        calendarDayViewScreen = calendarShowCase.getDayViewScreen();
        
		entriesoftheday = new Vector();
		
		displayedDate= new Date();
		
		Rectangle bgdBnds = background.getBounds();
		Rectangle bgdArea = background.getClientArea(); 

		boolean landscape = (bgdArea.width > 240) && (bgdArea.width > bgdArea.height); 
		
		int style = SWT.TITLE | SWT.MODELESS | SWT.NO_BACKGROUND;
		if (landscape) 
			style |= SWT.BORDER;
		
		dayShell = new Shell(background, style);
		
		dayShell.setText(Messages.getString("CalendarEditDayView.0")); //$NON-NLS-1$
		if (landscape) {
			int x = bgdBnds.x + bgdBnds.width/2 + 5;
			int y = bgdBnds.y + 5;
			int w = bgdBnds.width/2 - 15;	// 20
			int h = bgdBnds.height - 5;		//10
			dayShell.setBounds(x, y, w, h);
		} else {
		    dayShell.setBounds(bgdBnds.x, bgdBnds.y, bgdBnds.width, bgdBnds.height);
		}
		
		commandGoToDate = new Command(dayShell, Command.GENERAL, 1);
		commandGoToDate.setText(Messages.getString("CalendarEditDayView.1")); //$NON-NLS-1$
		commandGoToDate.addSelectionListener(this);
		
		if (landscape) {
			commandExit = new Command(dayShell, Command.EXIT, 0);
			commandExit.setText(Messages.getString("CalendarEditDayView.2")); //$NON-NLS-1$
			commandExit.setLongLabel(Messages.getString("CalendarEditDayView.3")); //$NON-NLS-1$
			commandExit.addSelectionListener(this);
		} else {
			commandBack = new Command(dayShell, Command.EXIT, 0);
			commandBack.setText(Messages.getString("CalendarEditDayView.4")); //$NON-NLS-1$
			commandBack.addSelectionListener(this);
		}
		
		commandEDVChangeView = new Command (dayShell, Command.GENERAL,1);
		commandEDVChangeView.setText(Messages.getString("CalendarEditDayView.5")); //$NON-NLS-1$
		commandEDVChangeView.addSelectionListener(this);
		
		editDayList = new org.eclipse.swt.widgets.List(dayShell,SWT.BORDER);
		
		// draw the list TODO elsewhere
		editDayList.setLocation(0,0);
		editDayList.setSize(dayShell.getClientArea().width,dayShell.getClientArea().height);
		editDayList.addSelectionListener(this);
		//editDayList.addFocusListener(calendarshowcase);
		populateDayList();
		
		editDayList.addTraverseListener(calendarShowCase);
		
		dayShell.open();
    }
    
    public void dispose() {
    	if (commandEditEntry != null) {
    	    commandEditEntry.dispose();
    	}
    	if (commandNewEntry != null) {
    	    commandNewEntry.dispose();
    	}
    	if (commandGoToDate != null) {
    	    commandGoToDate.dispose();
    	}
    	if (commandExit != null) {
    	    commandExit.dispose();
    	}
    	if (commandBack != null) {
    	    commandBack.dispose();
    	}
    	if (commandEDVChangeView != null) {
    	    commandEDVChangeView.dispose();
    	}
    	dayShell.dispose();
    }
    
    public void redraw() {
        dayShell.redraw();
    }    
    
    public void setEditDayListener(CalendarEditDayViewListener listener) {
        editdaylistener = listener;
    }
    
    public Date getDate() {
        return displayedDate;	// should not be usefull for this view
    }
    
    public void setDate(Date newdate) {
        displayedDate = ((Date)newdate.clone());  // make a copy
        populateDayList();
    }
    
    private void setTitle(Date date) {
        //GregorianCalendar gnewdate = new GregorianCalendar();
        //gnewdate.setTime(date);
        String newTitle = new String(); //stringDaysoftheWeek[gnewdate.get(Calendar.DAY_OF_WEEK)-1])+" "; 
        Locale locale = Locale.getDefault();
        DateFormat dateFormat = DateFormat.getDateInstance(DateFormat.FULL, locale);
        newTitle += dateFormat.format(date);
        dayShell.setText(newTitle);
    }
    
    public void activate() {
        dayShell.forceActive();
        editDayList.setFocus();
        setEditDayListCommands();
    }
    
	private void populateDayList() {
	    Vector newentries = calendardatabase.getEntriesOfTheDay(displayedDate);
	    if ((newentries.size()!=0) || entriesoftheday.size()!=0) {
	        // update needed
	        editDayList.removeAll();
	        entriesoftheday.removeAllElements();
	        entriesoftheday = calendardatabase.getEntriesOfTheDay(displayedDate);			
	        for (int i=0;i<entriesoftheday.size();i++) {
	            editDayList.add(((CalendarDataBaseEntry)entriesoftheday.get(i)).toString());
	        }
	        // Special entry for new entry
	        editDayList.add(" "); //$NON-NLS-1$
	        editDayList.redraw();
	        editDayList.select(0);
	    }
	    setTitle(displayedDate);
	}
	
	/**
	 * Set the commands of the list (can be "New Entry" or "Edit") 
	 * depending on what item is focused in the list
	 */
	private void setEditDayListCommands() {
		if (editDayList.getSelectionIndex()!=(editDayList.getItemCount()-1)) {
			if (commandEditEntry==null) {
				if (commandNewEntry!=null) {
					commandNewEntry.removeSelectionListener(this);
					commandNewEntry.dispose();
					commandNewEntry=null;
				}
				commandEditEntry = new Command(editDayList,Command.GENERAL,5);
				commandEditEntry.setText(Messages.getString("CalendarEditDayView.7")); //$NON-NLS-1$
				commandEditEntry.addSelectionListener(this);
//				commandEditEntry.setDefaultCommand();
			}
		}
		else  {
			if (commandNewEntry==null) {
				if (commandEditEntry!=null) {
					commandEditEntry.removeSelectionListener(this);
					commandEditEntry.dispose();
					commandEditEntry=null;
				}
				commandNewEntry = new Command(editDayList,Command.GENERAL,5);
				commandNewEntry.setText(Messages.getString("CalendarEditDayView.8")); //$NON-NLS-1$
				commandNewEntry.setLongLabel(Messages.getString("CalendarEditDayView.9")); //$NON-NLS-1$
				commandNewEntry.addSelectionListener(this);
//				commandNewEntry.setDefaultCommand();			
			}
		}
		
	}	

	/**
	 * Creates a new entry.
	 */
	private void createNewEntry() {
	    // default dates for the new Entry
	    CalendarDataBaseEntry newentry = new CalendarDataBaseEntry(((Date)displayedDate.clone()), ((Date)(displayedDate)), Messages.getString("CalendarEditDayView.10"), Messages.getString("CalendarEditDayView.11"), null); //$NON-NLS-1$ //$NON-NLS-2$
	    CalendarEditEntryDialog dialogEditEntry = new CalendarEditEntryDialog(background.getShell());
	    boolean result = dialogEditEntry.open(newentry, true);
	    if (result) {	
	        // we have pressed Done
	        calendardatabase.addEntry(newentry);
	        setDate(displayedDate); // refresh TODO replace with populateList()
	        setEditDayListCommands();
	        editdaylistener.EntriesUpdated();
	    } 
	    // else, forget the new entry
	}
	
	/**
	 * Edits an entry. 
	 */
	private void editEntry() {	
	    // Edit entry in the list
	    CalendarDataBaseEntry editentry = (CalendarDataBaseEntry)entriesoftheday.get(editDayList.getSelectionIndex());
	    CalendarEditEntryDialog dialogEditEntry = new CalendarEditEntryDialog(background.getShell());
	    boolean result = dialogEditEntry.open(editentry, false);
	    if (!result) {	
	        // we have pressed Delete
	        calendardatabase.removeEntry(editentry);
	        setDate(displayedDate); // refresh TODO replace with populateList()
	        setEditDayListCommands();
	        editdaylistener.EntriesUpdated();
	    } else {
	        // we have pressed Done, list must be updated
	        setDate(displayedDate); // refresh TODO replace with populateList()
	        setEditDayListCommands();
	    }
	}
	
	
	/**
	 * Command handling
	 */
	public void widgetSelected(SelectionEvent e) {
		// New entry in the list
		if (e.widget == commandNewEntry) {
		    createNewEntry();
		    editDayList.setFocus();
		}
		// Edit entry in the list
		else if (e.widget == commandEditEntry) {
		    editEntry();
		    editDayList.setFocus();
		}
		else if (e.widget == editDayList) {
			setEditDayListCommands();
		} 		
		else if (e.widget == commandBack) {
			calendarShowCase.activateMonthView();
		}
		else if (e.widget == commandExit) {
			calendarShowCase.quit();
		}
		else if (e.widget == commandGoToDate) {
			calendarShowCase.goToDate(calendarShowCase.getComposite().getShell());
			setEditDayListCommands();
		}
		else if (e.widget == commandEDVChangeView){
		    calendarDayViewScreen.activate(dayShell, displayedDate);
		    // quit if wanted
		    if(calendarDayViewScreen.quitWanted()){
	            calendarShowCase.quit();
		    } else {
		        setDate(calendarDayViewScreen.getDisplayedDate()); // refresh TODO replace with populateList(
		        setEditDayListCommands();
	        	editdaylistener.notifyDateChanged(displayedDate);
	        	editdaylistener.EntriesUpdated();
		    }
		}
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
	    if (e.widget == editDayList) {
	        if (commandNewEntry != null) {
	            createNewEntry();
			    editDayList.setFocus();
	        }
	        else if (commandEditEntry != null) {
	            editEntry();
			    editDayList.setFocus();
	        }
	    }
 	}	
	
	public boolean isSwitcher(Widget w) {
	    return (w==editDayList);
	}
		
}
