/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.*;


public class CalendarEditEntryDialog implements SelectionListener, ModifyListener {
	MultiPageDialog dialog; 
       
    Canvas page1;
    RowLayout layout;
	int lastScrollBarSelection = 0;
	Text description;
	Text location;
	Combo timedCombo;
	DateEditor startdate;
	DateEditor enddate;
	DateEditor duration;
	CaptionedControl startdateCT;
	CaptionedControl enddateCT;
	CaptionedControl durationCT;
	
	Text notes;
	
	Command commandDelete;
	Command commandDone;
	
	CalendarDataBaseEntry calendardatabaseentry;
	
	boolean update = false;
	boolean isNewEntry;
	boolean isStartDatefocused = false;
	boolean isEndDatefocused   = false;
	boolean isDurationfocused  = false;
	
	FocusListener focusListener = new FocusListener() {
		public void focusGained(FocusEvent e) {
			if (e.widget == description) {
				page1.getVerticalBar().setSelection(page1.getVerticalBar().getMinimum());
				updateCanvas();				
			} else if (e.widget == duration) {
				isStartDatefocused = false;
				isEndDatefocused   = false;
				isDurationfocused  = true;	
			    page1.getVerticalBar().setSelection(page1.getVerticalBar().getMaximum());
				updateCanvas();				
			} else if (e.widget == location || e.widget == startdate || e.widget == enddate || e.widget == timedCombo) {
			    if(e.widget == startdate){
			    	isStartDatefocused = true;
					isEndDatefocused   = false;
					isDurationfocused  = false;	
			    }else if(e.widget == enddate){
			    	isStartDatefocused = false;
					isEndDatefocused   = true;
					isDurationfocused  = false;	
			    }
				Rectangle rc = ((Control) e.widget).getParent().getBounds();
				Rectangle clientArea = page1.getClientArea();
			    int selection = page1.getVerticalBar().getSelection();
			    if (rc.y < selection) {
			        page1.getVerticalBar().setSelection(rc.y);
			        updateCanvas();
			    } else if (rc.y + rc.height > selection + clientArea.height) {
			        page1.getVerticalBar().setSelection(rc.y);
			        updateCanvas();
			    }			        
			}
		}

		public void focusLost(FocusEvent e) {
		}
	};
	
	SelectionListener scrollBarListener = new SelectionListener() {
		public void widgetSelected(SelectionEvent e) {
			if (e.widget == page1.getVerticalBar()) {
				updateCanvas();
			}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}		
	};

	public CalendarEditEntryDialog (Shell parent) {
	    dialog = new MultiPageDialog(parent);
	}
	
	public boolean open(CalendarDataBaseEntry entry, boolean isNewEntry) {
	    calendardatabaseentry = entry;
	    this.isNewEntry = isNewEntry;
	    update = !isNewEntry;
	    
		dialog.setText(Messages.getString("CalendarEditEntryDialog.0")); //$NON-NLS-1$
		
		Composite p1 = dialog.createPage(Messages.getString("CalendarEditEntryDialog.1"), null); //$NON-NLS-1$

		page1 = new Canvas(p1, SWT.V_SCROLL);
	    page1.setSize(p1.getClientArea().width, p1.getClientArea().height);//set the size to while client area instead of hardcode the size
		
		layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.wrap = false;
		page1.setLayout(layout);
		
		CaptionedControl descriptionCT = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
		descriptionCT.setText(Messages.getString("CalendarEditEntryDialog.3")); //$NON-NLS-1$
		description = new Text(descriptionCT,SWT.SINGLE);
		description.setText(entry.getDescription());
		
		CaptionedControl locationCT = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
		locationCT.setText(Messages.getString("CalendarEditEntryDialog.4")); //$NON-NLS-1$
		location = new Text(locationCT,SWT.SINGLE);
		location.setText(entry.getLocation());
		
		CaptionedControl timedCT = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
		timedCT.setText(Messages.getString("CalendarEditEntryDialog.5")); //$NON-NLS-1$
		timedCombo = new Combo(timedCT, SWT.READ_ONLY);
		timedCombo.add(Messages.getString("CalendarEditEntryDialog.6")); //$NON-NLS-1$
		timedCombo.add(Messages.getString("CalendarEditEntryDialog.7")); //$NON-NLS-1$
		timedCombo.select(0);
		timedCombo.addSelectionListener(this);

		startdateCT = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
		startdateCT.setText(Messages.getString("CalendarEditEntryDialog.8")); //$NON-NLS-1$
		startdate = new DateEditor(startdateCT, SWT.NORMAL,DateEditor.TIME | DateEditor.FULL);
		startdate.setDate(entry.getStartDate());
		startdate.addModifyListener(this);
//		startdateCT.setLayoutData(new RowData(startdate.computeSize(SWT.DEFAULT,SWT.DEFAULT).x, startdate.computeSize(SWT.DEFAULT,SWT.DEFAULT).y));

		enddateCT = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
		enddateCT.setText(Messages.getString("CalendarEditEntryDialog.9")); //$NON-NLS-1$
		enddate = new DateEditor(enddateCT, SWT.NORMAL, DateEditor.TIME | DateEditor.FULL);
		enddate.setDate(entry.getEndDate());
		enddate.addModifyListener(this);
//		enddateCT.setLayoutData(new RowData(enddate.computeSize(SWT.DEFAULT,SWT.DEFAULT).x, enddate.computeSize(SWT.DEFAULT,SWT.DEFAULT).y));

		durationCT = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
		durationCT.setText(Messages.getString("CalendarEditEntryDialog.10")); //$NON-NLS-1$
		duration = new DateEditor(durationCT, SWT.NORMAL, DateEditor.DURATION | DateEditor.FULL);
		int offset = (enddate.getTime() - startdate.getTime());
		duration.setTime(offset);
		duration.addModifyListener(this);
		
		description.addFocusListener(focusListener);
		location.addFocusListener(focusListener);
		timedCombo.addFocusListener(focusListener);
		startdate.addFocusListener(focusListener);
		enddate.addFocusListener(focusListener);
		duration.addFocusListener(focusListener);

		// Commands
		commandDelete = new Command(p1.getShell(), Command.GENERAL, 2);
		commandDelete.setText(Messages.getString("CalendarEditEntryDialog.11")); //$NON-NLS-1$
		commandDelete.addSelectionListener(this);

		commandDone = new Command(p1.getShell(), Command.EXIT, 0);
		commandDone.setText(Messages.getString("CalendarEditEntryDialog.12")); //$NON-NLS-1$
		commandDone.addSelectionListener(this);
		
		page1.layout();
		
		// scroll bar
		Rectangle containerArea = getChildrenBounds(page1);
		Rectangle clientArea = page1.getClientArea();
		
		page1.getVerticalBar().setMaximum(containerArea.height);
		page1.getVerticalBar().setMinimum(0);
		page1.getVerticalBar().setThumb(containerArea.height/3);//to prevent the prompt keyboard from hiding the durationCT
		page1.getVerticalBar().setPageIncrement(clientArea.height/5);
		page1.getVerticalBar().setIncrement(clientArea.height/10);
		page1.getVerticalBar().addSelectionListener(scrollBarListener);
		
		// Second page
		Composite p2 = dialog.createPage(Messages.getString("CalendarEditEntryDialog.13"), null); //$NON-NLS-1$
		notes = new Text(p2, SWT.BORDER|SWT.WRAP);//add SWT.WRAP to enable user to write multiple lines in this Text field 
		notes.setSize(p2.getClientArea().width, p2.getClientArea().height);//set the size to while client area instead of hardcode the size
		notes.setText(entry.getNotes() != null ? entry.getNotes() : ""); //$NON-NLS-1$

		dialog.setSelection(0);
		dialog.open();
		
		return update;
	}
	
	private Rectangle getChildrenBounds(Composite parent) {
		// Calculate the area of all child controls.

		Rectangle containerArea = null;
		Control[] childrenControls = page1.getChildren();
		for (int i = 0; i < childrenControls.length; i++) {
			if (containerArea == null) {
				containerArea = new Rectangle(childrenControls[i].getBounds().x, childrenControls[i].getBounds().y, childrenControls[i].getBounds().width, childrenControls[i].getBounds().height);
			} else {
				containerArea.add(childrenControls[i].getBounds());
			}
		}
		
		containerArea.y -= layout.marginTop;
		containerArea.height += layout.marginTop + layout.marginBottom;
		return containerArea;		
	}
	
	private void updateCanvas() {
		int selection = page1.getVerticalBar().getSelection();
		
		Rectangle containerArea = getChildrenBounds(page1);
		page1.scroll(containerArea.x, containerArea.y + (lastScrollBarSelection - selection), containerArea.x, containerArea.y, containerArea.width, containerArea.height, true);
						
		lastScrollBarSelection = selection;
	}
	
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandDelete) {
		    String s;
		    if (isNewEntry) {
		        s = Messages.getString("CalendarEditEntryDialog.16"); //$NON-NLS-1$
		    } else {
		        s = Messages.getString("CalendarEditEntryDialog.17"); //$NON-NLS-1$
		    }
		    MessageBox box = new MessageBox(dialog.getParent(), SWT.ICON_QUESTION | SWT.OK | SWT.CANCEL);
		    box.setMessage(s);
		    
		    if (box.open() == SWT.OK) {
		        update = false;
		        quit();
		    }
		} 
		else if (e.widget==commandDone) {
		    update = true;
		    updateEntry();
		    quit();
		}
		else if (e.widget == timedCombo) {
		    if (timedCombo.getSelectionIndex() == 0) {
		        startdateCT.setEnabled(true);
		        enddateCT.setEnabled(true);
		        durationCT.setEnabled(true);
		    }
		    else  {
		        startdateCT.setEnabled(false);
		        enddateCT.setEnabled(false);
		        durationCT.setEnabled(false);
		    }
		}
 	}

	public void widgetDefaultSelected(SelectionEvent e) {

 	}

	private void quit() {
		commandDelete.dispose();
		commandDone.dispose();
		dialog.close();
	}

	private void updateEntry() {
		// update entry
		calendardatabaseentry.setDescription(description.getText());
		calendardatabaseentry.setLocation(location.getText());
		calendardatabaseentry.setStartDate(startdate.getDate());
		calendardatabaseentry.setEndDate(enddate.getDate());
		calendardatabaseentry.setNotes(notes.getText());
	}
	
    public void modifyText(ModifyEvent arg0) {
    	//fix bug BMHL7R34NS
        if (arg0.widget == startdate) {
        	if(isStartDatefocused){
        		int start = startdate.getTime();
                int time = duration.getTime();
                if (start + time < 86400) {
                    enddate.setTime(start + time);
                } else {
                    enddate.setTime(86399);
                    duration.setTime(86399 - start);                
                }
        	}
        }
        
        if (arg0.widget == enddate) {
        	if(isEndDatefocused){
        		int start = startdate.getTime();
                int end = enddate.getTime();
                int time = duration.getTime();
                if(end==0){
                	return;
                }else if (end >= start) {
                    duration.setTime(end - start);
                } else {
                    start = end - time;
                    if (start >= 0 ) {
                        startdate.setTime(start);
                    } else {
                        startdate.setTime(0);
                        duration.setTime(end);
                    }
                }
        	}
        }
        
        if (arg0.widget == duration) {
        	if(isDurationfocused){
        		int start = startdate.getTime();
                int end = enddate.getTime();
                int time = duration.getTime();
                end = start + time;
                if (end < 86400) {
                    enddate.setTime(end);
                } else {
                    enddate.setTime(86399);
                    duration.setTime(86399 - start);                
                }
        	}
        }
    }   
 
}
