/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;


import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.*;

import java.util.*;

/**
 *
 *
 */
// TODO: review hierarchy, we could avoid the CalendarEditDayViewListener inheritance
public class CalendarMonthView implements CalendarEditDayViewListener, SelectionListener {
    Shell monthShell;							// the shell
    CalendarShowCase calendarShowCase;			// the show case
    
    CalendarMonthWidget calendarmonthwidget;	// the custom widget
    
    String[] stringMonths = {Messages.getString("CalendarMonthView.0"), Messages.getString("CalendarMonthView.1"), Messages.getString("CalendarMonthView.2"), Messages.getString("CalendarMonthView.3"), Messages.getString("CalendarMonthView.4") ,Messages.getString("CalendarMonthView.5"), Messages.getString("CalendarMonthView.6"), Messages.getString("CalendarMonthView.7"), Messages.getString("CalendarMonthView.8"), Messages.getString("CalendarMonthView.9") ,Messages.getString("CalendarMonthView.10"), Messages.getString("CalendarMonthView.11")}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$ //$NON-NLS-9$ //$NON-NLS-10$ //$NON-NLS-11$ //$NON-NLS-12$
  
	private Command commandEditDay;
	private Command commandMTChangeView;
	private Command commandGoToDate;
	private Command commandExit;

    public CalendarMonthView(CalendarShowCase calendarShowCase, CalendarDataBase calendardatabase) {
        this.calendarShowCase = calendarShowCase; 
        Shell background = calendarShowCase.getComposite().getShell();
		Rectangle bgdBnds = background.getBounds();
		Rectangle bgdArea = background.getClientArea(); 
		
		boolean landscape = (bgdArea.width > 240) && (bgdArea.width > bgdArea.height); 
		int style =  SWT.TITLE | SWT.MODELESS | SWT.NO_BACKGROUND;
		if (landscape)
				style |= SWT.BORDER;

		monthShell =  new Shell(background, style);
		monthShell.setText(Messages.getString("CalendarMonthView.12")); //$NON-NLS-1$
		if (landscape) {
			int x = bgdBnds.x + 5;
			int y = bgdBnds.y + 5;
			int w = bgdBnds.width/2 - 15;	//20
			int h = bgdBnds.height - 5;	//10
			monthShell.setBounds(x, y, w, h);
		} else {
		    monthShell.setBounds(bgdBnds.x, bgdBnds.y, bgdBnds.width, bgdBnds.height);
		}
		
		// Create the commands
		
     	// command edit day is a background command
     	// (for switching views) so it is defined here
     	//  but is displayed only when calendarview is 
     	// activated.
     	// command named "view day" allows switching to day view
		// while in portrait mode
		
		commandEditDay = new Command(monthShell, Command.SELECT, 4);
		commandEditDay.setText((landscape) ? Messages.getString("CalendarMonthView.13") : Messages.getString("CalendarMonthView.14")); //$NON-NLS-1$ //$NON-NLS-2$
		commandEditDay.addSelectionListener(this);
//		commandEditDay.setDefaultCommand();

		commandMTChangeView = new Command(monthShell,Command.GENERAL,3);
		commandMTChangeView.setText(Messages.getString("CalendarMonthView.15")); //$NON-NLS-1$
		commandMTChangeView.addSelectionListener(this);
		
		commandGoToDate = new Command(monthShell, Command.GENERAL, 2);
		commandGoToDate.setText(Messages.getString("CalendarMonthView.16")); //$NON-NLS-1$
		commandGoToDate.addSelectionListener(this);
		
		commandExit = new Command(monthShell, Command.EXIT, 1);
		commandExit.setText(Messages.getString("CalendarMonthView.17")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("CalendarMonthView.18")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);

		// Create the widget		
		calendarmonthwidget = new CalendarMonthWidget(monthShell, calendardatabase);
		calendarmonthwidget.setLocation(0,0);
		calendarmonthwidget.setSize(monthShell.getClientArea().width,monthShell.getClientArea().height);		

		calendarmonthwidget.addCalendarMonthWidgetListener(calendarShowCase);
		
		setTitle(calendarmonthwidget.getSelecteddate());
		
		calendarmonthwidget.addTraverseListener(calendarShowCase);
		
		monthShell.open();
    }
    
    public void dispose() {
		commandExit.dispose();
		commandGoToDate.dispose();
		commandMTChangeView.dispose();
		commandEditDay.dispose();
		monthShell.dispose();
    }
 
    public Date getDate() {
        return calendarmonthwidget.getSelecteddate(); 
    }
    
    public void setDate(Date date) {        
        calendarmonthwidget.setSelectedDate(date);
    }
    
    public void activate() {
        monthShell.forceActive();
        calendarmonthwidget.setFocus();
    }
    
	public boolean isSwitcher(Widget w) {
	    // TODO change that ....
	    return (w==calendarmonthwidget/*monthShellFakecanvas*/);
	}

	public void redraw() {
	    monthShell.redraw();
	}
	
	/**
	 * Set the title of the window 
	 * 
	 * @param newdate
	 */
	public void setTitle(Date newdate) {
        GregorianCalendar gnewdate = new GregorianCalendar();
        gnewdate.setTime(newdate);
        String newTitle = new String();; 
        
        
//      Differentiate date expression format for corresponding locale (SPR #BHJW6U2DAC) 
        Locale locale = Locale.getDefault();
        if (locale.TRADITIONAL_CHINESE.toString().equals(locale.toString()))
        {
         newTitle+= gnewdate.get(Calendar.YEAR);
         newTitle+= Messages.getString("CalendarMonthView.19");  //$NON-NLS-1$
         newTitle+= new String(" " + stringMonths[gnewdate.get(Calendar.MONTH)]);  //$NON-NLS-1$
        }
        else if (locale.SIMPLIFIED_CHINESE.toString().equals(locale.toString()))
        {
        	newTitle+= gnewdate.get(Calendar.YEAR);        	
        	newTitle+= new String(" " + stringMonths[gnewdate.get(Calendar.MONTH)]);
        }
        else if (locale.KOREA.toString().equals(locale.toString()))
        {
        	newTitle+= gnewdate.get(Calendar.YEAR);
            newTitle+= Messages.getString("CalendarMonthView.19");  //$NON-NLS-1$
            newTitle+= new String(" " + stringMonths[gnewdate.get(Calendar.MONTH)]);  //$NON-NLS-1$
        }
        else if (locale.JAPAN.toString().equals(locale.toString()))
        {
        	 newTitle+= gnewdate.get(Calendar.YEAR);
             newTitle+= Messages.getString("CalendarMonthView.19");  //$NON-NLS-1$
             newTitle+= new String(" " + stringMonths[gnewdate.get(Calendar.MONTH)]);  //$NON-NLS-1$
        }
        else 
        {
             newTitle+= new String(stringMonths[gnewdate.get(Calendar.MONTH)] + " ");  //$NON-NLS-1$
             newTitle+= gnewdate.get(Calendar.YEAR);
        }        
        monthShell.setText(newTitle);
 	}


    /**
     *  A new entiry has been added or an entry has been deleted,
     * we need to redraw the monthwidget to reflect new meetings
     *
     */
	public void EntriesUpdated() {
        calendarmonthwidget.redrawAllMonth();
        calendarmonthwidget.redraw();
    }
	/**
	 * Date has changed. So it must be reset 
	 */
    public void notifyDateChanged(Date newDate){
        setDate(newDate);
    }
	
	
	/**
     * Command handling
     */
    public void widgetSelected(SelectionEvent e)  {
		if (e.widget == commandExit) {
			calendarShowCase.quit();
		}
		else if (e.widget == commandEditDay) {
		    calendarShowCase.editDay();
		}
		else if (e.widget == commandGoToDate) {
			calendarShowCase.goToDate(calendarShowCase.getComposite().getShell());
		}
		else if (e.widget == commandMTChangeView){
		    calendarShowCase.getDayViewScreen().activate(monthShell, calendarmonthwidget.getSelecteddate());
	        //quit if wanted
		    if(calendarShowCase.getDayViewScreen().quitWanted()){
	            calendarShowCase.quit();
	        } else {
	            setDate(calendarShowCase.getDayViewScreen().getDisplayedDate());
	        }
		}
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
    
}
