/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

import org.eclipse.ercp.swt.mobile.QueryDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.*;


public class CalendarShowCase extends ShowCase implements CalendarMonthWidgetListener, TraverseListener {
	private CalendarDataBase calendardatabase;
	
	private CalendarMonthView 	calendarmonthview;
	private CalendarEditDayView calendareditdayview;
	private CalendarDayViewScreen calendarDayViewScreen;
	CalendarEditDayViewListener editdaylistener;

	// Manage landscape layout
	private boolean landscape;
	
	public CalendarShowCase() {
	}
	
	public String getName() {
		return Messages.getString("CalendarShowCase.0"); //$NON-NLS-1$
	}
	
	public void show() {
		// Manage landscape layout
		Rectangle bgdArea = getComposite().getShell().getClientArea(); 
		landscape = (bgdArea.width > 360) && (bgdArea.width > bgdArea.height); 
		
		calendardatabase=new CalendarDataBase();
		calendardatabase.buildSample();
				
		buildMonthShell();
		buildDayViewScreenShell();
		buildDayShell();
		
		calendarmonthview.activate();
	}
	
	public void editDay() {
	    calendarmonthview.getDate();
	    calendareditdayview.activate();
	}
	
	public Date goToDate(Shell parent) {
	    // default dates for the new Entry
	    DateFormat df = new SimpleDateFormat("yyyy-MM-dd"); //$NON-NLS-1$
	    QueryDialog queryDate = new QueryDialog(parent,SWT.APPLICATION_MODAL,QueryDialog.DATE);
	    Date defaultDate = (Date)(calendarmonthview.getDate().clone());
	    String defaultDateString = df.format(defaultDate);
	    queryDate.setText(Messages.getString("CalendarShowCase.2")); //$NON-NLS-1$
	    queryDate.setPromptText(Messages.getString("CalendarShowCase.3"),defaultDateString); //$NON-NLS-1$
	    String result = queryDate.open();
		if (result!=null) {	
	        Date resultdate;
            try {
                resultdate = df.parse(result);
                calendarmonthview.setDate(resultdate);
                return resultdate;
            } catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
		} else {
		    return null;
		}
	}
	

	public void quit() {
	    calendarmonthview.dispose();
	    calendareditdayview.dispose();
	    //calendarDayViewScreen.dispose();
		
	    dispose();
	}

	public void newDateSelected(Date date) {
	    calendareditdayview.setDate(date);
	    calendarmonthview.setTitle(date);
	    calendarmonthview.redraw();	
	    calendareditdayview.redraw(); 
	 }
	 
	 private void buildMonthShell() {
	     calendarmonthview = new CalendarMonthView(this, calendardatabase);
	 }
	 
	 private void buildDayShell() {
	     calendareditdayview = new CalendarEditDayView(this, calendardatabase);
	     calendareditdayview.setEditDayListener(calendarmonthview);
	 }
	 
	 private void buildDayViewScreenShell() {
	     calendarDayViewScreen = CalendarDayViewScreen.createUniqueInstance(this, calendardatabase);
	 }
	 
	 
    public void keyTraversed(TraverseEvent e) {
	    if (calendareditdayview.isSwitcher(e.widget)) {
	        // switch shell to edit day
	        e.doit=false;
	        if (landscape && (e.detail == SWT.TRAVERSE_TAB_NEXT ||e.detail == SWT.TRAVERSE_TAB_PREVIOUS)) {
		        calendarmonthview.activate();
	        }
	        
	    }
	    else if (calendarmonthview.isSwitcher(e.widget)) {
	        // switch shell to month view
	        e.doit=false;
	        if (landscape && (e.detail == SWT.TRAVERSE_TAB_NEXT ||e.detail == SWT.TRAVERSE_TAB_PREVIOUS)) {
		        calendareditdayview.activate();
	        }
	    }
    }
    
    public void activateMonthView() {
    	calendarmonthview.activate();
    }
    
    public CalendarDayViewScreen getDayViewScreen(){
        return calendarDayViewScreen;
    }
    
    // fix bug SCLL7D55YV
    public void setFocus() {
    	activateMonthView();
    }
	 
}
