/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.CaptionedControl;

import java.util.Date;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ScrolledComposite;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

public class CaptionedControlShowCase extends ShowCase implements SelectionListener,Listener {
    MultiPageDialog multipagedialog;
 
    Command commandDone, commandNextPage;
    CaptionedControl capt1;
    Image image;
    Rectangle	viewPortMax;
    int pageIndex=0;
    boolean isNokia = false;
    String osName;
    List list;
    Slider slider;
    ConstrainedText ct;
    Text text;
    Table table;

    public CaptionedControlShowCase() {
    }
    
    public String getName() {
        return Messages.getString("CaptionedControlShowCase.0"); //$NON-NLS-1$
    }

    protected void show() {
    	osName = System.getProperty("os.name");
    	if(osName != null) {
			osName = osName.toLowerCase();
	        if(osName.indexOf("symbian") >= 0 || osName.indexOf("epoc32") >= 0){
	        	isNokia = true;
	        }
		}
        
        //In order to bypass the Nokia's bug: BMHL7SPDS6
        //I should set the shell invisible while the MPD is shown
        //In order to make the screen transition more smoothly
        //I add FocusIn filter to this class before MPD is created
        //When focus is in MPD, we set the parent Shell invisible
        if(isNokia){
        	getComposite().getDisplay().addFilter(SWT.FocusIn, this);
        }
        
        multipagedialog = new MultiPageDialog(getComposite().getShell());
        multipagedialog.setText(Messages.getString("CaptionedControlShowCase.0")); //$NON-NLS-1$
        
        fillPageCore1();
        fillPageCore2();
        fillPageMobile1();
        fillPageMobile2();
        fillPageExpanded();

        multipagedialog.setSelection(pageIndex);
        
        multipagedialog.open();
        
        //After MPD is closed, we should set parent shell visible
        if(isNokia){
       	 getComposite().getShell().setVisible(true);
        }  
        
        quit();
   }
    
    private void quit() {
    	multipagedialog.dispose();    	
        commandDone.dispose();
        if(isNokia){
        	commandNextPage.dispose();
        }
        image.dispose();
        if(isNokia){
        	getComposite().getDisplay().removeFilter(SWT.FocusIn, this);
        }
        dispose();
    }
    
    private void fillPageCore1() {
        Composite page = multipagedialog.createPage(Messages.getString("CaptionedControlShowCase.2"), null); //$NON-NLS-1$
        viewPortMax = page.getClientArea();
 
        // Create the Composite which manage the scrollBar.
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
			// Set layout on the scrolled Composite.
        scrolledComposite.setLayout(new FormLayout());
        if(viewPortMax.height>viewPortMax.width){
        	scrolledComposite.setBounds(viewPortMax.x, viewPortMax.y, viewPortMax.width, viewPortMax.height-50);
        }else{
        	scrolledComposite.setBounds(viewPortMax);
        }
		// Composite which contains all controls
        Composite composite = new Composite(scrolledComposite, SWT.NONE);

        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout(layout);
        
        capt1 = new CaptionedControl(composite, SWT.NONE);
        capt1.setText(Messages.getString("CaptionedControlShowCase.3")); //$NON-NLS-1$
        list = new List(capt1, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);
        list.add(Messages.getString("CaptionedControlShowCase.4")); //$NON-NLS-1$
        list.add(Messages.getString("CaptionedControlShowCase.5")); //$NON-NLS-1$
        list.add(Messages.getString("CaptionedControlShowCase.6")); //$NON-NLS-1$
        
        CaptionedControl capt2 = new CaptionedControl(composite, SWT.NONE);
        capt2.setText(Messages.getString("CaptionedControlShowCase.7")); //$NON-NLS-1$
        Combo combo1 = new Combo(capt2, SWT.NONE);
        combo1.add(Messages.getString("CaptionedControlShowCase.8")); //$NON-NLS-1$
        combo1.add(Messages.getString("CaptionedControlShowCase.9")); //$NON-NLS-1$
        combo1.add(Messages.getString("CaptionedControlShowCase.10")); //$NON-NLS-1$
        
        CaptionedControl capt3 = new CaptionedControl(composite, SWT.NONE);
        capt3.setText(Messages.getString("CaptionedControlShowCase.11")); //$NON-NLS-1$
        Combo combo2 = new Combo(capt3, SWT.BORDER | SWT.READ_ONLY);
        combo2.add(Messages.getString("CaptionedControlShowCase.12")); //$NON-NLS-1$
        combo2.add(Messages.getString("CaptionedControlShowCase.13")); //$NON-NLS-1$
        combo2.add(Messages.getString("CaptionedControlShowCase.14")); //$NON-NLS-1$
        
        CaptionedControl capt4 = new CaptionedControl(composite, SWT.NONE);
        capt4.setText(Messages.getString("CaptionedControlShowCase.15")); //$NON-NLS-1$
        Button button1 = new Button(capt4, SWT.PUSH);
        button1.setText(Messages.getString("CaptionedControlShowCase.16")); //$NON-NLS-1$

        CaptionedControl capt5 = new CaptionedControl(composite, SWT.NONE);
        capt5.setText(Messages.getString("CaptionedControlShowCase.17")); //$NON-NLS-1$
        Button button2 = new Button(capt5, SWT.CHECK);
        button2.setText(Messages.getString("CaptionedControlShowCase.18")); //$NON-NLS-1$

        CaptionedControl capt6 = new CaptionedControl(composite, SWT.NONE);
        capt6.setText(Messages.getString("CaptionedControlShowCase.19")); //$NON-NLS-1$
        Button button3 = new Button(capt6, SWT.RADIO);
        button3.setText(Messages.getString("CaptionedControlShowCase.20")); //$NON-NLS-1$

        CaptionedControl capt7 = new CaptionedControl(composite, SWT.NONE);
        capt7.setText(Messages.getString("CaptionedControlShowCase.21")); //$NON-NLS-1$
        Label label = new Label(capt7, SWT.NONE);
        label.setText(Messages.getString("CaptionedControlShowCase.22")); //$NON-NLS-1$

        CaptionedControl capt8 = new CaptionedControl(composite, SWT.NONE);
        capt8.setText(Messages.getString("CaptionedControlShowCase.23")); //$NON-NLS-1$
        new Text(capt8, SWT.NONE);
        
        CaptionedControl capt9 = new CaptionedControl(composite, SWT.NONE);
        capt9.setText(Messages.getString("CaptionedControlShowCase.24")); //$NON-NLS-1$
        Text text = new Text(capt9, SWT.READ_ONLY);
        text.setText(Messages.getString("CaptionedControlShowCase.25")); //$NON-NLS-1$

        //TODO: for some reason the global Command is not working here (on win)
        commandDone = new Command(page.getShell(), Command.EXIT, 0);
        commandDone.setText(Messages.getString("CaptionedControlShowCase.26")); //$NON-NLS-1$
        commandDone.addSelectionListener(this);
        if(isNokia){
	        commandNextPage = new Command(page.getShell(), Command.GENERAL, 3);
	        commandNextPage.setText(Messages.getString("CaptionedControlShowCase.98"));
	        commandNextPage.addSelectionListener(this);
        }
        composite.pack();
        scrolledComposite.setContent(composite);
        scrolledComposite.setAutoScroll(true);
    }
    
    private void fillPageCore2() {
        Composite page = multipagedialog.createPage(Messages.getString("CaptionedControlShowCase.27"), null); //$NON-NLS-1$

        
        // Create the Composite which managethe scrollBar.
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
			// Set layout on the scorlled Composite.
        scrolledComposite.setLayout(new FormLayout());
        if(viewPortMax.height>viewPortMax.width){
        	scrolledComposite.setBounds(viewPortMax.x, viewPortMax.y, viewPortMax.width, viewPortMax.height-50);
        }else{
        	scrolledComposite.setBounds(viewPortMax);
        }

		// Composite which content all Control
        Composite composite = new Composite(scrolledComposite, SWT.NONE);

        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 2;
        composite.setLayout(layout);

        final CaptionedControl capt1 = new CaptionedControl(composite, SWT.NONE);
        capt1.setText(Messages.getString("CaptionedControlShowCase.28")); //$NON-NLS-1$
        slider = new Slider(capt1, SWT.HORIZONTAL);
        slider.setMinimum(0);
        slider.setMaximum(10);
        slider.setSelection(5);
        slider.setThumb(1);

        CaptionedControl capt2 = new CaptionedControl(composite, SWT.NONE);
        capt2.setText(Messages.getString("CaptionedControlShowCase.29")); //$NON-NLS-1$
        ProgressBar bar = new ProgressBar(capt2, SWT.HORIZONTAL);
        bar.setMinimum(0);
        bar.setMaximum(10);
        bar.setSelection(5);

        CaptionedControl capt3 = new CaptionedControl(composite, SWT.NONE);
        capt3.setText(Messages.getString("CaptionedControlShowCase.30")); //$NON-NLS-1$
        Canvas canvas = new Canvas(capt3, SWT.BORDER);
        canvas.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_BLUE));

        
        CaptionedControl capt4 = new CaptionedControl(composite, SWT.NONE);
        capt4.setText(Messages.getString("CaptionedControlShowCase.31")); //$NON-NLS-1$
        
        Composite group = new Composite(capt4, SWT.BORDER);

        final CaptionedControl groupCapt1 = new CaptionedControl(group, SWT.NONE);
        groupCapt1.setText(Messages.getString("CaptionedControlShowCase.32")); //$NON-NLS-1$
        new Text(groupCapt1, SWT.NONE);
        
        CaptionedControl groupCapt2 = new CaptionedControl(group, SWT.NONE);
        groupCapt2.setText(Messages.getString("CaptionedControlShowCase.33")); //$NON-NLS-1$
        new Text(groupCapt2, SWT.NONE);

        CaptionedControl groupCapt3 = new CaptionedControl(group, SWT.NONE);
        groupCapt3.setText(Messages.getString("CaptionedControlShowCase.34")); //$NON-NLS-1$
        new Text(groupCapt3, SWT.NONE);

        canvas.setSize(70, 100);

        group.setSize(150, 100);
        group.setLayout(new GridLayout());
        group.layout();

        composite.layout();

        capt1.setSize(capt3.getSize().x, capt1.getSize().y);
        capt2.setSize(capt4.getSize().x, capt2.getSize().y);

        composite.pack();
        scrolledComposite.setContent(composite);
        scrolledComposite.setAutoScroll(true);

    }
    
    private void fillPageMobile1() {
        Composite page = multipagedialog.createPage(Messages.getString("CaptionedControlShowCase.35"), null); //$NON-NLS-1$
        
        // Create the Composite which managethe scrollBar.
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
			// Set layout on the scorlled Composite.
        scrolledComposite.setLayout(new FormLayout());
        scrolledComposite.setBounds(viewPortMax);

		// Composite whihch content all Control
        Composite composite = new Composite(scrolledComposite, SWT.NONE);
 
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout(layout);

        CaptionedControl capt1 = new CaptionedControl(composite, SWT.NONE);
        capt1.setText(Messages.getString("CaptionedControlShowCase.36")); //$NON-NLS-1$
        ct = new ConstrainedText(capt1, SWT.NONE, ConstrainedText.PHONENUMBER);
        
        CaptionedControl capt2 = new CaptionedControl(composite, SWT.NONE);
        capt2.setText(Messages.getString("CaptionedControlShowCase.37")); //$NON-NLS-1$
        DateEditor date = new DateEditor(capt2, SWT.NONE, DateEditor.DATE);
        date.setDate(new Date());
        
        CaptionedControl capt3 = new CaptionedControl(composite, SWT.NONE);
        capt3.setText(Messages.getString("CaptionedControlShowCase.38")); //$NON-NLS-1$
        HyperLink link = new HyperLink(capt3, SWT.NONE, HyperLink.PHONE);
        link.setText(Messages.getString("CaptionedControlShowCase.39")); //$NON-NLS-1$
        
        CaptionedControl capt4 = new CaptionedControl(composite, SWT.NONE);
        capt4.setText(Messages.getString("CaptionedControlShowCase.40")); //$NON-NLS-1$
        new TextExtension(capt4, SWT.NONE, TextExtension.EMAILADDRESS);
        
        CaptionedControl capt5 = new CaptionedControl(composite, SWT.NONE);
        capt5.setText(Messages.getString("CaptionedControlShowCase.41")); //$NON-NLS-1$
        SortedList list1 = new SortedList(capt5, SWT.BORDER | SWT.SINGLE);
        list1.add(Messages.getString("CaptionedControlShowCase.42")); //$NON-NLS-1$
        list1.add(Messages.getString("CaptionedControlShowCase.43")); //$NON-NLS-1$
        list1.add(Messages.getString("CaptionedControlShowCase.44"));  //$NON-NLS-1$
        
        CaptionedControl capt6 = new CaptionedControl(composite, SWT.NONE);
        capt6.setText(Messages.getString("CaptionedControlShowCase.45")); //$NON-NLS-1$
        SortedList list2 = new SortedList(capt6, SWT.BORDER | SWT.SINGLE, SortedList.FILTER);
        list2.add(Messages.getString("CaptionedControlShowCase.46")); //$NON-NLS-1$
        list2.add(Messages.getString("CaptionedControlShowCase.47")); //$NON-NLS-1$
        
        composite.pack();
        scrolledComposite.setContent(composite);
        scrolledComposite.setAutoScroll(true);
    }
    
    private void fillPageMobile2() {
        Composite page = multipagedialog.createPage(Messages.getString("CaptionedControlShowCase.48"), null); //$NON-NLS-1$
        
        // Create the Composite which managethe scrollBar.
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
			// Set layout on the scorlled Composite.
        scrolledComposite.setLayout(new FormLayout());
        if(viewPortMax.height>viewPortMax.width){
        	scrolledComposite.setBounds(viewPortMax.x, viewPortMax.y, viewPortMax.width, viewPortMax.height-50);
        }else{
        	scrolledComposite.setBounds(viewPortMax);
        }

		// Composite whihch content all Control
        Composite composite = new Composite(scrolledComposite, SWT.NONE);
        
        CaptionedControl capt1 = new CaptionedControl(composite, SWT.NONE);
        text = new Text(capt1, SWT.NONE);
        text.setText(Messages.getString("CaptionedControlShowCase.49")); //$NON-NLS-1$
        capt1.setText(Messages.getString("CaptionedControlShowCase.50")); //$NON-NLS-1$
        capt1.setTrailingText(Messages.getString("CaptionedControlShowCase.51")); //$NON-NLS-1$
		image = new Image(composite.getDisplay(), getClass().getResourceAsStream("/res/lb1details.png")); //$NON-NLS-1$
		capt1.setImage(image);
        
        CaptionedControl capt2 = new CaptionedControl(composite, SWT.NONE);
        capt2.setText(Messages.getString("CaptionedControlShowCase.53")); //$NON-NLS-1$
        ListBox listbox = new ListBox(capt2, SWT.BORDER | SWT.V_SCROLL, ListBox.LB_MOD_SHOW_SELECTION_NUMBER | ListBox.LB_STYLE_2LINE_ITEM);
        ListBoxItem[] array = {new ListBoxItem(Messages.getString("CaptionedControlShowCase.54"), null, Messages.getString("CaptionedControlShowCase.55"), null), //$NON-NLS-1$ //$NON-NLS-2$
                new ListBoxItem(Messages.getString("CaptionedControlShowCase.56"), null, Messages.getString("CaptionedControlShowCase.57"), null),  //$NON-NLS-1$ //$NON-NLS-2$
                new ListBoxItem(Messages.getString("CaptionedControlShowCase.58"), null, Messages.getString("CaptionedControlShowCase.59"), null),  //$NON-NLS-1$ //$NON-NLS-2$
                new ListBoxItem(Messages.getString("CaptionedControlShowCase.60"), null, Messages.getString("CaptionedControlShowCase.61"), null),  //$NON-NLS-1$ //$NON-NLS-2$
                new ListBoxItem(Messages.getString("CaptionedControlShowCase.62"), null, Messages.getString("CaptionedControlShowCase.63"), null),  //$NON-NLS-1$ //$NON-NLS-2$
                new ListBoxItem(Messages.getString("CaptionedControlShowCase.64"), null, Messages.getString("CaptionedControlShowCase.65"), null) //$NON-NLS-1$ //$NON-NLS-2$
        };
        listbox.setDataModel(array);
        
        CaptionedControl capt3 = new CaptionedControl(composite, SWT.NONE);
        capt3.setText(Messages.getString("CaptionedControlShowCase.66")); //$NON-NLS-1$
        ListView listview = new ListView(capt3, SWT.BORDER | SWT.HORIZONTAL);
        listview.add(Messages.getString("CaptionedControlShowCase.67"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.68"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.69"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.70"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.71"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.72"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.73"), null); //$NON-NLS-1$
        listview.add(Messages.getString("CaptionedControlShowCase.74"), null); //$NON-NLS-1$

        capt1.pack();
        capt2.pack();
        capt3.pack();
        
        int yCenterPos = Math.max(capt2.getSize().y, capt3.getSize().y);
        yCenterPos = capt1.getBounds().height + yCenterPos/2;

        capt1.setLocation(0, 0);
        setLocationOfYCenter(capt2, 0, yCenterPos);
        setLocationOfYCenter(capt3, capt2.getSize().x, yCenterPos);

        composite.pack();
        scrolledComposite.setContent(composite);
        scrolledComposite.setAutoScroll(true);
    }
    
    private void setLocationOfYCenter(Control control,int xLocation, int yCenterLocation) {
    	Point sizeOfControl = control.getSize();

    	control.setLocation(xLocation, yCenterLocation - sizeOfControl.y/2);
    }
    
    private void fillPageExpanded() {
        Composite page = multipagedialog.createPage(Messages.getString("CaptionedControlShowCase.75"), null); //$NON-NLS-1$

        // Create the Composite which managethe scrollBar.
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
			// Set layout on the scorlled Composite.
        scrolledComposite.setLayout(new FormLayout());
        scrolledComposite.setBounds(viewPortMax);

		// Composite whihch content all Control
        Composite composite = new Composite(scrolledComposite, SWT.NONE);

        CaptionedControl capt1 = new CaptionedControl(composite, SWT.NONE);
        capt1.setText(Messages.getString("CaptionedControlShowCase.76")); //$NON-NLS-1$
        table = new Table(capt1, SWT.SINGLE | SWT.CHECK | SWT.BORDER | SWT.H_SCROLL);
	    TableColumn column1 = new TableColumn(table, SWT.BORDER);
	    TableColumn column2 = new TableColumn(table, SWT.BORDER);	    
	    TableColumn column3 = new TableColumn(table, SWT.BORDER);	    

	    for (int i = 0; i < 6; i++) {
	        TableItem item = new TableItem(table,SWT.BORDER);
	        item.setText(0, Messages.getString("CaptionedControlShowCase.77") + (i + 1) + Messages.getString("CaptionedControlShowCase.78")); //$NON-NLS-1$ //$NON-NLS-2$
	        item.setText(1, Messages.getString("CaptionedControlShowCase.79") + (i + 1) + Messages.getString("CaptionedControlShowCase.80")); //$NON-NLS-1$ //$NON-NLS-2$
	        item.setText(2, Messages.getString("CaptionedControlShowCase.81") + (i + 1) + Messages.getString("CaptionedControlShowCase.82")); //$NON-NLS-1$ //$NON-NLS-2$
	        item.setText(3, Messages.getString("CaptionedControlShowCase.83") + (i + 1) + Messages.getString("CaptionedControlShowCase.84")); //$NON-NLS-1$ //$NON-NLS-2$
	        item.setText(4, Messages.getString("CaptionedControlShowCase.85") + (i + 1) + Messages.getString("CaptionedControlShowCase.86")); //$NON-NLS-1$ //$NON-NLS-2$
	        if ((i==1) || (i==4)) {
	            item.setChecked(true);
	        }
	    }    

	    column1.pack();
	    column2.pack();
	    column3.pack();

        CaptionedControl capt2 = new CaptionedControl(composite, SWT.NONE);
        capt2.setText(Messages.getString("CaptionedControlShowCase.87")); //$NON-NLS-1$
        Tree tree = new Tree(capt2, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);
        TreeItem root = new TreeItem(tree, SWT.NONE);
        TreeItem item1 = new TreeItem(root, SWT.NONE);
        TreeItem item2 = new TreeItem(root, SWT.NONE);
        TreeItem item3 = new TreeItem(root, SWT.NONE);
        TreeItem item4 = new TreeItem(root, SWT.NONE);
        TreeItem item5 = new TreeItem(root, SWT.NONE);
        TreeItem item21 = new TreeItem(item2, SWT.NONE);
        TreeItem item211 = new TreeItem(item21, SWT.NONE);
        TreeItem item22 = new TreeItem(item2, SWT.NONE);
        TreeItem item41 = new TreeItem(item4, SWT.NONE);
        
        root.setText(Messages.getString("CaptionedControlShowCase.88")); //$NON-NLS-1$
        item1.setText(Messages.getString("CaptionedControlShowCase.89")); //$NON-NLS-1$
        item2.setText(Messages.getString("CaptionedControlShowCase.90")); //$NON-NLS-1$
        item3.setText(Messages.getString("CaptionedControlShowCase.91")); //$NON-NLS-1$
        item4.setText(Messages.getString("CaptionedControlShowCase.92")); //$NON-NLS-1$
        item5.setText(Messages.getString("CaptionedControlShowCase.93")); //$NON-NLS-1$
        item21.setText(Messages.getString("CaptionedControlShowCase.94")); //$NON-NLS-1$
        item211.setText(Messages.getString("CaptionedControlShowCase.95")); //$NON-NLS-1$
        item22.setText(Messages.getString("CaptionedControlShowCase.96")); //$NON-NLS-1$
        item41.setText(Messages.getString("CaptionedControlShowCase.97")); //$NON-NLS-1$
        
        root.setExpanded(true);

        capt1.setLocation(0, 0);
        capt1.setSize(viewPortMax.width / 2 - 5, viewPortMax.height-25);

        capt2.setLocation(viewPortMax.width / 2, 0);
        capt2.setSize(viewPortMax.width / 2 - 5, viewPortMax.height-25);
        
        composite.pack();
        scrolledComposite.setContent(composite);
	    scrolledComposite.setAutoScroll(true);
    }
    
    public void widgetSelected(SelectionEvent e) {

        if (e.widget == commandDone) {
        	multipagedialog.close();
//            quit();
        }else if(e.widget == commandNextPage){
        	pageIndex++;
        	
        	if(pageIndex == multipagedialog.getPageCount()){
        		pageIndex = 0;
        	}
        	multipagedialog.setSelection(pageIndex);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

	public void handleEvent(Event e) {
		//If you relaunch this app on Nokia, it will launch the page you saw last time 
		//and focus in the first widget. So, each first widget of each page should 
		//handle this event.
		if(e.widget==list||e.widget==slider||e.widget==ct||e.widget==text||e.widget==table) {
			getComposite().getShell().setVisible(false);
		}
		
	}
}
