/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Command;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookEntry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
/**
 *
 *
 */
public class CommandEntryScreen implements SelectionListener, FocusListener {
    Shell parent;
    Shell shell;
    
    CommandShowCase showCaseParent;
    
    Text	lastname;
    Text	firstname;
    Combo	position;
    Combo	experience;
    
    Command commandDone;
    Command commandPlus;
	Command commandMinus;

	PhoneBookEntry phonebookentry;
    
    PhoneBookDataBase	dataBase;
    
    public CommandEntryScreen (Shell shellparent, CommandShowCase commandShowCase, PhoneBookEntry entry, PhoneBookDataBase dataBaseP) {
    	dataBase = dataBaseP;
        parent = shellparent;
		phonebookentry = entry;
		showCaseParent = commandShowCase;		
		
        shell = new Shell(parent, SWT.SHELL_TRIM | SWT.APPLICATION_MODAL);
		shell.setText(entry.getSurnameAndName());
		
		shell.setBounds(parent.getBounds());
		
		GridLayout gl = new GridLayout();
		gl.numColumns = 1;
		shell.setLayout(gl);
		
		CaptionedControl lastnameCT = new CaptionedControl(shell, SWT.LEFT_TO_RIGHT);
		lastnameCT.setText(Messages.getString("CommandEntryScreen.0")); //$NON-NLS-1$
		lastname = new Text(lastnameCT, SWT.SINGLE);
		lastname.setText(entry.getSurName());
		lastname.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		lastname.setSize(150,20);
		
		CaptionedControl firstnameCT = new CaptionedControl(shell, SWT.LEFT_TO_RIGHT);
		firstnameCT.setText(Messages.getString("CommandEntryScreen.1")); //$NON-NLS-1$
		firstname = new Text(firstnameCT, SWT.SINGLE);
		firstname.setText(entry.getName());
		firstname.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		firstname.setSize(150, 20);
		
		CaptionedControl positionCT = new CaptionedControl(shell, SWT.LEFT_TO_RIGHT);
		positionCT.setText(Messages.getString("CommandEntryScreen.2")); //$NON-NLS-1$
		position = new Combo(positionCT, SWT.SINGLE | SWT.READ_ONLY);
		position.add(Messages.getString("CommandEntryScreen.3")); //$NON-NLS-1$
		position.add(Messages.getString("CommandEntryScreen.4")); //$NON-NLS-1$
		position.add(Messages.getString("CommandEntryScreen.5")); //$NON-NLS-1$
		position.add(Messages.getString("CommandEntryScreen.6"));		 //$NON-NLS-1$
		position.setText(entry.getPosition());
		position.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		position.setSize(150,20);
		
		CaptionedControl experienceCT = new CaptionedControl(shell, SWT.LEFT_TO_RIGHT);
		experienceCT.setText(Messages.getString("CommandEntryScreen.7")); //$NON-NLS-1$
		experience = new Combo(experienceCT, SWT.SINGLE | SWT.READ_ONLY);
		experience.add(Messages.getString("CommandEntryScreen.8"));	 //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.9")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.10")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.11")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.12")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.13")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.14")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.15")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.16")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.17")); //$NON-NLS-1$
		experience.add(Messages.getString("CommandEntryScreen.18")); //$NON-NLS-1$
		experience.setText(entry.getExperience());
		experience.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		experience.setSize(150,20);
		experience.addSelectionListener(this);
		experience.addFocusListener(this);

		
		// Commands

		commandDone = new Command(shell, Command.EXIT, 0);
		commandDone.setText(Messages.getString("CommandEntryScreen.19")); //$NON-NLS-1$
		commandDone.addSelectionListener(this);
		
		commandPlus = new Command(experience, Command.GENERAL, 2);
		commandPlus.setText("+"); //$NON-NLS-1$
		commandPlus.addSelectionListener(this);
		
		commandMinus = new Command(experience, Command.GENERAL, 1);
		commandMinus.setText("-"); //$NON-NLS-1$
		commandMinus.addSelectionListener(this);
		
		shell.layout();
		shell.open();
    }


    public void widgetSelected(SelectionEvent arg0) {
       if (arg0.widget == commandDone) {
           phonebookentry.setName(firstname.getText());
           phonebookentry.setSurName(lastname.getText());
           phonebookentry.setPosition(position.getText());
           phonebookentry.setExperience(experience.getText());
           dataBase.update();
           showCaseParent.updateListAndDetails();
           shell.dispose();
       }
    else if (arg0.widget == experience) {
            updatePlusAndMinusCommands();
        }
        else if (arg0.widget == commandPlus) {
            experience.select(experience.getSelectionIndex() + 1);
            updatePlusAndMinusCommands();
        }
        else if (arg0.widget == commandMinus) {
            experience.select(experience.getSelectionIndex() - 1);
            updatePlusAndMinusCommands();
        }       
    }


    public void widgetDefaultSelected(SelectionEvent arg0) {
   
        
    }

     public void focusGained(FocusEvent arg0) {
         if (arg0.widget == experience) {
             updatePlusAndMinusCommands();
         }
    }


    public void focusLost(FocusEvent arg0) {
    }
    
    void updatePlusAndMinusCommands() {
        int selection = experience.getSelectionIndex();
        if (selection == 0) {
           commandMinus.setEnabled(false);
        }
        else {
           commandMinus.setEnabled(true);
        }
        if (selection == experience.getItemCount() - 1) {
            commandPlus.setEnabled(false);
        }
        else {
            commandPlus.setEnabled(true);
        }
    }
}
