/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Command;

import java.util.Vector;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.TaskTip;
import org.eclipse.ercp.swt.samples.eswtdemo.*;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookEntry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.FillLayout;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

/**
 *
 *
 */
public class CommandShowCase extends ShowCase implements SelectionListener, ModifyListener {
	private org.eclipse.swt.widgets.List   list;

	Command commandExit;
	
	Command commandOpen;
	Command commandDelete;
	
	Command	commandGroupSend;
	Command commandViaInfrared;
	Command commandViaBlueTooth;
	Command commandViaUSB;
	
	Text details;
	
	TaskTip sendingTaskTip;
	
	PhoneBookDataBase phoneBookDataBase;
	
	public CommandShowCase() {
	}
	
	public String getName() {
		return Messages.getString("CommandShowCase.0"); //$NON-NLS-1$
	}
	
	public void show() {
		phoneBookDataBase = PhoneBookDataBase.getThePhoneBook();
	    
		getComposite().setLayout(new FillLayout());
		
		commandExit = new Command(getComposite(), Command.EXIT, 0);
		commandExit.setText(Messages.getString("CommandShowCase.1")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("CommandShowCase.2")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);
		
		//
		//	List
		//
		list = new org.eclipse.swt.widgets.List(getComposite(), SWT.SINGLE | SWT.V_SCROLL);
		list.addSelectionListener(this);
		
		populateList();
		
		
		// create Commands			
		commandOpen = new Command(list, Command.SELECT, 3);
		commandOpen.setText(Messages.getString("CommandShowCase.3")); //$NON-NLS-1$
		commandOpen.addSelectionListener(this);
		commandOpen.setDefaultCommand();

		commandDelete = new Command(list, Command.GENERAL, 2);
		commandDelete.setText(Messages.getString("CommandShowCase.4"));	 //$NON-NLS-1$
		commandDelete.addSelectionListener(this);
		
		// Command Group Send
		commandGroupSend = new Command(list, Command.COMMANDGROUP, 1);
		commandGroupSend.setText(Messages.getString("CommandShowCase.5"));	 //$NON-NLS-1$
		 // Commands of the command group Send.
		commandViaInfrared = new Command(commandGroupSend, Command.GENERAL, 3);
		commandViaInfrared.setText(Messages.getString("CommandShowCase.6")); //$NON-NLS-1$
		commandViaInfrared.addSelectionListener(this);
		
		commandViaBlueTooth = new Command(commandGroupSend, Command.GENERAL, 2);
		commandViaBlueTooth.setText(Messages.getString("CommandShowCase.7")); //$NON-NLS-1$
		commandViaBlueTooth.addSelectionListener(this);
		
		commandViaUSB = new Command(commandGroupSend, Command.GENERAL, 1);
		commandViaUSB.setText(Messages.getString("CommandShowCase.8")); //$NON-NLS-1$
		commandViaUSB.addSelectionListener(this);
		
		
		//
		// details
		//
		details = new Text(getComposite(), SWT.SINGLE); 
		details.setText(""); //$NON-NLS-1$
		details.computeSize(SWT.DEFAULT, SWT.DEFAULT);
		details.setSize(150,20);
		details.addModifyListener(this);		

		getComposite().layout();
		list.setFocus();
		list.setSelection(0);
		
		if (list.getSelectionCount() > 0) {
		    showDetails(list.getSelectionIndex());
		}
	}
	
	boolean addToList(PhoneBookEntry entry) {
		boolean isAdded = false;
		PhoneBookEntry removedObject = null;
		if ( (removedObject = (PhoneBookEntry) phoneBookDataBase.removeEntry(entry)) == null) {
			phoneBookDataBase.addEntry(entry);
			
			String stringToAdd = entry.getSurnameAndName();
			String stringInTheWidgetList = ""; //$NON-NLS-1$
			int index = 0;
			boolean continueLoop = true;
			while ( (index < list.getItemCount()) && continueLoop == true) {
				stringInTheWidgetList = list.getItem(index);
				
				if ((stringInTheWidgetList.compareTo(stringToAdd) < 0)) {
					index++;					
				} else {
					continueLoop = false;
				}
			}
			list.add(entry.getSurnameAndName() , index);
			
			isAdded = true;
		} 
	    
	    return isAdded;
	}
	
	private void openEntry() {
	    if (list.getSelectionCount()>0) {
	    	String nameAndSurname = list.getItem(list.getSelectionIndex());
	    	PhoneBookEntry entry = phoneBookDataBase.getEntryWithSurnameAndName(nameAndSurname);
	    	
	    	if (entry != null) {
	        	CommandEntryScreen commandentryscreen = new CommandEntryScreen(getComposite().getShell(), this, entry, phoneBookDataBase);
	    	}
	    }
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		if (e.widget == list) {
			openEntry();
		}
	}
	
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandExit) {
			quit();
		}
		else if (e.widget==commandOpen) {
		    openEntry();
		}
		else if (e.widget==commandDelete) {
		    if (list.getSelectionCount()>0) {
		    	String nameAndSurname = list.getItem(list.getSelectionIndex());
		        MessageBox box = new MessageBox(getComposite().getShell(), SWT.ICON_QUESTION | SWT.YES | SWT.NO);
		        box.setMessage(Messages.getString("CommandShowCase.11") + nameAndSurname + Messages.getString("CommandShowCase.12")); //$NON-NLS-1$ //$NON-NLS-2$
		        int response = box.open();
		        if (response == SWT.YES) {
		    		PhoneBookEntry phoneBookEntry = phoneBookDataBase.getEntryWithSurnameAndName(nameAndSurname);
		        	phoneBookDataBase.removeEntry(phoneBookEntry);
		            list.remove(list.getSelectionIndex());
				    if (list.getItemCount() > 0) {
				        list.setSelection(0);				        
				        showDetails(0);
				    }
				    else {
				        details.setText(""); //$NON-NLS-1$
				    }
		        }
		    }
		}
		else if (e.widget==list) {
		    if (list.getSelectionCount()>0) {
		        showDetails(list.getSelectionIndex());
		    }		    
		}
		else if (e.widget == commandViaBlueTooth || e.widget == commandViaInfrared || e.widget == commandViaUSB) {
			send();
		}
	}
	
	private void send() {
		if (sendingTaskTip == null) {
			sendingTaskTip = new TaskTip(getComposite().getShell(), SWT.SMOOTH);
		}
		
		sendingTaskTip.setText(Messages.getString("CommandShowCase.14")); //$NON-NLS-1$

		sendingTaskTip.setMinimum(0);
		sendingTaskTip.setMaximum(100);
		sendingTaskTip.setVisible(true);
		
		getComposite().getShell().getDisplay().asyncExec(new Runnable() {
			int selection = 0;
			int deltaTime = 5000/100;

			public void run() {
			    if (sendingTaskTip.isDisposed()) {
			        return;
			    }
				sendingTaskTip.setSelection(selection);
				
				selection++;
				
				if (selection <= 100) {
				    getComposite().getShell().getDisplay().timerExec(deltaTime, this);
				} else {
					sendingTaskTip.setVisible(false);
				}
			}}
		);
	}
	
	public void quit() {
		commandExit.dispose();
		commandOpen.dispose();
		commandDelete.dispose();		
		commandGroupSend.dispose();
		commandViaInfrared.dispose();
		commandViaBlueTooth.dispose();
		commandViaUSB.dispose();
		if (sendingTaskTip != null) {
		    sendingTaskTip.dispose();
		}
	    dispose();
	}
	
	private void showDetails(int index) {
		String nameSurname = list.getItem(index);
		PhoneBookEntry entry = phoneBookDataBase.getEntryWithSurnameAndName(nameSurname);
		
		if (entry != null) {
			details.setText(entry.get0rganization());
		}
	}

	private void populateList() {
	    list.removeAll();
	    Vector entries = phoneBookDataBase.getSurnameNameVector();
	    for (int i = 0; i < entries.size(); i++) {
	        list.add((String)entries.get(i));
	    }
	}
	
	protected void updateListAndDetails() {
	    populateList();
	    if (list.getSelectionCount()>0) {
	        showDetails(list.getSelectionIndex());
	    }		    
	}

   public void modifyText(ModifyEvent e) {
       if (e.widget == details) {
           if (list.getSelectionIndex() >= 0) {
       			String nameSurname = list.getItem(list.getSelectionIndex());
       			PhoneBookEntry entry = phoneBookDataBase.getEntryWithSurnameAndName(nameSurname);
       			if (entry != null) {
       			    entry.set0rganization(details.getText());
       			}
           }
       }            
   }
}
