/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;

import java.util.Vector;

import org.eclipse.ercp.swt.samples.eswtdemo.MainMenu;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Composite;


public class CompositeShowCase extends ShowCase implements SelectionListener {

	static public CompositeShowCase instance;
    private MobileShell mobileShell;
    private Command commandExit;
    private MainMenu mainMenu;
	
	/**
	 * Constructor
	 *
	 */
	public CompositeShowCase() {
		instance = this;
	}
	
	
	/**
	 * Load the ShowCases and add it to the list
	 * 
	 * @return list of the ShowCases
	 */
	private Vector loadShowCases() {
		Vector showCases = new Vector();

		showCases.add(new CompositeShowCaseSimpleLayout());
		showCases.add(new CompositeShowCaseComplexLayout(mobileShell));

		return showCases;
	}


    public String getName() {
        return Messages.getString("CompositeShowCase.0"); //$NON-NLS-1$
    }

    public Composite getComposite() {
    	return mobileShell;
    }

    public void show() {
	    mobileShell = new MobileShell(Display.getCurrent(), SWT.TITLE | SWT.MIN | SWT.MAX | SWT.RESIZE);
	    mobileShell.setText(Messages.getString("CompositeShowCase.1")); //$NON-NLS-1$

	    Vector showCases = loadShowCases();
		mainMenu = new MainMenu(getComposite(), showCases);
		
		enableExit(true);
		getComposite().forceFocus();
		mobileShell.open();
    }
    
    public void widgetSelected(SelectionEvent e) {
    	//commandExit.removeSelectionListener(this);
    	commandExit.dispose();
    	commandExit = null;
    	mobileShell.dispose();
    	dispose();
    }
    
    public void widgetDefaultSelected(SelectionEvent e) {
    }
    
    public void enableExit(boolean enable) {
    	if (enable) {
       		if (commandExit == null) {
    			commandExit = new Command(getComposite(), Command.EXIT, 0);
    			commandExit.setText(Messages.getString("CompositeShowCase.2")); //$NON-NLS-1$
    			commandExit.setLongLabel(Messages.getString("CompositeShowCase.3")); //$NON-NLS-1$
    			commandExit.addSelectionListener(this);
    		}
    	} else {
    		if (commandExit != null) {
    			commandExit.dispose();
    			commandExit = null;
    		}	
     	}	
    }
    
    static public CompositeShowCase getInstance() {
    	return instance;
    }

	protected void setFocus() {
		mobileShell.forceActive();
		mainMenu.setFocus();		
	}
}
