/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 *
 *
 */
public class CompositeShowCaseComplexLayout extends ShowCase implements SelectionListener, ControlListener, KeyListener {
    MobileShell mobileShell; // the top level shell
    // The canvas containing the coordinates
    Canvas		coordinatedCanvas;
    // Vertical ScrollBar of coordinatedCanvas 
    ScrollBar vSrollBarCoordinatedCanvas;
    // Last value of the ScrollBar.
	int 		lastScrollBarSelection = 0;
		// Data for the layout of coordinatedCanvas. 
    FormData 	coordinatedCanvasFormdata;
    int			coordinatedCanvasAttachementLeft = 	5;
    int			coordinatedCanvasAttachementTop = 	5;
    
    // CaptionedControls contained by the coordinatedCanvas.
    CaptionedControl	lastNameCptCtrl;
    Text 				textLastName;
    CaptionedControl	firstNameCptCtrl;
    Text				textFirstName;
    CaptionedControl	telephoneCptCtrl;
    ConstrainedText		textTelephone;
    CaptionedControl	mobileCptCtrl;
    ConstrainedText 	textMobile;

    // The canvas wich contains the picture.
    Canvas		pictureCanvas;
    // Command to change the picture.
    Command 	commandSelectedPicture;
    // Command to remove the picture and set the default picture.
    Command 	commandRemoveSelectedPicture;
    
    // The middle separator.
    Label		separatorLabel;
    
    // The Skills Label.
    Label		skillsLabel;
    
    // The Skills Text.
    Text		skillsText;
    
    Command 	commandGrow;
    Command 	commandShrink;
    Command		commandExit;

    static int	MOBILESHELL_STATE_SMALL = 0;
    static int	MOBILESHELL_STATE_NORMAL = 1;
    static int	MOBILESHELL_STATE_FULLSCREEN = 2;
    
    int 		mobileshellstate = MOBILESHELL_STATE_SMALL;

    Image 		defaultPicture;
    Image 		selectedPicture;
    
    CompositeShowCaseComplexLayout(MobileShell mobileShell) {
        this.mobileShell = mobileShell;
    }
    
    public String getName() {
        return Messages.getString("CompositeShowCaseComplexLayout.0"); //$NON-NLS-1$
    }
    
    private void createControls() {
    	// The canvas wich contains the coordinated.
    	coordinatedCanvas = new Canvas(getComposite(), SWT.BORDER | SWT.V_SCROLL | SWT.NO_FOCUS);
    	coordinatedCanvas.addControlListener(this);

    	// The LastName.
		lastNameCptCtrl = new CaptionedControl(coordinatedCanvas, SWT.LEFT_TO_RIGHT);
		lastNameCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.1")); //$NON-NLS-1$
		textLastName = new Text(lastNameCptCtrl,SWT.SINGLE);
		textLastName.setText(Messages.getString("CompositeShowCaseComplexLayout.2")); //$NON-NLS-1$
		textLastName.setSize(200,20);
		// The First Name.
		firstNameCptCtrl = new CaptionedControl(coordinatedCanvas, SWT.LEFT_TO_RIGHT);
		firstNameCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.3")); //$NON-NLS-1$
		textFirstName = new Text(firstNameCptCtrl,SWT.SINGLE);
		textFirstName.setText(Messages.getString("CompositeShowCaseComplexLayout.4")); //$NON-NLS-1$
		textFirstName.setSize(200,20);
		// The Telephone.
		telephoneCptCtrl = new CaptionedControl(coordinatedCanvas, SWT.LEFT_TO_RIGHT);
		telephoneCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.5")); //$NON-NLS-1$
		textTelephone = new ConstrainedText(telephoneCptCtrl,SWT.SINGLE, ConstrainedText.PHONENUMBER);
		textTelephone.setText(Messages.getString("CompositeShowCaseComplexLayout.6")); //$NON-NLS-1$
		textTelephone.setSize(200,20);
		// The Mobile.
		mobileCptCtrl = new CaptionedControl(coordinatedCanvas, SWT.LEFT_TO_RIGHT);
		mobileCptCtrl.setText(Messages.getString("CompositeShowCaseComplexLayout.7")); //$NON-NLS-1$
		textMobile = new ConstrainedText(mobileCptCtrl,SWT.SINGLE, ConstrainedText.PHONENUMBER);
		textMobile.setSize(200,20);

		// The default picture.
		defaultPicture = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/smith.png")); //$NON-NLS-1$
		// The selected picture.
		selectedPicture = null;
		// Canvas containing the picture.
		pictureCanvas = new Canvas(getComposite(), SWT.NORMAL | SWT.NO_FOCUS);
		pictureCanvas.setSize(defaultPicture.getBounds().width,defaultPicture.getBounds().height);
		pictureCanvas.addPaintListener(paintPicture);
		pictureCanvas.addControlListener(this);
		pictureCanvas.addKeyListener(this);
		

		// Label separator in the middle of the height screen.
		separatorLabel = new Label(getComposite(), SWT.SEPARATOR | SWT.HORIZONTAL);
		separatorLabel.setSize(SWT.DEFAULT,1);

		// Label "Skills".
		skillsLabel = new Label(getComposite(), SWT.NORMAL);
		skillsLabel.setText(Messages.getString("CompositeShowCaseComplexLayout.9")); //$NON-NLS-1$
		skillsLabel.setSize(200,10);
		
		// The Skills Text.
		skillsText = new Text(getComposite(), SWT.MULTI | SWT.BORDER | SWT.V_SCROLL);
		skillsText.setText(Messages.getString("CompositeShowCaseComplexLayout.10"));    	 //$NON-NLS-1$
    }
    
    private void applyLayoutOnControls() {

		FormLayout formLayoutshell = new FormLayout();
		getComposite().setLayout(formLayoutshell);    	
    	
		// Composite		
		FormLayout formLayoutCoordinatedCanvas = new FormLayout();
		coordinatedCanvasFormdata = new FormData();
		coordinatedCanvasFormdata.left = new FormAttachment(0, coordinatedCanvasAttachementLeft);
		coordinatedCanvasFormdata.top = new FormAttachment(0, coordinatedCanvasAttachementTop);
		coordinatedCanvasFormdata.bottom = new FormAttachment(separatorLabel, -5);
		coordinatedCanvas.setLayout(formLayoutCoordinatedCanvas);
    	coordinatedCanvas.setLayoutData(coordinatedCanvasFormdata);
		
		// CaptionedControl for the Last Name.
		int space = 5;
		FormData lastnameformdata = new FormData();
		lastnameformdata.left = new FormAttachment(0, 0);
		lastnameformdata.top = new FormAttachment(0, 0);
		lastNameCptCtrl.setLayoutData(lastnameformdata);

		// CaptionedControl for the First Name.
		FormData firstnameformdata = new FormData();
		firstnameformdata.left = new FormAttachment(0, space);
		firstnameformdata.top = new FormAttachment(lastNameCptCtrl, space);
		firstNameCptCtrl.setLayoutData(firstnameformdata);

		// CaptionedControl for the Telephone.
		FormData telephoneformdata = new FormData();
		telephoneformdata.left = new FormAttachment(0, space);
		telephoneformdata.top = new FormAttachment(firstNameCptCtrl, space);
		telephoneCptCtrl.setLayoutData(telephoneformdata);

		// CaptionedControl for the Mobile.
		FormData mobileFormData = new FormData();
		mobileFormData.left = new FormAttachment(0, space);
		mobileFormData.top = new FormAttachment(telephoneCptCtrl, space);
		mobileCptCtrl.setLayoutData(mobileFormData);

		// Canvas containing the picture.
		FormData canvasFormData = new FormData();
		canvasFormData.right = new FormAttachment(100,-5);
		canvasFormData.top = new FormAttachment(0,5);
		canvasFormData.bottom = new FormAttachment(separatorLabel, -5);
		canvasFormData.left = new FormAttachment(coordinatedCanvas, 5);
		pictureCanvas.setLayoutData(canvasFormData);		

		// Label separator in the middle of the height screen.
		FormData separatorFormdata = new FormData();
		separatorFormdata.top = new FormAttachment(50,0);
		separatorFormdata.left = new FormAttachment(0,5);
		separatorFormdata.right = new FormAttachment(100,-5);
		separatorLabel.setLayoutData(separatorFormdata);
		
		// Label "Skills".
		FormData labelskillFormdata = new FormData();
		labelskillFormdata.left = new FormAttachment(0, space);
		labelskillFormdata.top = new FormAttachment(separatorLabel, space);
		skillsLabel.setLayoutData(labelskillFormdata);
		
		// Text "Skills".
		FormData skillTextFormData = new FormData();
		skillTextFormData.left = new FormAttachment(0,5);
		skillTextFormData.right = new FormAttachment(100,-5);
		skillTextFormData.top = new FormAttachment(skillsLabel,5);
		skillTextFormData.bottom = new FormAttachment(100,-5);
		skillsText.setLayoutData(skillTextFormData);

		getComposite().layout();
		getComposite().setFocus();
    }

    public void show() {
		mobileShell.setText(Messages.getString("CompositeShowCaseComplexLayout.11")); //$NON-NLS-1$

		createControls();

		applyLayoutOnControls();

		createCommands();

		vSrollBarCoordinatedCanvas = coordinatedCanvas.getVerticalBar();

		vSrollBarCoordinatedCanvas.addSelectionListener(scrollBarListener);	
		updateScrollBarSize();
		
		// Add a focus listener to move the scroll bar.
		textLastName.addFocusListener(focusListener);
		textFirstName.addFocusListener(focusListener);
		textTelephone.addFocusListener(focusListener);
		textMobile.addFocusListener(focusListener);

		changeMobileShellSize();
		getComposite().setFocus();
    }
    
    private void createCommands() {
		// Add commands
		commandGrow = new Command(getComposite(), Command.GENERAL, 3);
		commandGrow.setText(Messages.getString("CompositeShowCaseComplexLayout.12")); //$NON-NLS-1$
		commandGrow.addSelectionListener(this);

		commandShrink = new Command(getComposite(), Command.GENERAL, 1);
		commandShrink.setText(Messages.getString("CompositeShowCaseComplexLayout.13")); //$NON-NLS-1$
		commandShrink.addSelectionListener(this);

		// If we remove this command, the showcase exit command throws an exception. 
		// To be investigated.
		commandExit = new Command(getComposite(), Command.EXIT, 0);
		commandExit.setText(Messages.getString("CompositeShowCaseComplexLayout.14")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.15")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);

		//disable CompositeShowCase's exit
		CompositeShowCase.getInstance().enableExit(false);

		// Command to choose a picture.
		commandSelectedPicture = new Command(pictureCanvas, Command.GENERAL, 3);
		commandSelectedPicture.setText(Messages.getString("CompositeShowCaseComplexLayout.16")); //$NON-NLS-1$
		commandSelectedPicture.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.17")); //$NON-NLS-1$
		commandSelectedPicture.addSelectionListener(this);
		
		// Command to remove the selected picture.
		commandRemoveSelectedPicture = new Command(pictureCanvas, Command.GENERAL, 1);
		commandRemoveSelectedPicture.setText(Messages.getString("CompositeShowCaseComplexLayout.18")); //$NON-NLS-1$
		commandRemoveSelectedPicture.setLongLabel(Messages.getString("CompositeShowCaseComplexLayout.19")); //$NON-NLS-1$
		commandRemoveSelectedPicture.addSelectionListener(this);
    }
    
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandGrow) {
			grow();
		} else if (e.widget==commandShrink) {
			shrink();
		} else if (e.widget==commandExit) {
			quit();
		} else if (e.widget==commandSelectedPicture) {
			chooseAPicture();
		}  else if (e.widget==commandRemoveSelectedPicture) {
			if (selectedPicture != null) {
				selectedPicture.dispose();
				selectedPicture = null;
			    pictureCanvas.redraw();
			}
		} 
 	}

	public void widgetDefaultSelected(SelectionEvent e) {
 	}

	private void quit() {
		//move these two methods beforehand since these two methods will cause
		//pictureCanvas to repaint on Nokia
		//fix bug BMHL7Q3AN2
		mobileShell.setFullScreenMode(false);
        mobileShell.changeTrim(SWT.TITLE, MobileShell.SMALL_STATUS_PANE);
        
		vSrollBarCoordinatedCanvas.removeSelectionListener(scrollBarListener);
		vSrollBarCoordinatedCanvas = null;

	    commandSelectedPicture.dispose();
	    commandRemoveSelectedPicture.dispose();
	    commandGrow.dispose();
	    commandShrink.dispose();
	    commandExit.dispose();

		//enable CompositeShowCase's exit
		CompositeShowCase.getInstance().enableExit(true);

		dispose();
		
		if (selectedPicture != null) {
			selectedPicture.dispose();
		}
		if (defaultPicture != null) {
			defaultPicture.dispose();
		}

	}
	
	private void grow() {
	    if (mobileshellstate== MOBILESHELL_STATE_FULLSCREEN) {
	        return;
	    }
	    mobileshellstate++;
	    commandShrink.setEnabled(true);
	    changeMobileShellSize();
	}
	
	private void shrink() {
	    if (mobileshellstate==MOBILESHELL_STATE_SMALL) {
	        return;
	    }
	    mobileshellstate--;
	    commandGrow.setEnabled(true);
	    changeMobileShellSize();
	}
	
	private void changeMobileShellSize() {
		vSrollBarCoordinatedCanvas.setSelection(vSrollBarCoordinatedCanvas.getMinimum());
	    updateCanvasWithScrolBar();	
	    updateScrollBarSize();			

	    if (mobileshellstate == MOBILESHELL_STATE_SMALL) {
	        // Small mobileShell = normal status pane + no fullscreen mode (command available)
	        mobileShell.setFullScreenMode(false);
	        mobileShell.changeTrim(SWT.TITLE, MobileShell.LARGE_STATUS_PANE);
	        commandShrink.setEnabled(false);
	    }
	    if (mobileshellstate == MOBILESHELL_STATE_NORMAL) {
	        // Normal mobileshell = Small status spane (more space available) and no fullscreen mode
	        mobileShell.setFullScreenMode(false);
	        mobileShell.changeTrim(SWT.TITLE, MobileShell.SMALL_STATUS_PANE);
	    }
	    if (mobileshellstate == MOBILESHELL_STATE_FULLSCREEN) {
	        // fullscreen mode no trim.
	        mobileShell.setFullScreenMode(true);
	        mobileShell.changeTrim(SWT.NO_TRIM, MobileShell.NO_STATUS_PANE);
	        commandGrow.setEnabled(false);
	        
	        Display.getCurrent().timerExec(10000, new Runnable() {
	        	public void run() {
	        		shrink();
	        	}	
	        });	
	    }
	}
	
	private void chooseAPicture() {
		if (selectedPicture != null) {
			selectedPicture.dispose();
			selectedPicture = null;
		}
		try{
			FileDialog fileDialog = new FileDialog(mobileShell, SWT.OPEN);
			
			fileDialog.setFilterExtensions(new String[]{"*.gif", "*.png", "*.jpg"}); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			fileDialog.open();
			
			String pathImage = fileDialog.getFileName();
			String filterPath = fileDialog.getFilterPath();
			String fullPath = filterPath + pathImage;
			fullPath = fullPath.replace('\\', '/');
			selectedPicture = new Image(getComposite().getDisplay(), fullPath);
			
		} catch (Exception ex) {
			selectedPicture = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/smith.jpg")); //$NON-NLS-1$
		}
	    pictureCanvas.redraw();
	}
	
	private Rectangle getChildrenBounds(Composite parent) {
		// Calculate the rectangle Area of all children Controls.
    	Rectangle containerArea = null;
		Control[] childrenControls = coordinatedCanvas.getChildren();
		for (int i =0; i < childrenControls.length; i ++) {
			if (containerArea == null) {
				containerArea = new Rectangle(childrenControls[i].getBounds().x, childrenControls[i].getBounds().y, childrenControls[i].getBounds().width, childrenControls[i].getBounds().height);
			} else {
				containerArea.add(childrenControls[i].getBounds());
			}
		}
		
		return containerArea;		
	}
	
	private void updateScrollBarSize() {
    	if (vSrollBarCoordinatedCanvas !=  null ) {
    		int selection = vSrollBarCoordinatedCanvas.getSelection();
			Rectangle containerArea = getChildrenBounds(coordinatedCanvas);
			Rectangle clientArea = coordinatedCanvas.getClientArea();
			
//			int deltaHeight = containerArea.height - clientArea.height;
			vSrollBarCoordinatedCanvas.setMaximum(containerArea.height);
			vSrollBarCoordinatedCanvas.setMinimum(0);
			vSrollBarCoordinatedCanvas.setThumb(clientArea.height);
			vSrollBarCoordinatedCanvas.setPageIncrement(clientArea.height);
			vSrollBarCoordinatedCanvas.setIncrement(clientArea.height/10);	

    		vSrollBarCoordinatedCanvas.setSelection(selection);
    	}
	}
	
	private void updateCanvasWithScrolBar() {
		int selection = vSrollBarCoordinatedCanvas.getSelection();
		
		Rectangle containerArea = getChildrenBounds(coordinatedCanvas);
		coordinatedCanvas.scroll(containerArea.x, containerArea.y + (lastScrollBarSelection - selection), containerArea.x, containerArea.y, containerArea.width, containerArea.height, true);
						
		lastScrollBarSelection = selection;
	}
	
	FocusListener focusListener = new FocusListener() {
		public void focusGained(FocusEvent e) {
			
			if (e.widget == textLastName || e.widget == textFirstName) {
				vSrollBarCoordinatedCanvas.setSelection(vSrollBarCoordinatedCanvas.getMinimum());
				updateCanvasWithScrolBar();
				
			} else if (e.widget == textTelephone || e.widget == textMobile) {
				vSrollBarCoordinatedCanvas.setSelection(vSrollBarCoordinatedCanvas.getMaximum());
				updateCanvasWithScrolBar();
				
			}
		}

		public void focusLost(FocusEvent e) {
		}
	};

	SelectionListener scrollBarListener = new SelectionListener() {
		public void widgetSelected(SelectionEvent e) {
			if (e.widget == vSrollBarCoordinatedCanvas) {
				updateCanvasWithScrolBar();
			}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};

	PaintListener paintPicture = new PaintListener() { 
	    public void paintControl(PaintEvent e) {
	    	Image image = selectedPicture != null ? selectedPicture : defaultPicture;
			Rectangle imageBnds  = image.getBounds();
			Rectangle canvasBnds = ((Canvas)(e.widget)).getBounds();
			int w,h,dx,dy;
			
			float ratio = ((float)imageBnds.width)/((float)imageBnds.height);
		    w = (int)(((float)canvasBnds.height)*ratio);
		    h = canvasBnds.height;
		    dx = (canvasBnds.width-w)/2;
		    dy = 0;
		    
		    if (w>canvasBnds.width) {
				w = canvasBnds.width;
				h = (int)(((float)canvasBnds.width)*ratio);
				dx = 0;
				dy = (canvasBnds.height-h)/2;
		    }
			
			e.gc.drawImage(image, 0, 0, imageBnds.width, imageBnds.height, dx,dy, w, h);
			e.gc.setForeground(getComposite().getDisplay().getSystemColor(SWT.COLOR_WIDGET_BORDER));
			if (((Canvas)(e.widget)).isFocusControl()) {
			    e.gc.drawRectangle(0,0,canvasBnds.width-1,canvasBnds.height-1);
			}
	    }
	};


    public void controlMoved(ControlEvent e) {
    }


    public void controlResized(ControlEvent e) {
    	if (e.widget == coordinatedCanvas) {
    		updateScrollBarSize();
    	} else if (e.widget == pictureCanvas) {
    		
    	}
    }
	protected void setFocus() {
		mobileShell.forceActive();
	}

	public void keyPressed(KeyEvent e) {
		if (e.widget == pictureCanvas){
			if (e.keyCode==SWT.ARROW_RIGHT) {
				
			}
			else if (e.keyCode==SWT.ARROW_LEFT) {
			
			} 
			else if (e.keyCode==SWT.ARROW_DOWN) {
				skillsText.setFocus();
				
			} 
			else if (e.keyCode==SWT.ARROW_UP) {
				mobileCptCtrl.setFocus();
			} 
		}
		
	}

	public void keyReleased(KeyEvent e) {
	}

}
