/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Composite;


import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/**
 *
 *
 */
public class CompositeShowCaseSimpleLayout extends ShowCase implements SelectionListener {
	Composite composite;
	
	Command commandExit;
	Command commandChangeLayout;
	
	Command commandOrientation;
	
    Command 	commandGrow;
    Command 	commandShrink;
    
    // For GridLayout.
    // Number of columns.
    Command		commandNumColumns;
    int[]		allNumColumns = new int[] {1, 2, 3};
    String[]	allNamesNumColumns = new String[] {Messages.getString("CompositeShowCaseSimpleLayout.0"), Messages.getString("CompositeShowCaseSimpleLayout.1"), Messages.getString("CompositeShowCaseSimpleLayout.2"), }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    int			indexNumColumns = 0;
    // Make columns width equals.
    Command		commandMakeColumnsEqualWidth;
    String[]	namesMakeColumnsEqualWidth = new String [] {Messages.getString("CompositeShowCaseSimpleLayout.3"), Messages.getString("CompositeShowCaseSimpleLayout.4")}; //$NON-NLS-1$ //$NON-NLS-2$
    boolean		isColumnsEqualWidth = false;
    // Horizontal alignment for the List contains Animal.
    Command		commandGroupAnimalHorizontalAlignment;
    String		nameCommandGroupHorizAligVal = Messages.getString("CompositeShowCaseSimpleLayout.5"); //$NON-NLS-1$
    Command		commandCENTER;
    Command		commandBEGINNING;
    Command		commandEND;
    Command		commandFILL;
    String[]	allNamesAlignmentValue = new String[] {"CENTER", "BEGINNING", "END", "FILL"}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
    int			indexHAlignmentValue = 0;
    // Horizontal or vertical Span.
    Command		commandGroupSpan;
    String		nameCommandGroupSpan = Messages.getString("CompositeShowCaseSimpleLayout.10"); //$NON-NLS-1$
    int[]		allSpanValues = new int[] {1, 2};
    String[]	allNamesSpanValues = new String[] {Messages.getString("CompositeShowCaseSimpleLayout.11"), Messages.getString("CompositeShowCaseSimpleLayout.12"), Messages.getString("CompositeShowCaseSimpleLayout.13"), }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    	// HSpanAnimal.
    Command		commandHSpanAnimal;
    int			indexHSpanAnimal = 0;
    String[]	namesCommandHSpanAnimal = new String[] {Messages.getString("CompositeShowCaseSimpleLayout.14"), Messages.getString("CompositeShowCaseSimpleLayout.15")}; //$NON-NLS-1$ //$NON-NLS-2$
    	// HSpanElement.
    Command		commandHSpanElement;
    int			indexHSpanElement = 0;
    String[]	namesCommandHSpanElement = new String[] {Messages.getString("CompositeShowCaseSimpleLayout.16"), Messages.getString("CompositeShowCaseSimpleLayout.17")}; //$NON-NLS-1$ //$NON-NLS-2$
    	// VSpanFruit.
    Command		commandVSpanFruit;
    int			indexVSpanFruit = 0;
    String[]	namesCommandVSpanFruit = new String[] {Messages.getString("CompositeShowCaseSimpleLayout.18"), Messages.getString("CompositeShowCaseSimpleLayout.19")}; //$NON-NLS-1$ //$NON-NLS-2$
    //
    Command		commandGrabExcessH;
    String[]	namesGrabExcessH= new String [] {Messages.getString("CompositeShowCaseSimpleLayout.20"), Messages.getString("CompositeShowCaseSimpleLayout.21")}; //$NON-NLS-1$ //$NON-NLS-2$
    boolean		isGrabExcessH = false;
    Command		commandGrabExcessV;
    String[]	namesGrabExcessV = new String [] {Messages.getString("CompositeShowCaseSimpleLayout.22"), Messages.getString("CompositeShowCaseSimpleLayout.23")}; //$NON-NLS-1$ //$NON-NLS-2$
    boolean		isGrabExcessV = false;
 	
	List[] lists; 
	
	String[] listItems1 = {Messages.getString("CompositeShowCaseSimpleLayout.24"),Messages.getString("CompositeShowCaseSimpleLayout.25"),Messages.getString("CompositeShowCaseSimpleLayout.26")/*,"Black"*/}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	String[] listItems2 = {Messages.getString("CompositeShowCaseSimpleLayout.27"), Messages.getString("CompositeShowCaseSimpleLayout.28"), Messages.getString("CompositeShowCaseSimpleLayout.29")/*, "Fire"*/}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	String[] listItems3 = {Messages.getString("CompositeShowCaseSimpleLayout.30"), Messages.getString("CompositeShowCaseSimpleLayout.31"), Messages.getString("CompositeShowCaseSimpleLayout.32")/*, "Peach"*/}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	String[] listItems4 = {Messages.getString("CompositeShowCaseSimpleLayout.33"), Messages.getString("CompositeShowCaseSimpleLayout.34"), Messages.getString("CompositeShowCaseSimpleLayout.35")/*, "Right"*/}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	String[] listItems5 = {Messages.getString("CompositeShowCaseSimpleLayout.36"), Messages.getString("CompositeShowCaseSimpleLayout.37"), Messages.getString("CompositeShowCaseSimpleLayout.38")/*, "Mouse"*/};	 //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	
    int currentLayout = FILLLAYOUT;
 
    // used for command and shell title
    String[] layoutTexts = {"FillLayout","RowLayout","GridLayout"}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    
    static int FILLLAYOUT 	= 	0; 
    static int ROWLAYOUT 	= 	1;
    static int GRIDLAYOUT 	= 	2;
    
    
    int orientationoption = OPTIONHORIZONTAL;
    
    static int OPTIONVERTICAL 	= 0;
    static int OPTIONHORIZONTAL = 1;
    
    String[] orentationTexts = {Messages.getString("CompositeShowCaseSimpleLayout.42"),Messages.getString("CompositeShowCaseSimpleLayout.43")}; //$NON-NLS-1$ //$NON-NLS-2$
       
    
    int 	sizeoption = SIZE_BIG;
    
    static int SIZE_SMALL 		= 0;
    static int SIZE_MEDIUM 		= 1;
    static int SIZE_BIG 		= 2;
            
	public String getName() {
        return Messages.getString("CompositeShowCaseSimpleLayout.44"); //$NON-NLS-1$
    }

 
    public void show() {
		composite = new Composite(getComposite(),SWT.BORDER);
		composite.setLocation(0,0);
		
		lists = new List[5];
		for (int i=0;i<5;i++) {
		    lists[i] = new List(composite,SWT.NORMAL|SWT.BORDER|SWT.V_SCROLL);     
		}
		
		for (int i=0;i<listItems1.length;i++) {
		    lists[0].add(listItems1[i]);
		}
		for (int i=0;i<listItems2.length;i++) {
		    lists[1].add(listItems2[i]);
		}
		for (int i=0;i<listItems3.length;i++) {
		    lists[2].add(listItems3[i]);
		}
		for (int i=0;i<listItems4.length;i++) {
		    lists[3].add(listItems4[i]);
		}
		for (int i=0;i<listItems5.length;i++) {
		    lists[4].add(listItems5[i]);
		}
		
		getComposite().layout();
		getComposite().setFocus();
		
		// create Exit command - disabled for the moment
		// If we remove this command, the showcase exit command throws an exception. 
		// To be investigated.
		commandExit = new Command(getComposite(), Command.EXIT, 0);
		commandExit.setText(Messages.getString("CompositeShowCaseSimpleLayout.45")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("CompositeShowCaseSimpleLayout.46")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);

		//disable CompositeShowCase's exit
		CompositeShowCase.getInstance().enableExit(false);

		// create Layout command
		commandChangeLayout = new Command(getComposite(), Command.SELECT, 20);
		commandChangeLayout.setText(layoutTexts[(currentLayout+1)%3]);
		commandChangeLayout.setDefaultCommand();
		commandChangeLayout.addSelectionListener(this);
		
		// Shrink/Grow commands
		commandGrow = new Command(getComposite(), Command.GENERAL, 19);
		commandGrow.setText(Messages.getString("CompositeShowCaseSimpleLayout.47")); //$NON-NLS-1$
		commandGrow.addSelectionListener(this);
		
		commandShrink = new Command(getComposite(), Command.GENERAL, 18);
		commandShrink.setText(Messages.getString("CompositeShowCaseSimpleLayout.48")); //$NON-NLS-1$
		commandShrink.addSelectionListener(this);
		
		currentLayout--;
		changeLayout();
		
		setOptionCommands();
		
		changeCompositeSize();
//		composite.setLayout(new FillLayout()); Fix for blank screen when layout=grid and go back to menu then open again
		composite.layout();
		getComposite().getShell().setText(layoutTexts[currentLayout]);
    }
    
	public CompositeShowCaseSimpleLayout() {
	}
	

	private void quit() {
	    removeOptionCommands();
	    commandChangeLayout.dispose();
		commandGrow.dispose();
		commandShrink.dispose();

		//enable CompositeShowCase's exit
		CompositeShowCase.getInstance().enableExit(true);
    
	    dispose();
	    
	}


    public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandExit) {
			quit();
		} else if (e.widget==commandChangeLayout) {
		    changeLayout();
		} else if (e.widget==commandOrientation) {
		    switchOrientation();
		} else if (e.widget==commandGrow) {
			grow();
		} else if (e.widget==commandShrink) {
			shrink();
		} else if (e.widget == commandNumColumns) {
			indexNumColumns ++;
			setNumColumns(indexNumColumns);
		} else if (e.widget == commandMakeColumnsEqualWidth) {
			isColumnsEqualWidth = !isColumnsEqualWidth;
			setColumnsEqualWidth(isColumnsEqualWidth);
		}
		// Command group HorzontalAlignment.
		else if (e.widget == commandFILL) {
			setHorizontalAlignementAnimal(GridData.FILL);
		} else if (e.widget == commandCENTER) {
			setHorizontalAlignementAnimal(GridData.CENTER);
		} else if (e.widget == commandEND) {
			setHorizontalAlignementAnimal(GridData.END);
		} else if (e.widget == commandBEGINNING) {
			setHorizontalAlignementAnimal(GridData.BEGINNING );
		}
		// Command group Span.
		else if (e.widget == commandHSpanAnimal) {
			indexHSpanAnimal++;
			setHSpanAnimal(indexHSpanAnimal);
		} else if (e.widget == commandHSpanElement) {
			indexHSpanElement ++;
			setHSpanElement(indexHSpanElement);
		} else if (e.widget == commandVSpanFruit) {
			indexVSpanFruit ++;
			setVSpanFruit(indexVSpanFruit);
		}
		// GrabEx excess
		else if (e.widget == commandGrabExcessH) {
			setGrabExcessH(!isGrabExcessH);
		} else if (e.widget == commandGrabExcessV) {
			setGrabExcessV(!isGrabExcessV);
		}
    }
    
    private void setGrabExcessV(boolean isGrabExcessVActive) {
    	if (currentLayout == GRIDLAYOUT) {
    		isGrabExcessV = isGrabExcessVActive;

    		GridData gridData = (GridData) ((List)lists[2]).getLayoutData();
    		
    		gridData.grabExcessVerticalSpace = isGrabExcessV;
    		
    		((List)lists[2]).setLayoutData(gridData);
    		commandGrabExcessV.setText(namesGrabExcessV[isGrabExcessV == false ? 0 : 1]);

       		composite.layout();
       		getComposite().redraw();
    	}  
    }

    private void setGrabExcessH(boolean isGrabExcessHActive) {
    	if (currentLayout == GRIDLAYOUT) {
    		isGrabExcessH = isGrabExcessHActive;

    		GridData gridData = (GridData) ((List)lists[2]).getLayoutData();
    		
    		gridData.grabExcessHorizontalSpace = isGrabExcessH;
    		
    		((List)lists[2]).setLayoutData(gridData);
    		commandGrabExcessH.setText(namesGrabExcessH[isGrabExcessH == false ? 0 : 1]);

       		composite.layout();
       		getComposite().redraw();
    	}  
    }
    
    private void setHSpanAnimal(int indexOfHSpanAnimal) {
    	if (currentLayout == GRIDLAYOUT) {
    		indexHSpanAnimal  = indexOfHSpanAnimal;
    		indexHSpanAnimal = (indexHSpanAnimal) % allSpanValues.length ;

    		GridData gridData = (GridData) ((List)lists[4]).getLayoutData();
    		
    		gridData.horizontalSpan = allSpanValues[indexHSpanAnimal];
    		
    		((List)lists[4]).setLayoutData(gridData);
    		commandHSpanAnimal.setText(namesCommandHSpanAnimal[(indexHSpanAnimal + 1) % namesCommandHSpanAnimal.length]);

       		composite.layout();
       		getComposite().redraw();
    	}  
    }
    
    private void setHSpanElement(int indexOfHSpanElement) {	
    	if (currentLayout == GRIDLAYOUT) {
    		indexHSpanElement  = indexOfHSpanElement;
    		indexHSpanElement = (indexHSpanElement) % allSpanValues.length ;

    		GridData gridData = (GridData) ((List)lists[4]).getLayoutData();
    		
    		gridData.horizontalSpan = allSpanValues[indexHSpanElement];
    		
    		((List)lists[1]).setLayoutData(gridData);
    		commandHSpanElement.setText(namesCommandHSpanElement[(indexHSpanElement + 1) % namesCommandHSpanElement.length]);

       		composite.layout();
       		getComposite().redraw();
    	}  
    }
    
    private void setVSpanFruit(int indexOfVSpanFruit) {
    	if (currentLayout == GRIDLAYOUT) {
    		indexVSpanFruit = indexOfVSpanFruit;
    		indexVSpanFruit = (indexVSpanFruit) % allSpanValues.length ;

    		GridData gridData = (GridData) ((List)lists[4]).getLayoutData();
    		
    		gridData.verticalSpan= allSpanValues[indexVSpanFruit];
    		
    		((List)lists[2]).setLayoutData(gridData);
    		commandVSpanFruit.setText(namesCommandVSpanFruit[(indexVSpanFruit + 1) % namesCommandVSpanFruit.length]);

       		composite.layout();
       		getComposite().redraw();
    	}  
    }
    
    private void setHorizontalAlignementAnimal(int alignment) {
    	if (currentLayout == GRIDLAYOUT) {
    		GridData gridData = (GridData) ((List)lists[4]).getLayoutData();
    		gridData.horizontalAlignment = alignment;
    		
    		//Eric. fix SPR #JYJC6XXBHQ and JYJC7MP4PF to align the rest of element correctly 
    		for(int i =0; i<lists.length; i++)
    		 ((List)lists[i]).setLayoutData(gridData);
    		
    		composite.layout();
       		getComposite().redraw();
    	}  
    }

	private void grow() {
	    if (sizeoption== SIZE_BIG) {
	        return;
	    }
	    sizeoption++;
	    commandShrink.setEnabled(true);
	    changeCompositeSize();
	}
	
	private void shrink() {
	    if (sizeoption==SIZE_SMALL) {
	        return;
	    }
	    sizeoption--;
	    commandGrow.setEnabled(true);
	    changeCompositeSize();
	}

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
	
    private void changeLayout() {
        currentLayout = (currentLayout+1)%3;

        commandChangeLayout.setText(layoutTexts[(currentLayout+1)%3]);

        // This uncommon to change the type of layout. 
        // That case requires to set layoutdata of all children 
        // manually to null before switching 
        Control [] children  = composite.getChildren();
        for (int i=0;i<children.length;i++) {
            children[i].setLayoutData(null);
        }
        composite.setLayoutData(null);
        
        if (currentLayout == FILLLAYOUT) {
            composite.setLayout(new FillLayout(SWT.HORIZONTAL));
        } else if (currentLayout == ROWLAYOUT) {
            RowLayout newlayout = new RowLayout(SWT.HORIZONTAL);
            newlayout.wrap = true;
            newlayout.justify = false;
            composite.setLayout(newlayout);
        } else if (currentLayout == GRIDLAYOUT) {
        	GridLayout newLayout = new GridLayout();
        	newLayout.makeColumnsEqualWidth = isColumnsEqualWidth;
        	newLayout.numColumns = allNumColumns[indexNumColumns];
            composite.setLayout(newLayout);
        }

        setOptionCommands();
        getComposite().getShell().setText(layoutTexts[currentLayout]);
        getComposite().layout();
         
        // To apply the Layout, we change the size.
        composite.setSize(0, 0);
        changeCompositeSize();        
    }
    
    private void removeOptionCommands() {
    	// Remove the orientation command.
		if (commandOrientation!= null) {
		    commandOrientation.dispose();
		    commandOrientation = null;
		    getComposite().redraw();
		}
    	// Remove the numbers of columns command.
		if (commandNumColumns!=null) {
			commandNumColumns.dispose();
			commandNumColumns = null;
			getComposite().redraw();
		}
    	// Remove the MakeColumnsEqualWidth command.
		if (commandMakeColumnsEqualWidth != null) {
			commandMakeColumnsEqualWidth.dispose();
			commandMakeColumnsEqualWidth = null;
			getComposite().redraw();
		}
    	// Remove the HorizontalAlignment command group.
		if (commandGroupAnimalHorizontalAlignment != null) {
			commandGroupAnimalHorizontalAlignment.dispose();
			commandGroupAnimalHorizontalAlignment = null;
			getComposite().redraw();
		}
    	// Remove the CENTER command.
		if (commandCENTER != null) {
			commandCENTER.dispose();
			commandCENTER = null;
			getComposite().redraw();
		}
    	// Remove the BEGINNING command.
		if (commandBEGINNING != null) {
			commandBEGINNING.dispose();
			commandBEGINNING = null;
			getComposite().redraw();
		}
    	// Remove the FILL command.
		if (commandFILL != null) {
			commandFILL.dispose();
			commandFILL = null;
			getComposite().redraw();
		}
    	// Remove the END command.
		if (commandEND != null) {
			commandEND.dispose();
			commandEND = null;
			getComposite().redraw();
		}
		// Remove commandHSpanAnimal.
		if (commandGroupSpan != null) {
			commandGroupSpan.dispose();
			commandGroupSpan = null;
			getComposite().redraw();
		}
		// Remove commandHSpanAnimal.
		if (commandHSpanAnimal != null) {
			commandHSpanAnimal.dispose();
			commandHSpanAnimal = null;
			getComposite().redraw();
		}
		// Remove commandHSpanElement.
		if (commandHSpanElement != null) {
			commandHSpanElement.dispose();
			commandHSpanElement = null;
			getComposite().redraw();
		}
		// Remove commandVSpanFruit.
		if (commandVSpanFruit != null) {
			commandVSpanFruit.dispose();
			commandVSpanFruit = null;
			getComposite().redraw();
		}
		// Remove commandGrabExcessH.
		if (commandGrabExcessH != null) {
			commandGrabExcessH.dispose();
			commandGrabExcessH = null;
			getComposite().redraw();
		}
		//Remove commandGrabExcessV.
		if (commandGrabExcessV != null) {
			commandGrabExcessV.dispose();
			commandGrabExcessV = null;
			getComposite().redraw();
		}
    	
    }
    
    private void setOptionCommands() {
    	removeOptionCommands();

		// set command depending on the layout
		orientationoption = OPTIONHORIZONTAL;
		if ((currentLayout == FILLLAYOUT) || (currentLayout == ROWLAYOUT)) {
		    commandOrientation = new Command(getComposite(),Command.GENERAL,10);
		    commandOrientation.setText(orentationTexts[((orientationoption+1)%2)]);
		    commandOrientation.addSelectionListener(this);
		}

		if ( (currentLayout == GRIDLAYOUT)) { 
			commandNumColumns = new Command(getComposite(),Command.GENERAL,9);
			commandNumColumns.addSelectionListener(this);
			setNumColumns(indexNumColumns);

			commandMakeColumnsEqualWidth = new Command(getComposite(),Command.GENERAL,8);
			commandMakeColumnsEqualWidth.addSelectionListener(this);
			setColumnsEqualWidth(isColumnsEqualWidth);
			
			// The command group for the horizontal alignment of the Animal List.
			commandGroupAnimalHorizontalAlignment = new Command(getComposite(),Command.COMMANDGROUP,2);
			commandGroupAnimalHorizontalAlignment.setText(nameCommandGroupHorizAligVal);
			commandGroupAnimalHorizontalAlignment.addSelectionListener(this);
			// The commands of the command group.
			commandBEGINNING = new Command(commandGroupAnimalHorizontalAlignment,Command.GENERAL,0);
			commandBEGINNING.setText(Messages.getString("CompositeShowCaseSimpleLayout.49")); //$NON-NLS-1$
			commandBEGINNING.addSelectionListener(this);
			commandEND = new Command(commandGroupAnimalHorizontalAlignment,Command.GENERAL,0);
			commandEND.setText(Messages.getString("CompositeShowCaseSimpleLayout.50")); //$NON-NLS-1$
			commandEND.addSelectionListener(this);
			commandFILL = new Command(commandGroupAnimalHorizontalAlignment,Command.GENERAL,0);
			commandFILL.setText(Messages.getString("CompositeShowCaseSimpleLayout.51")); //$NON-NLS-1$
			commandFILL.addSelectionListener(this);
			commandCENTER = new Command(commandGroupAnimalHorizontalAlignment,Command.GENERAL,0);
			commandCENTER.setText(Messages.getString("CompositeShowCaseSimpleLayout.52")); //$NON-NLS-1$
			commandCENTER.addSelectionListener(this);
			
			// The command group for the Span
			commandGroupSpan = new Command(getComposite(),Command.COMMANDGROUP,2);
			commandGroupSpan.setText(nameCommandGroupSpan);
			commandGroupSpan.addSelectionListener(this);
			// The commands of the command group.
			commandHSpanAnimal = new Command(commandGroupSpan,Command.GENERAL,0);
			commandHSpanAnimal.addSelectionListener(this);
			setHSpanAnimal(indexHSpanAnimal);
			
			commandHSpanElement = new Command(commandGroupSpan,Command.GENERAL,0);
			commandHSpanElement.addSelectionListener(this);
			setHSpanElement(indexHSpanElement);
			
			commandVSpanFruit = new Command(commandGroupSpan,Command.GENERAL,0);
			commandVSpanFruit.addSelectionListener(this);
			setVSpanFruit(indexVSpanFruit);

			// Command grid Excess Horizontal
			commandGrabExcessH = new Command(getComposite(),Command.GENERAL,0);
			commandGrabExcessH.addSelectionListener(this);
			setGrabExcessH(isGrabExcessH);
			
			// Command grid Excess Vertical
			commandGrabExcessV = new Command(getComposite(),Command.GENERAL,0);
			commandGrabExcessV.addSelectionListener(this);
			setGrabExcessV(isGrabExcessV);
		}
    }
    
    private void switchOrientation() {
        orientationoption = (orientationoption+1)%2; 
        commandOrientation.setText(orentationTexts[((orientationoption+1)%2)]);
        int type = ((orientationoption==OPTIONHORIZONTAL)? SWT.HORIZONTAL: SWT.VERTICAL);
   		if (currentLayout == FILLLAYOUT) {
    		    FillLayout layout = (FillLayout) composite.getLayout();
    		    layout.type = type;
   		} else if (currentLayout == ROWLAYOUT) {
   		    	RowLayout layout = (RowLayout) composite.getLayout();
    		    layout.type = type;
        }
   		composite.layout();
   		getComposite().redraw();
    }
    
    private void setNumColumns(int indexOfNumColumns) {
    	if (currentLayout == GRIDLAYOUT) {
    		indexNumColumns = indexOfNumColumns;
    		indexNumColumns = (indexNumColumns)%allNumColumns.length;

		    GridLayout layout = (GridLayout) composite.getLayout();
    		layout.numColumns = allNumColumns[indexNumColumns];

			commandNumColumns.setText(allNamesNumColumns[(indexNumColumns+1)%allNumColumns.length]);

       		composite.layout();
       		getComposite().redraw();
    	}
    }
    
    private void setColumnsEqualWidth(boolean activeColumnsEqualWidth) {
    	if (currentLayout == GRIDLAYOUT) {
    		isColumnsEqualWidth = activeColumnsEqualWidth;
    		
		    GridLayout layout = (GridLayout) composite.getLayout();
		    layout.makeColumnsEqualWidth = isColumnsEqualWidth;

			commandMakeColumnsEqualWidth.setText(namesMakeColumnsEqualWidth[isColumnsEqualWidth==false? 0 : 1]);

       		composite.layout();
       		getComposite().redraw();
    	}
    }
    
    private void changeCompositeSize() {
       if (sizeoption==SIZE_BIG) {
           composite.setSize(getComposite().getClientArea().width,getComposite().getClientArea().height);
           commandGrow.setEnabled(false);
       }
       else if (sizeoption==SIZE_MEDIUM) {
           composite.setSize(getComposite().getClientArea().width/2,getComposite().getClientArea().height);
       }
       else if (sizeoption==SIZE_SMALL) {
           composite.setSize(getComposite().getClientArea().width/2,getComposite().getClientArea().height/2);
           commandShrink.setEnabled(false);
       }
    }
    
}
