/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

//import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Browser.BrowserShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.CaptionedControl.CaptionedControlShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Command.CommandShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Composite.CompositeShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Graphics.GraphicsShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Label.LabelShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.ListBox.ListBoxShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Menu.MenuShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.MessageBox.MessageBoxShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.MobileShell.MobileShellShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.MultiPageDialog.MultiPageDialogShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Table.TableShowCase;
import org.eclipse.ercp.swt.samples.eswtdemo.Tree.TreeShowCase;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.browser.Browser;


public class Demo {

	final private String configurationFilePath = "c:\\";  //$NON-NLS-1$
	final private String configurationFileName = "eSwtDemo";   //$NON-NLS-1$
	final private String configurationFileExtension = "txt";  //$NON-NLS-1$
	
	private Shell   shell;
	public static boolean bWorkbenchMode = false;
	private MainMenu mainMenu;
	
	
	/**
	 * main
	 * @param args
	 */
	public static void main(String[] args) {
		Demo demo = new Demo();
		demo.RCPMode();
	}
	
	/**
	 * Constructor
	 *
	 */
	protected Demo() {
	}
	
	private void RCPMode() {
		Display display = new Display();
		shell = new Shell(display, SWT.SHELL_TRIM | SWT.BORDER);
		shell.setText(Messages.getString("Demo.3")); //$NON-NLS-1$
				
		Vector showCases = loadShowCases();
		new MainMenu(shell, showCases);
		
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		display.dispose();
	}
	
	protected void workbenchMode(Composite parent) {
		bWorkbenchMode = true;
		Vector showCases = loadShowCases();
		mainMenu = new MainMenu(parent, showCases);
	}
	
	public void setFocus() {
		if(mainMenu != null) {
			mainMenu.setFocus();
		}
	}
	
	/**
	 * Load the ShowCases and add it to the list
	 * 
	 * @return list of the ShowCases
	 */
	private Vector loadShowCases() {
		Vector showCases = new Vector();
		Vector showCasesLoad = null;

	    //add browser showcase if browser available
		// changed to avoid a memory leak
		Shell tempShell = null;
		Browser tempBrowser = null;
		try {
        	tempShell = new Shell(Display.getCurrent(), SWT.NONE);
        	tempBrowser = new Browser(tempShell, SWT.NONE);
        	showCases.add(new BrowserShowCase());
        } catch (SWTError e) {
            // platform does not support Browser
        } finally {
            if (tempBrowser!=null)
                tempBrowser.dispose();
            if (tempShell!=null)
                tempShell.dispose();
        }
        
		showCases.add(new CalendarShowCase());
		showCases.add(new CaptionedControlShowCase());
		showCases.add(new CommandShowCase());		
		showCases.add(new CompositeShowCase());
		showCases.add(new GraphicsShowCase());
		showCases.add(new LabelShowCase());
		showCases.add(new ListBoxShowCase());
		showCases.add(new MenuShowCase());
		showCases.add(new MessageBoxShowCase());
		showCases.add(new MobileShellShowCase());
		showCases.add(new MultiPageDialogShowCase());		
		showCases.add(new PhoneBookShowCase());
        showCases.add(new TableShowCase());
        showCases.add(new TreeShowCase());
        		
		Vector lines = getLinesOfConfigFile();
		if (lines != null) {
			for (int i = 0; i < lines.size(); i++) {
				String line = ((String) lines.get(i)).toLowerCase().trim();
				boolean isAdded = false;
				for (int j = 0; j < showCases.size() && isAdded == false; j++) {
					String showCase = ((ShowCase) showCases.get(j)).getName().toLowerCase().trim();

					if (showCase.equals(line)) {
						if (showCasesLoad == null) {
							showCasesLoad = new Vector();
						}
						showCasesLoad.add((ShowCase) showCases.get(j));
						isAdded = true;
					}
				}				
			}
		}
		 
		return showCasesLoad != null ? showCasesLoad : showCases;
	}

	private Vector getLinesOfConfigFile() {

	    FileInputStream fileInputStream = null;
	    DataInputStream inputStream = null;
		Vector lines = new Vector();
    	try {
        	fileInputStream = new FileInputStream(getFile());
        	inputStream = new DataInputStream(fileInputStream);

			int intReaded = inputStream.read();
			char charReaded = (char)intReaded;
        	while (intReaded != -1) {
        		StringBuffer line = new StringBuffer();
        		while (charReaded != '\r' && intReaded != -1) {
        			line = line.append(charReaded);
        			intReaded = inputStream.read();
        			charReaded = (char)intReaded;
        		}

        		if (charReaded != -1) {
        			lines.add(line.toString());
 
        			// Skip the '\n'
        			intReaded = inputStream.read();
        			charReaded = (char)intReaded;
        		}
    			intReaded = inputStream.read();
        		charReaded = (char)intReaded;
        	}
		
    	} catch (Exception e) {
			lines = null;
		}finally {
		    try {
		        if (inputStream != null)
		            inputStream.close();
		        if (fileInputStream != null) {
		            fileInputStream.close();
		        }
		    } catch (Throwable IOException){    
		    }
		}
    	
		return lines;
	}
	
	private File getFile() {
		
    	File file = new File(configurationFilePath + configurationFileName + "." + configurationFileExtension);		 //$NON-NLS-1$
		
		return file;
	}
}
