/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Graphics;


import java.util.*;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;

/*
 *	This ShowCase show some graphics effects	
 * 
 */
public class GraphicsShowCase extends ShowCase implements PaintListener, KeyListener, SelectionListener {
    Canvas  canvas;
	Random  random;
	int     drawCase;
	int     counter;
	boolean eraseBgd;
	final int MAX_COUNTER = 1000;
	
	Command commandExit;
	Command commandNext;
    private FocusListener superShellListener = null;
	
	Color col1;
	Color col2;
	
	/**
	 * Constructor
	 * 
	 * @param parent the parent shell
	 */
	public GraphicsShowCase() {
		random = new Random();
		counter = 0;
	}
	
	/**
	 * name of the ShowCase
	 */
	public String getName() {
		return Messages.getString("GraphicsShowCase.0"); //$NON-NLS-1$
	}
	
	/**
	 * Launch the ShowCase
	 */
	public void show() {
	    // In this showcase, we have to create and use a shell instead of the composite because,
	    // if we draw in the composite, the screen is flickering because the Top Level Shell does not
	    // have the NO_BACKGROUND flag. We cannot set it, because it can cause problems in the other
	    // showcases. Consequently, we are using a child Shell with this flag enabled. 
	    canvas = new Canvas(getComposite(), SWT.NO_BACKGROUND);
	    Rectangle area = getComposite().getClientArea();
//	    Point tl = getComposite().toDisplay(area.x, area.y);
//    	canvas.setBounds(tl.x, tl.y, area.width, area.height);
	    canvas.setBounds(area);
	    canvas.addPaintListener(this);
	    canvas.addKeyListener(this);
	    
		drawCase = 0;
		eraseBgd = true;
		
		// create Commands			
		commandNext = new Command(canvas, Command.SELECT,3);
		commandNext.setText(Messages.getString("GraphicsShowCase.1")); //$NON-NLS-1$
		commandNext.addSelectionListener(this);
		commandNext.setDefaultCommand();

		commandExit = new Command(canvas, Command.EXIT,1);
		commandExit.setText(Messages.getString("GraphicsShowCase.2")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("GraphicsShowCase.3")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);
		
	    canvas.setFocus();
	    
		//Bring up this cavas image if existed while clicking eSWT Demo shortcut.
		superShellListener = new FocusListener() {
			public void focusGained(FocusEvent arg0) {
				if(canvas != null && !canvas.isDisposed()) {
					++drawCase;
					eraseBgd = true;
					canvas.redraw();
					canvas.forceFocus();
				}
			}

			public void focusLost(FocusEvent arg0) {
			}			
		};
		super.getComposite().getShell().addFocusListener(superShellListener);

	}
	
	/**
	 * Drawing operations
	 */
	public void paintControl(PaintEvent e) {
		if (eraseBgd) {
			e.gc.fillRectangle(canvas.getClientArea());
			eraseBgd = false;
		}
		
		switch (drawCase) {
			case 0:
			    counter = 0;
				drawImage(e, "/res/gif.gif"); //$NON-NLS-1$
				break;
			case 1:
				drawImage(e, "/res/jpeg.jpg"); //$NON-NLS-1$
				break;
			case 2:
				drawImage(e, "/res/png.png"); //$NON-NLS-1$
				break;
			case 3:
				if(counter < MAX_COUNTER) {
				    randomDraw(e);
				    canvas.redraw();
				    ++counter;
				} 
				break;

			default:
				quit();
				break;
		}
	}
	
	/**
	 * Press any key to go through the different screens
	 */
	public void keyPressed(KeyEvent e) {
	/** 
	 * Marked out temporarily due to the cause of duplicating 'canvas.redraw()' action when hitting 
	 * Enter/'1' keys for Command Selection Event.
	 * */
		// ++drawCase;
		// eraseBgd = true;
		// canvas.redraw();
	}
	
	public void keyReleased(KeyEvent e) {
		
	}
	
	/**
	 * display an image 
	 * 
	 * @param e	Paintevent
	 * @param name filename
	 */
	private void drawImage(PaintEvent e, String name) {
		Image img = new Image(canvas.getDisplay(), getClass().getResourceAsStream(name));
		Rectangle imageBnds  = img.getBounds();
		Rectangle canvasBnds = canvas.getBounds();
		int x = (canvasBnds.width  - imageBnds.width ) / 2;
		int y = (canvasBnds.height - imageBnds.height) / 2;
		GC gc = new GC(canvas, SWT.NONE);
		gc.fillRectangle(canvas.getClientArea());
		gc.drawImage(img, x, y);
		img.dispose();
	}
	
	/**
	 * Display a random shape on the screen, with random Color
	 * @param e
	 */
	private void randomDraw(PaintEvent e) {
		// Coordinates
		Rectangle area = canvas.getClientArea();
		int x1 = random.nextInt(area.width);
		int x2 = random.nextInt(area.width);
		int y1 = random.nextInt(area.height);
		int y2 = random.nextInt(area.height);
		int w  = x2-x1;
		int h  = y2-y1;

		// Drawing mode
		e.gc.setXORMode(random.nextBoolean());
		
		// Filled shapes or outlines?
		boolean fill = random.nextBoolean(); 
		
		// Colour
		if (col1 != null) {
		    col1.dispose();
		}
		col1 = generateRandomColor();

		// Outlines
		if (!fill) {
			e.gc.setForeground(col1);
			e.gc.setLineStyle(random.nextInt(5) + 1);

			switch (random.nextInt(7)) {
				case 0:
					e.gc.drawLine(x1, y1, x2, y2);
					break;
				case 1:
					e.gc.drawRectangle(x1, y1, w, h);
					break;
				case 2:
					e.gc.drawOval(x1, y1, w, h);
					break;
				case 3: {
					int start = random.nextInt();
					int angle = random.nextInt(361); 
					e.gc.drawArc(x1, y1, w, h, start, angle);
				}
					break;
				case 4:
					e.gc.drawPolygon(generateRandomPoints());
					break;
				case 5:
					e.gc.drawPolyline(generateRandomPoints());
					break;
				case 6: {
					int w2 = Math.abs(w) / 2;
					int h2 = Math.abs(h) / 2;
					int aw = (w2!=0) ? random.nextInt(w2) : 0;
					int ah = (h2!=0) ? random.nextInt(h2) : 0;
					e.gc.drawRoundRectangle(x1, y1, w, h, aw, ah);
				}
					break;
			}
		// Filled shapes
		} else {
			e.gc.setBackground(col1);
			
			switch (random.nextInt(6)) {
				case 0:
					e.gc.fillRectangle(x1, y1, w, h);
					break;
				case 1:
					e.gc.fillOval(x1, y1, w, h);
					break;
				case 2: {
					int start = random.nextInt();
					int angle = random.nextInt(361); 
					e.gc.fillArc(x1, y1, w, h, start, angle);
					}
					break;
				case 3:
					e.gc.fillPolygon(generateRandomPoints());
					break;
				case 4: {
					int w2 = Math.abs(w) / 2;
					int h2 = Math.abs(h) / 2;
					int aw = (w2!=0) ? random.nextInt(w2) : 0;
					int ah = (h2!=0) ? random.nextInt(h2) : 0;
					e.gc.fillRoundRectangle(x1, y1, w, h, aw, ah);
				}
				case 5: {
				    if (col2 != null) {
				        col2.dispose();
				    }
					col2 = generateRandomColor();
					e.gc.setForeground(col2);
					e.gc.fillGradientRectangle(x1, y1, w, h, random.nextBoolean());
				}
			}
		}
	}
	
	/**
	 * Generate a random point list
	 * 
	 * @return a list of points
	 */
	private int[] generateRandomPoints() {
		Rectangle area = canvas.getClientArea();
		int count = random.nextInt(100) + 2;
		int[] points = new int[count*2];
		for (int i=0; i<count*2; i+=2) {
			points[i]   = random.nextInt(area.width);
			points[i+1] = random.nextInt(area.height);
		}
		return points;
	}
	
	/**
	 * Generate a random Color
	 * 
	 * @return the newly created Color
	 */
	private Color generateRandomColor() {
		int r2 = random.nextInt(256);
		int g2 = random.nextInt(256);
		int b2 = random.nextInt(256);
		return new Color(canvas.getDisplay(), r2, g2, b2);
	}
	
	/**
	 * Command handling
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandExit) {
		    counter = 0;
			quit();
		}
		else if (e.widget==commandNext) {
			++drawCase;
			eraseBgd = true;
			canvas.redraw();
		}
	}
	
	public void quit() {
	    if (col1 != null) {
	        col1.dispose();
	    }
	    if (col2 != null) {
	        col2.dispose();
	    }
	    
	    if(super.getComposite() != null && !super.getComposite().isDisposed())
		{
    		super.getComposite().getShell().removeFocusListener(superShellListener);
		}
	    
	    canvas.dispose();
	    dispose();
	}

	public void widgetDefaultSelected(SelectionEvent e) {
 	}
}
