/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Label;


import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;



public class LabelShowCase extends ShowCase implements SelectionListener, KeyListener {
	// the commands of the show case
	private Command commandExit;
	
	private LabelShowCaseAnimatedGif animatedGif1;
	private LabelShowCaseAnimatedGif animatedGif2;
	
	private Composite scroller;
	private Composite composite;
	
	private Image imagelabel1;
	private Image imagelabel2;
	
	private Image leftimage;
	private Image centeredimage;
	private Image rightimage;
	
	
	
	/**
	 * Constructor
	 * @param parent
	 */
	public LabelShowCase() {
	}
	
	/**
	 * name of the showcase
	 */
	public String getName() {
		return Messages.getString("LabelShowCase.0"); //$NON-NLS-1$
	}
	
	/**
	 * Start the showcase
	 */
	public void show() {
	    scroller = new Composite(getComposite(), SWT.V_SCROLL);
	    scroller.setBounds(getComposite().getBounds());
		
		// the composite will scroll inside the shell
		composite = new Composite(scroller,SWT.NORMAL);
		composite.setLocation(0,0);
		composite.setSize(scroller.getClientArea().width, 800);	// height will be recomputed
		
		// we use a FormLayout
		FormLayout formlayout = new FormLayout();
		composite.setLayout(formlayout);
		
		// simple Labels
		Label simpleLabel = new Label(composite,SWT.NORMAL);
		simpleLabel.setText(Messages.getString("LabelShowCase.1")); //$NON-NLS-1$
		FormData simpleLabelFormdata = new FormData();
		simpleLabelFormdata.top = new FormAttachment(0,5);
		simpleLabelFormdata.left = new FormAttachment(0,5);
		simpleLabelFormdata.right = new FormAttachment(100,-5);
		simpleLabel.setLayoutData(simpleLabelFormdata);
		
		// too long label, should be truncated
		// we create a label that use 50% of the avaliable displayable screen width 
		Label toolonglabel = new Label(composite,SWT.NORMAL);
		toolonglabel.setText(Messages.getString("LabelShowCase.2")); //$NON-NLS-1$
		FormData toolonglabelFormData = new FormData();
		toolonglabelFormData.top = new FormAttachment(simpleLabel,5);
		toolonglabelFormData.left = new FormAttachment(0,5);
		toolonglabelFormData.right = new FormAttachment(50,-5);
		toolonglabel.setLayoutData(toolonglabelFormData);

		// wrapped label
		Label wrappedlabel = new Label(composite,SWT.WRAP);
		wrappedlabel.setText(Messages.getString("LabelShowCase.3")); //$NON-NLS-1$
		FormData wrappedlabelformdata = new FormData();
		wrappedlabelformdata.top = new FormAttachment(toolonglabel,5);
		wrappedlabelformdata.left = new FormAttachment(0,5);
		wrappedlabelformdata.right = new FormAttachment(100,-5);
		wrappedlabel.setLayoutData(wrappedlabelformdata);
		
		
		// Image label
		imagelabel1 = new Image(composite.getDisplay(), getClass().getResourceAsStream("/res/lb1heading.png")); //$NON-NLS-1$
		Label simpleimageLabel = new Label(composite,SWT.NORMAL | SWT.BORDER);
		simpleimageLabel.setImage(imagelabel1);
		FormData simpleImageLabelformdata = new FormData();
		simpleImageLabelformdata.top = new FormAttachment(wrappedlabel,5);
		simpleImageLabelformdata.left = new FormAttachment(0,5);
		simpleimageLabel.setLayoutData(simpleImageLabelformdata);
		
		
		// Cropped image label
		imagelabel2 = new Image(composite.getDisplay(), getClass().getResourceAsStream("/res/lb1heading.png")); //$NON-NLS-1$
		Label croppedimageLabel = new Label(composite,SWT.NORMAL | SWT.BORDER);
		croppedimageLabel.setImage(imagelabel2);
		FormData croppedimageLabelFormdata = new FormData();
		croppedimageLabelFormdata.top = new FormAttachment(simpleimageLabel,5);
		croppedimageLabelFormdata.left = new FormAttachment(0,5);
		croppedimageLabelFormdata.right = new FormAttachment(0,15);	// will crop the image
		// croppedimageLabelFormdata.bottom = new FormAttachment(simpleimageLabel,30);	// will crop the image
		croppedimageLabel.setLayoutData(croppedimageLabelFormdata);
		
		// animated gif
		animatedGif1 = new LabelShowCaseAnimatedGif(composite,"/res/animatedgif1.gif"); //$NON-NLS-1$
		FormData animatedgif1FormData = new FormData();
		animatedgif1FormData.top = new FormAttachment(croppedimageLabel,5);
		animatedgif1FormData.left = new FormAttachment(0,5);
		animatedGif1.getLabel().setLayoutData(animatedgif1FormData);
		
		// animated gif
		animatedGif2 = new LabelShowCaseAnimatedGif(composite,"/res/animatedgif2.gif"); //$NON-NLS-1$
		FormData animatedgif2FormData = new FormData();
		animatedgif2FormData.top = new FormAttachment(animatedGif1.getLabel(),5);
		animatedgif2FormData.left = new FormAttachment(0,5);
		animatedGif2.getLabel().setLayoutData(animatedgif2FormData);
		
		// separator
		Label separatorlabel = new Label(composite,SWT.SEPARATOR | SWT.HORIZONTAL);
		FormData separatorlabelFormData = new FormData();
		separatorlabelFormData.top = new FormAttachment(animatedGif2.getLabel(),5);
		separatorlabelFormData.left = new FormAttachment(0,5);
		separatorlabelFormData.right = new FormAttachment(100,-5);
		separatorlabel.setSize(SWT.DEFAULT,SWT.DEFAULT);
		separatorlabel.setLayoutData(separatorlabelFormData);
		
		// left Label
		Label leftLabel = new Label(composite,SWT.LEFT);
		leftLabel.setText(Messages.getString("LabelShowCase.8")); //$NON-NLS-1$
		FormData leftLabelFormdata = new FormData();
		leftLabelFormdata.top = new FormAttachment(separatorlabel,5);
		leftLabelFormdata.left = new FormAttachment(0,5);
		leftLabelFormdata.right = new FormAttachment(100,-5);
		leftLabel.setLayoutData(leftLabelFormdata);

		// centered Label
		Label centeredLabel = new Label(composite,SWT.CENTER);
		centeredLabel.setText(Messages.getString("LabelShowCase.9")); //$NON-NLS-1$
		FormData centeredLabelFormdata = new FormData();
		centeredLabelFormdata.top = new FormAttachment(leftLabel,5);
		centeredLabelFormdata.left = new FormAttachment(0,5);
		centeredLabelFormdata.right = new FormAttachment(100,-5);
		centeredLabel.setLayoutData(centeredLabelFormdata);

		// right Label
		Label rightLabel = new Label(composite,SWT.RIGHT);
		rightLabel.setText(Messages.getString("LabelShowCase.10")); //$NON-NLS-1$
		FormData rightLabelFormdata = new FormData();
		rightLabelFormdata.top = new FormAttachment(centeredLabel,5);
		rightLabelFormdata.left = new FormAttachment(0,5);
		rightLabelFormdata.right = new FormAttachment(100,-5);
		rightLabel.setLayoutData(rightLabelFormdata);
		
		// left-aligned Image label
		leftimage = new Image(composite.getDisplay(), getClass().getResourceAsStream("/res/lb1heading.png")); //$NON-NLS-1$
		Label leftimageLabel = new Label(composite,SWT.LEFT);
		leftimageLabel.setText(Messages.getString("LabelShowCase.12")); //$NON-NLS-1$
		leftimageLabel.setImage(leftimage);
		FormData leftImageLabelformdata = new FormData();
		leftImageLabelformdata.top = new FormAttachment(rightLabel,5);
		leftImageLabelformdata.left = new FormAttachment(0,5);
		leftImageLabelformdata.right = new FormAttachment(100,-5);
		leftimageLabel.setLayoutData(leftImageLabelformdata);

		// centered-aligned Image label
		centeredimage = new Image(composite.getDisplay(), getClass().getResourceAsStream("/res/lb1heading.png")); //$NON-NLS-1$
		Label centeredimageLabel = new Label(composite,SWT.CENTER);
		centeredimageLabel.setImage(centeredimage);
		FormData centerImageLabelformdata = new FormData();
		centerImageLabelformdata.top = new FormAttachment(leftimageLabel,5);
		centerImageLabelformdata.left = new FormAttachment(0,5);
		centerImageLabelformdata.right = new FormAttachment(100,-5);
		centeredimageLabel.setLayoutData(centerImageLabelformdata);

		// right-aligned Image label
		rightimage = new Image(composite.getDisplay(), getClass().getResourceAsStream("/res/lb1heading.png")); //$NON-NLS-1$
		Label rightimageLabel = new Label(composite,SWT.RIGHT);
		rightimageLabel.setImage(rightimage);
		FormData rightImageLabelformdata = new FormData();
		rightImageLabelformdata.top = new FormAttachment(centeredimageLabel,5);
		rightImageLabelformdata.left = new FormAttachment(0,5);
		rightImageLabelformdata.right = new FormAttachment(100,-5);
		rightimageLabel.setLayoutData(rightImageLabelformdata);

		// create Exit command
		commandExit = new Command(getComposite().getShell(), Command.EXIT, 1);
		commandExit.setText(Messages.getString("LabelShowCase.15")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("LabelShowCase.16")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);
		
		// Resize the composite
		Point newsize = composite.computeSize(scroller.getClientArea().width,SWT.DEFAULT);
		composite.setSize(newsize);
		
		// set the scrollbar
		ScrollBar scrollbar = scroller.getVerticalBar();
		scrollbar.setMaximum(composite.getSize().y);
		scrollbar.setMinimum(0);
		scrollbar.setThumb(scroller.getClientArea().height);
		scrollbar.setPageIncrement(scroller.getClientArea().height);
		scrollbar.setIncrement(scroller.getClientArea().height/10);
		
		
		Listener scrollListener  = new Listener() {
		    public void handleEvent(Event event) {
		        redraw();
		    }
		};
		
		scrollbar.addListener(SWT.Selection, scrollListener);
		
		//fix bug SCLL7D59WM
//		getComposite().getShell().addKeyListener(this);
		composite.addKeyListener(this);
		

		// launch the animation of the animated labels
		animatedGif1.run();
		animatedGif2.run();
		//fix bug SCLL7D59WM
		composite.setFocus();
		
	}
	
	
	/**
	 * Quit show case, dispose objects
	 *
	 */
	private void quit() {
		animatedGif1.stop();
		animatedGif2.stop();
		commandExit.dispose();	
		scroller.dispose();
		dispose();
		
		imagelabel1.dispose();
		imagelabel2.dispose();
		leftimage.dispose();
		centeredimage.dispose();
		rightimage.dispose();
	}
	
	/**
	 * Command handling
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandExit) {
			quit();
		}
	}

	public void widgetDefaultSelected(SelectionEvent e) {
	    
 	}

	/**
	 * Handle key events and scrollbars
	 */
    public void keyPressed(KeyEvent e) {
        ScrollBar scrollbar = scroller.getVerticalBar();
        int selection = scrollbar.getSelection();
        int increment = scrollbar.getIncrement();
        int pageincrement = scrollbar.getPageIncrement();
		if (e.keyCode==SWT.ARROW_UP) {
		    scrollbar.setSelection(selection-increment);
		    redraw();
		} 
		else if (e.keyCode==SWT.ARROW_DOWN) {
		    scrollbar.setSelection(selection+increment);
		    redraw();
		} 
		else if (e.keyCode==SWT.PAGE_UP) {
		    scrollbar.setSelection(selection-pageincrement);
		    redraw();
		} 
		else if (e.keyCode==SWT.PAGE_DOWN) {
		    scrollbar.setSelection(selection+pageincrement);
		    redraw();
		} 
    }


    public void keyReleased(KeyEvent e) {
        
    }
    
    
    /**
     * redraw teh composite using scrollbar's selection
     *
     */
    private void redraw() {
        ScrollBar scrollbar = scroller.getVerticalBar();
        Point location = new Point(0,-scrollbar.getSelection());
        composite.setLocation(location);
    }

		
}
