/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Label;


import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;

/**
 * handle the animation inside the label, using an animated gif file
 */
public class LabelShowCaseAnimatedGif {
    
    final ImageLoader loader = new ImageLoader();
    final Display display;

    private Runnable runnable;
    
    private Label label;
    
    private Image frameImage; 
    
    int imageNumber = 0;
    
    /**
     * Constuctor
     * 
     * @param parent
     * @param filename the gif file name
     */
    public LabelShowCaseAnimatedGif(Composite parent, String filename) {
        label = new Label(parent, SWT.NORMAL);   
        loader.load(getClass().getResourceAsStream(filename));
        frameImage = new Image(parent.getDisplay(),loader.data[0]);
        label.setImage(frameImage);
        label.setSize(frameImage.getBounds().width,frameImage.getBounds().height);
        display = parent.getDisplay();
        
        if (loader.data.length <= 1) return;
        
        runnable = new Runnable() {
            public void run() {
                	if (runnable != null) {
                		Image oldImage;
                		if (!label.isDisposed())
                			{
                				oldImage = label.getImage();
                		} else {
                			return;
                		}
	                    // Increase the variable holding the frame
	                    // number
	                    imageNumber = (imageNumber == loader.data.length - 1) ? 0
	                            : imageNumber + 1;
	                    
	                    // Draw the new data onto the image
	                    ImageData nextFrameData = loader.data[imageNumber];
	                    frameImage = new Image(display,
	                            nextFrameData);
	                    // set the image to the label
	                    // Note: all gif file will not work,
	                    // the gif should not contain any position information
	                    // (all frames must be 0,0 located)
	                    // since it's not possible to set image location
	                    // inside the label
	                    label.setImage(frameImage);
	                    //label.redraw();
	                    oldImage.dispose();

	                	if (runnable != null) {
		                    int delayTime = loader.data[imageNumber].delayTime;
		                    display.timerExec(delayTime*10 ,this);
	                	} else {
	                		frameImage.dispose();
	                	}
                	} else {
                		frameImage.dispose();
                	}
            }
        };
    }
    
    Label getLabel() {
        return label;
    }
    
    public void run() {
        int delayTime = loader.data[imageNumber].delayTime;
        if (runnable != null)
            display.timerExec(delayTime*10 ,runnable);
    }
   
    public void stop() {
    	runnable = null;
    	label.dispose();
    }
    
}
