/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.ListBox;

import org.eclipse.swt.*;
import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;


/*
 *	This ShowCase show ListBoxes displayed with differrent styles	
 * 
 */
public class ListBoxShowCase extends ShowCase implements SelectionListener {
	// the commands of the show case
	Command commandChangeLayout = null;
	Command commandExit = null;
	
	ListBox listbox = null;
	ListBoxItem[] listboxitems = null;
	
	Image lb1details = null;
	Image lb1heading = null;
	Image lb2details = null;
	Image lb2heading = null;
	Image lb3details = null;
	Image lb3heading = null;
	
	int[] 	modes ={
			ListBox.LB_STYLE_2LINE_ITEM | ListBox.LB_MOD_SHOW_HEADING_ICONS | ListBox.LB_MOD_SHOW_DETAIL_ICONS,
			ListBox.LB_STYLE_1LINE_ITEM | ListBox.LB_MOD_SHOW_HEADING_ICONS | ListBox.LB_MOD_SHOW_DETAIL_ICONS,
			ListBox.LB_STYLE_1LINE_ITEM | ListBox.LB_MOD_SHOW_HEADING_ICONS | ListBox.LB_MOD_SHOW_DETAIL_ICONS | ListBox.LB_MOD_SHOW_SELECTION_NUMBER,
			ListBox.LB_STYLE_1LINE_ITEM | ListBox.LB_MOD_SHOW_DETAIL_ICONS | ListBox.LB_MOD_SHOW_SELECTION_NUMBER,
			ListBox.LB_STYLE_NO_HEADING_TEXT|ListBox.LB_MOD_SHOW_DETAIL_ICONS,
			ListBox.LB_STYLE_NO_HEADING_TEXT
			};

	int activemode = 0;
	
	public ListBoxShowCase() {
	}
	
	/**
	 * name of the showcase
	 */
	public String getName() {
		return Messages.getString("ListBoxShowCase.0"); //$NON-NLS-1$
	}
	
	/**
	 * Start the showcase
	 */
	public void show() {
		createListBoxItems();

		//fix bug BMHL7PSEU5
        getComposite().setLayout(new FillLayout());

		createListbox(modes[activemode]);
		getComposite().layout();
		
		commandChangeLayout = new Command(getComposite(), Command.GENERAL, 3);
		commandChangeLayout.setText(Messages.getString("ListBoxShowCase.1")); //$NON-NLS-1$
		commandChangeLayout.addSelectionListener(this);

		commandExit = new Command(getComposite(), Command.EXIT, 0);
		commandExit.setText(Messages.getString("ListBoxShowCase.2")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("ListBoxShowCase.3")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);
		
		getComposite().setFocus();
	}
	

	
	
	/**
	 * Quit show case, dispose objects
	 *
	 */
	private void quit() {
		commandChangeLayout.dispose();
		commandExit.dispose();	
		dispose();
		lb1details.dispose();
		lb1heading.dispose();
		lb2details.dispose();
		lb2heading.dispose();
		lb3details.dispose();
		lb3heading.dispose();
		
		if(listboxitems!=null){
			for(int i=0;i<listboxitems.length;i++){
    			if(listboxitems[i]!=null){
    				listboxitems[i]=null;
    			}
    		}
			listboxitems = null;
		}
		
		if(listbox!=null) {
			if(!listbox.isDisposed()){
				listbox.dispose();
			}
			listbox = null;
		}
	}

	/**
	 * Create the listItems and add it to the listbox
	 * 
	 * @param listbox
	 */
	private void createListBoxItems() {

		listboxitems = new ListBoxItem[3];
		
		// Get images
		lb1details = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/lb1details.png")); //$NON-NLS-1$
		lb1heading = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/lb1heading.png")); //$NON-NLS-1$
		lb2details = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/lb2details.png")); //$NON-NLS-1$
		lb2heading = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/lb2heading.png")); //$NON-NLS-1$
		lb3details = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/lb3details.png")); //$NON-NLS-1$
		lb3heading = new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/lb3heading.png")); //$NON-NLS-1$

		// create the ListboxItems
		listboxitems[0] = new ListBoxItem(Messages.getString("ListBoxShowCase.10"),lb1details,Messages.getString("ListBoxShowCase.11"),lb1heading); //$NON-NLS-1$ //$NON-NLS-2$
		listboxitems[1] = new ListBoxItem(Messages.getString("ListBoxShowCase.12"),lb2details,Messages.getString("ListBoxShowCase.13"),lb2heading); //$NON-NLS-1$ //$NON-NLS-2$
		listboxitems[2] = new ListBoxItem(Messages.getString("ListBoxShowCase.14"),lb3details,Messages.getString("ListBoxShowCase.15"),lb3heading); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	/**
	 * create the lListBox giving the style
	 * 
	 * @param style
	 */
	private void createListbox(int style) {
		// dispose the old Listbox
		if(listbox!=null) {
			if(!listbox.isDisposed()){
				listbox.dispose();
			}
			listbox = null;
		}
		// create a new Listbox
		listbox = new ListBox(getComposite(), SWT.SINGLE, style );
		// add the ListBoxItems to the ListBox
		listbox.setDataModel(listboxitems);
		listbox.forceFocus();
	}
	
	/**
	 * Command handling
	 */
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandChangeLayout) {
			// go to next listboxMode
			activemode++;
			if (activemode==modes.length) {
				activemode=0;
			}
			// recreate the ListBox
			createListbox(modes[activemode]);
			
			getComposite().layout();
		}
		else if (e.widget==commandExit) {
			quit();
		}
	}

	public void widgetDefaultSelected(SelectionEvent e) {
 	}
	
}
