/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo;

import java.util.Vector;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ercp.swt.mobile.*;


/**
 * 
 * This is the main menu screen of the demo application.
 * The user can either choose to launch one ShowCase from the 
 * list or quit the application
 * 
 */
public class MainMenu implements SelectionListener, DisposeListener, ControlListener {
	
	private ListView  list;
	private Vector    showCases;
	private Composite parent;
	private boolean hasDirectSelect;

    private Composite	background; // the background composite

	Command commandExit;
	Command commandLaunch;
	ShowCase showcase;
	String originalShellString;
	/**
	 * Constructor
	 * 
	 * @param parent the parent shell
	 * @param showCases list of ShowCases
	 */
	public MainMenu(Composite parent, Vector showCases) {
		// If parent's fill layout is allow to remain, then
		// children will get repositioned on a window resize
		parent.setLayout(null);
		originalShellString = parent.getShell().getText();
		MobileDevice md = MobileDevice.getMobileDevice();
		Screen[] screens =md.getScreens();
		hasDirectSelect = screens[0].isTouchScreen();
			
		
		int orient = (parent.getSize().x > parent.getSize().y) ? SWT.HORIZONTAL : SWT.VERTICAL;
		list = new ListView(parent, SWT.SINGLE | orient);
		list.setSize(parent.getSize());
		parent.addControlListener(this);
		
		this.parent = parent;
		
		this.showCases = showCases;
		for (int i=0; i<showCases.size(); ++i) {
			ShowCase showCase = (ShowCase)showCases.get(i);
			list.add(showCase.getName(), null);
		}
		
		// Add Launch command 
		commandLaunch = new Command(list,Command.SELECT,3);
		commandLaunch.setText(Messages.getString("MainMenu.0")); //$NON-NLS-1$
		commandLaunch.addSelectionListener(this);
		//mark the following line as the workaround of 264328
		//commandLaunch.setDefaultCommand();
		
		// if not a workbench app, add global Exit command 
		if (!Demo.bWorkbenchMode && parent != parent.getShell()) {
		    commandExit = new Command(list,Command.EXIT,2);
		    commandExit.setText(Messages.getString("MainMenu.1")); //$NON-NLS-1$
		    commandExit.setLongLabel(Messages.getString("MainMenu.2")); //$NON-NLS-1$
		    commandExit.addSelectionListener(this);
		}
		
		list.addSelectionListener(this);
	}
	
	
	/**
	 * Quit show case, dispose objects
	 *
	 */
	private void quit() {
		// dipose the commands 
		commandExit.dispose();	
		commandLaunch.dispose();
		parent.dispose();
	}
	
	/**
	 * Launches the Showcase
	 */
	private void launch() {
	    if (list.getSelectionCount() > 0) {
			background = new MyBackground(parent);
			background.addDisposeListener(this);
			background.setBounds(parent.getClientArea());
			background.moveAbove(null);
			list.setVisible(false);
			int index = list.getSelectionIndices()[0];
			showcase = (ShowCase)(showCases.get(index));
			parent.getShell().setText(showcase.getName());
	        showcase.show(background);
	    }
	}
	
	/**
	 * Commands handling
	 */
	public void widgetSelected(SelectionEvent e) {
		if (hasDirectSelect && e.widget == list) {
		    //launch();
		}else if (e.widget==commandLaunch) {
			launch();
		}else if (e.widget==commandExit) {
			quit();
		}
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
	    if (e.widget == list) {
	        launch();
	    }
	}


    public void widgetDisposed(DisposeEvent e) {
        if (e.widget == background) {
        	if (parent.isVisible()) {
        		list.setVisible(true);
        		parent.getShell().redraw();
        		parent.getShell().setText(originalShellString); //$NON-NLS-1$
        		list.forceFocus();
        	}	
        }
     }

	public void controlMoved(ControlEvent e) {
	}

	public void controlResized(ControlEvent e) {
		if (!list.isDisposed())
			list.setBounds(parent.getClientArea());
	}
	public void setFocus() {
		if(showcase == null || showcase.getComposite() == null
			|| showcase.getComposite().isDisposed()) {
			list.setFocus();
			//workaround BMHL7R33WD on Nokia
			list.select(0);
			list.redraw();
		} else {
			showcase.setFocus();
		}
	}
	
	private static class MyBackground extends Composite implements ControlListener {

		public MyBackground(Composite parent) {
			super(parent, SWT.NONE);
			parent.addControlListener(this);
		}
		
		public void controlMoved(ControlEvent e) {
		}

		public void controlResized(ControlEvent e) {
			if (!isDisposed())
				setBounds(getParent().getClientArea());
		}
		
	}
	
}
