/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.Menu;

import java.util.Hashtable;
import java.util.Vector;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuShowCase extends ShowCase implements KeyListener, Runnable, SelectionListener, ShellListener, FocusListener {
    
	boolean stopped = false;
	boolean bHasFocus = false;
	
	// Command
    Command		commandExit;
	
	// ClientArea of the Shell.
	Rectangle clientRect;
	// gc of the Shell.
	GC	gc;
	// Different value for shapeType.
	final int LINE = 2;
	final int ARC = 4;
	final int RECTANGLE= 8;
	final int OVAL = 16;
	final int MASK_SHAPE_TYPE = LINE|ARC|RECTANGLE|OVAL;
	// If the shape is fulling.
	final int FULL = 1;
	final int EMPTY = 0;
	final int MASK_FUL_EMPTY = ~FULL;

	final int TOP_FACE = 1;
	final int RIGHT_FACE = 2;
	final int BOTTOM_FACE = 4;
	final int LEFT_FACE = 8;
	final int NO_FACE = 0;
	
	// MenuItem on the root Menu.
	MenuItem menuItemDraw;
	MenuItem menuItemColor;
	MenuItem menuItemStyle;
	MenuItem menuItemMoving;
	
    private FocusListener superShellListener = null;
	
	// The background and foreground colr.
	int backGroundColor;
	int foreGroundColor;
	// The line style
	int lineStyle;
	// The Width line
	int lineWidth;
	// the XOR mode
	boolean xorModeState;
	
	// Indicate we clean the screen fefore draw
	boolean cleanBeforeDraw;

	// Position of the shape center.
	Point shapePosition;
	// Moving vector.
	Point shapeMoving;
	// Different value for deltaTime.
	final int SLOW = 200;
	final int MEDIUM = 100;
	final int FAST = 10;
	// Is the shape movable
	boolean shapeMovable;
	// Delta time moving.
	int deltaTime;
	// Type shape.
	int shapeType;

	// Keep the images to dispose it.
	Vector images;
	
	// Name and Style of the different MenuItem
	String[] textsMenuDraw = new String[]{Messages.getString("MenuShowCase.0"), Messages.getString("MenuShowCase.1"), Messages.getString("MenuShowCase.2") , Messages.getString("MenuShowCase.3"), Messages.getString("MenuShowCase.4")}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
	int[] stylesMenuDraw = new int[]{SWT.PUSH, SWT.PUSH,SWT.SEPARATOR,SWT.CASCADE,SWT.CASCADE};
	int[] typesShape = new int[]{LINE, ARC,RECTANGLE,RECTANGLE,OVAL};

	String[] textsMenuEmptyFull = new String[]{Messages.getString("MenuShowCase.5"), Messages.getString("MenuShowCase.6")}; //$NON-NLS-1$ //$NON-NLS-2$
	int[] stylesMenuEmptyFull = new int[]{SWT.PUSH, SWT.PUSH};

	String[] textsMenuColour = new String[]{Messages.getString("MenuShowCase.7"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.8"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.9"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.10"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.11"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.12"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.13"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.14"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.15"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.16"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.17"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.18"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.19"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.20"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.21"), //$NON-NLS-1$
											Messages.getString("MenuShowCase.22")}; //$NON-NLS-1$
	
	int[] colorsValue = new int[] {			SWT.COLOR_BLACK,
											SWT.COLOR_BLUE,
											SWT.COLOR_DARK_BLUE,
											SWT.COLOR_CYAN,
											SWT.COLOR_DARK_CYAN,
											SWT.COLOR_GRAY,
											SWT.COLOR_DARK_GRAY,
											SWT.COLOR_GREEN,
											SWT.COLOR_DARK_GREEN,
											SWT.COLOR_MAGENTA,
											SWT.COLOR_DARK_MAGENTA,
											SWT.COLOR_RED,
											SWT.COLOR_DARK_RED,
											SWT.COLOR_YELLOW,
											SWT.COLOR_DARK_YELLOW,
											SWT.COLOR_WHITE};

	String[] textsMenuColor = new String[]{Messages.getString("MenuShowCase.23"), Messages.getString("MenuShowCase.24")}; //$NON-NLS-1$ //$NON-NLS-2$
	int[] stylesMenuColor = new int[]{SWT.CASCADE, SWT.CASCADE};

	String[] textsMenuStyle = new String[]{Messages.getString("MenuShowCase.25"), Messages.getString("MenuShowCase.26"), Messages.getString("MenuShowCase.27"), Messages.getString("MenuShowCase.28")}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	int[] stylesMenuStyle = new int[]{SWT.CHECK, SWT.CHECK, SWT.CHECK, SWT.CHECK};

	String[] textsMenuMoving = new String[] {Messages.getString("MenuShowCase.29"), Messages.getString("MenuShowCase.30")}; //$NON-NLS-1$ //$NON-NLS-2$
	int[] stylesMenuMoving = new int[] {SWT.CHECK, SWT.CASCADE};

	String[] textsMenuMovingSpeed = new String[] {Messages.getString("MenuShowCase.31"), Messages.getString("MenuShowCase.32"), Messages.getString("MenuShowCase.33")}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	int[] stylesMenuMovingSpeed = new int[] {SWT.RADIO, SWT.RADIO, SWT.RADIO};
	int[] speedShape = new int[] {SLOW, MEDIUM, FAST};

	public MenuShowCase() {
	}
	
	public String getName() {
		return Messages.getString("MenuShowCase.34"); //$NON-NLS-1$
	}

	public void focusGained(FocusEvent fe) {
		// if we already have focus, return
		if (bHasFocus) return;
		
		// need to show menus
	    Menu menu = getComposite().getShell().getMenuBar();
	    if(menu == null)
	       	menu = new Menu(getComposite().getShell(), SWT.BAR);

	    createDrawMenu(menu);
	    createColorMenu(menu);
	    createStyleMenu(menu);
	    createMovingMenu(menu);	
	        
	    getComposite().getShell().setMenuBar(menu);
	    if(commandExit == null){
			commandExit = new Command(getComposite(), Command.EXIT, 5);
			commandExit.setText(Messages.getString("MenuShowCase.35")); //$NON-NLS-1$
			commandExit.setLongLabel(Messages.getString("MenuShowCase.36")); //$NON-NLS-1$
			commandExit.addSelectionListener(this);
		}
	    
	    bHasFocus = true;
	};
	
	public void focusLost(FocusEvent fe) {
		// if we don't have focus return
		if (!bHasFocus) return;
		
		// need to hide menus
		if(menuItemDraw!=null){
			if(!menuItemDraw.isDisposed()){
				menuItemDraw.dispose();
			}
			menuItemDraw = null;	
		}
		if(menuItemColor!=null){
			if(!menuItemColor.isDisposed()){
				menuItemColor.dispose();
			}
			menuItemColor = null;	
		}
		if(menuItemStyle!=null){
			if(!menuItemStyle.isDisposed()){
				menuItemStyle.dispose();
			}
			menuItemStyle = null;	
		}
		
		if(menuItemMoving!=null){
			if(!menuItemMoving.isDisposed()){
				menuItemMoving.dispose();
			}
			menuItemMoving = null;	
		}
		
		if(commandExit!=null){
			if(!commandExit.isDisposed()){
				commandExit.dispose();
			}
			commandExit = null;	
		}
		
		bHasFocus = false;
	};
	
	public void show() {
		
		getComposite().getShell().addShellListener(this);
		
		images = new Vector();
        
		commandExit = new Command(getComposite(), Command.EXIT, 1);
		commandExit.setText(Messages.getString("MenuShowCase.35")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("MenuShowCase.36")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);

        // create menus
        focusGained(null);
        
        init();
        addKeyListenerToTreeStructure(getComposite(), this);

		setGcState();
		getComposite().addFocusListener(this);
        getComposite().forceFocus();
		getComposite().getDisplay().timerExec(deltaTime, this);
		
		//Bring up this focused Shell if existed while clicking eSWT Demo shortcut.
		superShellListener = new FocusListener() {
			public void focusGained(FocusEvent arg0) {
				if(getComposite() != null && !getComposite().isDisposed() && !getComposite().isFocusControl()) {
					getComposite().forceFocus();
				}
			}

			public void focusLost(FocusEvent arg0) {
			}			
		};
		super.getComposite().getShell().addFocusListener(superShellListener);
	}
	
	private void createDrawMenu(Menu menu) {
		// Create the Draw
		menuItemDraw = new MenuItem(menu, SWT.CASCADE);
		menuItemDraw.setText(Messages.getString("MenuShowCase.37")); //$NON-NLS-1$
        
        
        // Create the Draw menu
        Hashtable menuItemsDraw = createMenu(menuItemDraw, textsMenuDraw, stylesMenuDraw, listenerDraw);
        Hashtable menuRectangleFullEmpty = createMenu ((MenuItem) menuItemsDraw.get(textsMenuDraw[3]), textsMenuEmptyFull, stylesMenuEmptyFull, listenerFillEmpty);
        createMenu ((MenuItem) menuItemsDraw.get(textsMenuDraw[4]), textsMenuEmptyFull, stylesMenuEmptyFull, listenerFillEmpty);

        // temporary workaround:
        // move setting of images to after menu is created in order to avoid 
        // label overwriting cascade arrow and fix images not showing up on PPC
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/iconLine.gif"))); //$NON-NLS-1$
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/iconArc.gif"))); //$NON-NLS-1$
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/iconRectangle.gif"))); //$NON-NLS-1$
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/iconOval.gif"))); //$NON-NLS-1$
        ((MenuItem)menuItemsDraw.get(textsMenuDraw[0])).setImage((Image) images.get(0));
        ((MenuItem)menuItemsDraw.get(textsMenuDraw[1])).setImage((Image) images.get(1));
        ((MenuItem)menuItemsDraw.get(textsMenuDraw[3])).setImage((Image) images.get(2));
        ((MenuItem)menuItemsDraw.get(textsMenuDraw[4])).setImage((Image) images.get(3));
     
        // Select the full rectangle in the menu and update the variable.
        ((MenuItem)menuRectangleFullEmpty.get(textsMenuEmptyFull[0])).setSelection(true);
        shapeType = typesShape[3];
        shapeType |= FULL;
	}
	
	private void quit() {
		gc.dispose();
		gc = null;
		bHasFocus = false;
		if(!menuItemDraw.isDisposed())menuItemDraw.dispose();
		if(!menuItemColor.isDisposed())menuItemColor.dispose();
		if(!menuItemStyle.isDisposed())menuItemStyle.dispose();
		if(!menuItemMoving.isDisposed())menuItemMoving.dispose();

		if(super.getComposite() != null && !super.getComposite().isDisposed())
		{
    		super.getComposite().getShell().removeFocusListener(superShellListener);
		}
		
		dispose();

		for (int i = 0; i < images.size(); i ++) {
			((Image)images.get(i)).dispose();
		}
		images = null;
	}
	
	private void createBackgroundColorMenu(MenuItem parent) {
        // Create the Colors menu
        int[] styles = new int[textsMenuColour.length];
        for (int i = 0; i < styles.length; i++) {
        	styles[i] = SWT.RADIO;
        }
        Hashtable menuItemsColours = createMenu(parent, textsMenuColour, styles, listenerBackGroundColour);

        // Select the fourth color in the menu and update the variable.
        ((MenuItem)menuItemsColours.get(textsMenuColour[4])).setSelection(true);
        backGroundColor = colorsValue[4];
	}
	
	private void createForegroundColorMenu(MenuItem parent) {
         // Create the Colors menu
        int[] styles = new int[textsMenuColour.length];
        for (int i = 0; i < styles.length; i++) {
        	styles[i] = SWT.RADIO;
        }
        Hashtable menuItemsColours = createMenu(parent, textsMenuColour, styles, listenerForeGroundColour);
        
        // Select the blue second in the menu and update the variable.
        ((MenuItem)menuItemsColours.get(textsMenuColour[1])).setSelection(true);	
        foreGroundColor = colorsValue[1];
	}

	private void createColorMenu(Menu menu) {
        menuItemColor = new MenuItem(menu, SWT.CASCADE);
        menuItemColor.setText(Messages.getString("MenuShowCase.42")); //$NON-NLS-1$
        Hashtable menuItemsColor = createMenu(menuItemColor, textsMenuColor, stylesMenuColor, null);
        
        createBackgroundColorMenu((MenuItem) menuItemsColor.get(textsMenuColor[0]));
        createForegroundColorMenu((MenuItem) menuItemsColor.get(textsMenuColor[1]));
	}
	
	private void createStyleMenu(Menu menu) {
        // Create the style
		menuItemStyle = new MenuItem(menu, SWT.CASCADE);
		menuItemStyle.setText(Messages.getString("MenuShowCase.43")); //$NON-NLS-1$
        // Create the style menu
        Hashtable menuItemsStyle = createMenu(menuItemStyle, textsMenuStyle,stylesMenuStyle, listenerStyle);


        // Unselect the dot style in the menu and update the variable.
        ((MenuItem)menuItemsStyle.get(textsMenuStyle[0])).setSelection(false);
        lineStyle = SWT.LINE_SOLID;
        // Unselect the thick style in the menu and update the variable.
        ((MenuItem)menuItemsStyle.get(textsMenuStyle[1])).setSelection(false);
        lineWidth = 1;
        // Unselect the XOR style in the menu and update the variable.
        ((MenuItem)menuItemsStyle.get(textsMenuStyle[2])).setSelection(false);
        xorModeState = false;
        // Don't clean the screen before draw.
        cleanBeforeDraw = false;
	}
	
	private void createMovingMenu(Menu menu) {

        // Create the clear
        menuItemMoving = new MenuItem(menu, SWT.CASCADE);
        menuItemMoving.setText(Messages.getString("MenuShowCase.44")); //$NON-NLS-1$
        // Create the Moving menu
        Hashtable menuItemsMoving = createMenu(menuItemMoving, textsMenuMoving,stylesMenuMoving, listenerMoving);
        Hashtable menuItemsMovingSpeed = createMenu((MenuItem) menuItemsMoving.get(textsMenuMoving[1]), textsMenuMovingSpeed, stylesMenuMovingSpeed, listenerSpeed);
        
        

        // Set the first speed in the menu
        ((MenuItem)menuItemsMovingSpeed.get(textsMenuMovingSpeed[2])).setSelection(true);
        deltaTime = FAST;
        
        // Select unsettled
        ((MenuItem)menuItemsMoving.get(textsMenuMoving[0])).setSelection(false);
        shapeMovable = true;
        // so unactive the speed Menu
        ((MenuItem)menuItemsMovingSpeed.get(textsMenuMovingSpeed[0])).getParent().getParentItem().setEnabled(true);
        
	}



	public void keyPressed(KeyEvent e) {
		if (e.character == SWT.ESC) {
			quit();
		}
	}


	public void keyReleased(KeyEvent e) {		
	}
	

    private void addKeyListenerToTreeStructure(Composite parent, KeyListener listener) {
    	if (parent != null) {
    		parent.addKeyListener(listener);
	    	Control[] childrens  = parent.getChildren();
	    	
	    	for (int i =0; i < childrens.length ; i++) {
	    		if (Composite.class.isAssignableFrom(childrens[i].getClass())) {
	    			addKeyListenerToTreeStructure( (Composite)childrens[i], this);
	    		} else {
	    			childrens[i].addKeyListener(listener);	    			
	    		}
	    	}
    	}
    }	

	// Create a menu on a menuitem, add this for the selectionListener
	private Hashtable createMenu(MenuItem parent, String[] texts, int[] styles, SelectionListener selectionListener) {
		Hashtable menuItems = new Hashtable();
        // Create the  menu
        Menu menu = new Menu(getComposite().getShell(), SWT.DROP_DOWN);
		
        for (int i = 0; i < texts.length; i++) {
        	MenuItem menuItem = new MenuItem(menu, styles[i]);
        	if (styles[i] != SWT.SEPARATOR) {
        		if (selectionListener != null)
        			menuItem.addSelectionListener(selectionListener);
        		menuItem.setText(texts[i]);
        	}
        	menuItems.put(menuItem.getText(), menuItem);        	
        }
        
        parent.setMenu(menu);
        
        return menuItems;
	}
	
	// Verify if the MenuItem is a children of a Menu
	private boolean isParent(Menu parent, MenuItem menuItem) {
		Menu currentMenu= menuItem.getMenu();
		while (currentMenu != parent && currentMenu != null) {
			currentMenu = currentMenu.getParentMenu();
		}
		
		return (currentMenu == parent)? true : false ;
	}
	
	private void drawShape(int type, Point position) {
		Rectangle bounds = getBoundShape(type, position);
		
		switch (type&MASK_SHAPE_TYPE) {
		case LINE: {
			gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height );

		} break;
		case ARC: {
			gc.drawArc(bounds.x, bounds.y, bounds.width, bounds.height, -20, 130 );

		} break;
			case RECTANGLE: {
				if ( (type&FULL) == 0) {
					gc.drawRectangle(bounds);
				} else {
					gc.fillRectangle(bounds);					
				}
			} break;
			case OVAL: {
				if ( (type&FULL) == 0) {
					gc.drawOval(bounds.x, bounds.y, bounds.width, bounds.height);
				} else {
					gc.fillOval(bounds.x, bounds.y, bounds.width, bounds.height);					
				}
			} break;
			default: {
				gc.drawRectangle(position.x, position.y, 10, 10);			
			}break;
		}
	}
	
	void setGcState() {		
		gc.setForeground(getComposite().getDisplay().getSystemColor(foreGroundColor));
		gc.setBackground(getComposite().getDisplay().getSystemColor(backGroundColor));
		gc.setLineStyle(lineStyle);
		gc.setLineWidth(lineWidth);
		gc.setXORMode(xorModeState);
	}

	/*
	 * return the colition face number 
	 * TOP_FACE
	 * RIGHT_FACE
	 * BOTTOM_FACE
	 * LEFT_FACE
	 * NO_FACE
	 */
	private int colisionFaceShape(int type, Point position) {
		int face = NO_FACE;
		
		Rectangle bound =  getBoundShape(type, position);
		
		Rectangle unionRect = clientRect.union(bound);
		if (!unionRect.equals(clientRect) ) {
			if (unionRect.x != clientRect.x) {
				face |= LEFT_FACE;
			}
			if (unionRect.y != clientRect.y) {
				face |= TOP_FACE;
			}
			if (unionRect.width != clientRect.width) {
				face |= RIGHT_FACE;
			}
			if (unionRect.height != clientRect.height) {
				face |= BOTTOM_FACE;
			}
		}		

		return face;
	}
	
	private Rectangle getBoundShape(int type, Point position) {
		Rectangle bound = new Rectangle(0, 0, 0, 0);

		bound.x = position.x - getSizeShape(type).x/2;
		bound.y = position.y - getSizeShape(type).y/2;
		bound.width = getSizeShape(type).x;
		bound.height = getSizeShape(type).y;

		return bound;
	}
	
	private Point getSizeShape(int type) {
		Point size = new Point(0, 0);
		
		switch (type&MASK_SHAPE_TYPE) {
			case OVAL: {
				size.x = 20;
				size.y = 10;
			} break;
			default: {
				size.x = 10;
				size.y = 10;			
			}break;
		}
		
		return size;
		
	}
	
	private void init() {
		clientRect = getComposite().getClientArea();
		gc = new GC(getComposite());
		
		shapeMoving = new Point(3,3);
		shapePosition = new Point(clientRect.width/2, clientRect.height/2); 
	}
	
	private int getChoosedColor(Menu menuColor) {
		int color = 0;
		
		MenuItem[] menuItemColors = menuColor.getItems();
		
		for (int i = 0; i < menuItemColors.length; i ++) {
			if (menuItemColors[i].getSelection() == true) {
				if (i < colorsValue.length) {
					return colorsValue[i];
				} else {
					return color;
				}
			}
		}
		
		return color;
	}


	public void run() {
		
		if (stopped)
			return;
		
		if (gc != null) {
			
			if (shapeMovable == true) {
				setGcState();
				Point newPosition = new Point(shapePosition.x + shapeMoving.x, shapePosition.y + shapeMoving.y);
				
				int colitionFace = colisionFaceShape(shapeType,newPosition);
				if (colitionFace == NO_FACE) {
					if (cleanBeforeDraw == true) {
						eraseShape();
					}
					drawShape(shapeType,newPosition);
					shapePosition = newPosition;
				} else {
					if ( (colitionFace&(RIGHT_FACE|LEFT_FACE)) != 0 ) {
						shapeMoving = new Point(-shapeMoving.x, shapeMoving.y);
					}
					if ( (colitionFace&(TOP_FACE|BOTTOM_FACE)) != 0 ) {
						shapeMoving = new Point(shapeMoving.x, -shapeMoving.y);
					}
				}
			} else {
				drawShape(shapeType,shapePosition);				
			}

			if (gc != null) {
				getComposite().getDisplay().timerExec(deltaTime, this);
			}
			getComposite().redraw();
		}
	}
	
	private SelectionListener listenerDraw = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget; 
        	String text = menuItem.getText();

        	/*SetSeletionInMenuAndSubMenu(menuItem.getParent(), false);

        	menuItem.setSelection(true);*/

        	eraseShape();

        	if (text == textsMenuDraw[0]) {
        		shapeType = typesShape[0];
        	} else if (text == textsMenuDraw[1]) {
        		shapeType = typesShape[1];
        	}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};
	
	private void SetSeletionInMenuAndSubMenu(Menu menu, boolean selection) {
		if (menu != null) {
			MenuItem[] menuItems = menu.getItems();
			
			for (int i = 0; i < menuItems.length; i++) {
				if (menuItems[i].getMenu() != null) {
					SetSeletionInMenuAndSubMenu(menuItems[i].getMenu(), selection);
				} else {
					menuItems[i].setSelection(selection);
				}
			}
		}		
	}
	
	private SelectionListener listenerFillEmpty = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget; 
        	String text = menuItem.getText();
        	
        	Menu menu = menuItem.getParent();
        	
        	eraseShape();
        	if (menu != null) {
            	MenuItem parentMenuItem = menu.getParentItem();
            	
            	if (parentMenuItem != null) {
            		String textParentMenuItem = parentMenuItem.getText();
            		
            		 if (textParentMenuItem == textsMenuDraw[3]) {
                		shapeType = typesShape[3];      		
                	} else if (textParentMenuItem == textsMenuDraw[4]) {
                		shapeType = typesShape[4];      		
                	}
            	}

            	SetSeletionInMenuAndSubMenu(menu.getParentMenu(), false);
        	}

        	if (text == textsMenuEmptyFull[0]) {
        		shapeType = MASK_FUL_EMPTY & shapeType;
        		shapeType |= EMPTY;
        	} else if (text == textsMenuEmptyFull[1]) {
        		shapeType = MASK_FUL_EMPTY & shapeType;
        		shapeType |= FULL;     		
        	}

        	menuItem.setSelection(true);
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};
	
	private SelectionListener listenerForeGroundColour = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget;

        	foreGroundColor = getChoosedColor(menuItem.getParent());
 		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};
	
	private SelectionListener listenerBackGroundColour = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget;

        	backGroundColor = getChoosedColor(menuItem.getParent());
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};
	
	private SelectionListener listenerStyle = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget; 
        	String text = menuItem.getText();

        	eraseShape();

        	if (text == textsMenuStyle[0]) {
        		if (menuItem.getSelection() == true) {
        			lineStyle = SWT.LINE_DOT;
        		} else {
        			lineStyle = SWT.LINE_SOLID;
        		}
        	} else if (text == textsMenuStyle[1]) {
        		if (menuItem.getSelection() == true) {
        			lineWidth = 3;
        		} else {
        			lineWidth = 1;
        		}       		
        	} else if (text == textsMenuStyle[2]) {
        		if (menuItem.getSelection() == true) {
	    			xorModeState = true;
	    		} else {
	    			xorModeState = false;
	    		}
        	} else if (text == textsMenuStyle[3]) {
        		if (menuItem.getSelection() == true) {
        			erase();
	    			cleanBeforeDraw = true;
	    		} else {
	    			cleanBeforeDraw = false;
	    		}
        	}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};
	
	private SelectionListener listenerMoving = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget;
        	String text = menuItem.getText();
        	
    		if (text == textsMenuMoving[0]) {
    			Menu menu = menuItem.getParent();
    			
    			if (menu != null) {
    				MenuItem menuItemSpeed = menu.getItem(1);
    				
    				if (menuItemSpeed != null) {
    	        		if (menuItem.getSelection()) {
    						menuItemSpeed.setEnabled(false);
    						shapeMovable = false;
    	        		} else {
    	        			menuItemSpeed.setEnabled(true);
    						shapeMovable = true;
    	        			
    	        			Menu menuSpeed = menuItemSpeed.getMenu();
    	        			MenuItem[] menuItemsSpeed = menuSpeed.getItems();
    	        			
    	        			for (int i = 0; i < menuItemsSpeed.length; i++) {
    	        				if (menuItemsSpeed[i].getSelection() == true) {
    	        					deltaTime = speedShape[i];
    	        					continue;
    	        				}
    	        			}
    	        		}
    				}
    			}
    		}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};
	
	private SelectionListener listenerSpeed = new SelectionListener() {

		public void widgetSelected(SelectionEvent e) {
        	MenuItem menuItem = (MenuItem)e.widget;
        	String text = menuItem.getText();

        	if (text == textsMenuMovingSpeed[0]) {
        		deltaTime = speedShape[0];
        	} else if (text == textsMenuMovingSpeed[1]) {
        		deltaTime = speedShape[1];
        	} else if (text == textsMenuMovingSpeed[2]) {
        		deltaTime = speedShape[2];	        		
        	}
		}

		public void widgetDefaultSelected(SelectionEvent e) {
		}
		
	};

	public void widgetSelected(SelectionEvent e) {
		 if (e.widget == commandExit) {
        	quit();
        }
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		
	}
	
	private void eraseShape() {
		Rectangle rectangle = new Rectangle(shapePosition.x  - getSizeShape(shapeType).x/2 - (lineWidth - 1), shapePosition.y  - getSizeShape(shapeType).y/2 - (lineWidth - 1), getSizeShape(shapeType).x * 2 + (lineWidth - 1), getSizeShape(shapeType).y * 2 + (lineWidth - 1));
		    
		gc.setBackground(getComposite().getDisplay().getSystemColor(SWT.COLOR_WHITE));
		gc.setForeground(getComposite().getDisplay().getSystemColor(SWT.COLOR_WHITE));
		gc.setXORMode(false);

		gc.fillRectangle(rectangle);

		setGcState();
	}
	
	private void erase() {
		gc.setBackground(getComposite().getDisplay().getSystemColor(SWT.COLOR_WHITE));
		gc.setForeground(getComposite().getDisplay().getSystemColor(SWT.COLOR_WHITE));
		gc.setXORMode(false);

		gc.fillRectangle(clientRect);

		setGcState();
		
	}
	
	public void shellActivated(ShellEvent e) {
	}

	public void shellClosed(ShellEvent e) {
		stopped = true;
	}
	
	public void shellDeactivated(ShellEvent e) {
		stopped = true;
	}
	
	public void shellDeiconified(ShellEvent e) {
	}
	
	public void shellIconified(ShellEvent e) {
	}
	
	public void setFocus() {
    	getComposite().setFocus();
    }
}
