/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.MessageBox;

import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;

/**
 *	This ShowCase show different MessageBoxes with different styles 
 */
public class MessageBoxShowCase extends ShowCase {
	/**
	 * Constructor
	 * 
	 * @param parent the parent shell
	 */
	public MessageBoxShowCase() {
	}
	
	/**
	 * Name of the ShowCase
	 */
	public String getName() {
		return Messages.getString("MessageBoxShowCase.0"); //$NON-NLS-1$
	}
	
	/**
	 * Launch the ShowCase
	 */
	public void show() {
	
		openBox(SWT.ICON_INFORMATION | SWT.OK, Messages.getString("MessageBoxShowCase.2")); //$NON-NLS-1$
		if (openBox(SWT.ICON_WORKING | SWT.OK | SWT.CANCEL, Messages.getString("MessageBoxShowCase.3")) == SWT.OK) { //$NON-NLS-1$
			if (openBox(SWT.ICON_QUESTION | SWT.YES | SWT.NO, Messages.getString("MessageBoxShowCase.4")) == SWT.YES) { //$NON-NLS-1$
				boolean showEnd = false;
				
				int btn = openBox(SWT.ICON_QUESTION | SWT.YES | SWT.NO | SWT.CANCEL, Messages.getString("MessageBoxShowCase.5")); //$NON-NLS-1$
				if (btn == SWT.YES) {
					if (openBox(SWT.ICON_ERROR | SWT.RETRY | SWT.CANCEL, Messages.getString("MessageBoxShowCase.6")) == SWT.RETRY) { //$NON-NLS-1$
						showEnd = true;
					}	
				} else if (btn == SWT.NO) {
					showEnd = true;
				}
		
				if (showEnd) {
					openBox(SWT.ICON_INFORMATION | SWT.OK, Messages.getString("MessageBoxShowCase.7")); //$NON-NLS-1$
				}
			}
		}
		dispose();
	}
	
	/**
	 * display a MessageBox
	 * 
	 * @param style the style of the MEssageBox
	 * @param message the text of the MessageBox
	 * @return the id of the button that have been selected
	 */
	private int openBox(int style, String message) {
		MessageBox box = new MessageBox(getComposite().getShell(), style);
		box.setMessage(message);
		return box.open();
	}

}
