/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - eSWT Demo application
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.MobileShell;

import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.MobileShell;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;


/**
 * Display MobileShell with different styles
 */
public class MobileShellShowCase extends ShowCase implements PaintListener, KeyListener, TraverseListener, SelectionListener {
	MobileShell mobileShell;
	Composite c;
	
	final String keyCodeString = Messages.getString("MobileShellShowCase.0"); //$NON-NLS-1$
	String 	keycode;
	boolean keypressed;
	 
	boolean switchmode = false;
	int 	mode;
	
	// the commands of the ShowCase
	Command commandFullscreen;
	Command commandFullscreenWithCmd;
	Command commandExit;
	Command commandBack;
	Button b;
	
	Color colBlue;
	Color colWhite;
	Color colRed;
	
	// for back buffer
	Image backbufferImage;
	GC	  backbufferGC;
	
	static int BACKGROUND_BORDER_WIDTH = 10;
	static int RED_RECTANGLES_WIDTH = 20;
	
	static int MODE_NORMAL = 1;
	static int MODE_FULLSCREEN = 2;
	static int MODE_FULLSCREENWITHCMD = 3;
	
	
	/**
	 * Constructor
	 * 
	 * @param parent the parent Shell
	 */
	public MobileShellShowCase() {
		keycode=""; //$NON-NLS-1$
	}
	
	/**
	 * Name of the ShowCase
	 */
	public String getName() {
		return Messages.getString("MobileShellShowCase.2"); //$NON-NLS-1$
	}
	
	/**
	 * Launch the ShwoCase
	 */
	public void show() {
	    mobileShell = new MobileShell(Display.getCurrent(), SWT.TITLE | SWT.MIN | SWT.MAX | SWT.RESIZE);
	    c = new Composite(mobileShell, 0);
	    
	    
	    mobileShell.setText(Messages.getString("MobileShellShowCase.3")); //$NON-NLS-1$
//	    mobileShell.addPaintListener(this);
	    c.addPaintListener(this);
		mobileShell.addKeyListener(this);
		mobileShell.addTraverseListener(this);
		mobileShell.setLayout(new FillLayout());
		
		// provide for reverting back to normal mode
		b = new Button(c, SWT.PUSH);
		b.setText(Messages.getString("MobileShellShowCase.4")); //$NON-NLS-1$
		b.setBounds(20,20, 100, 40);
		b.addSelectionListener(this);
		b.addKeyListener(this);
		
		c.redraw();
		mobileShell.setFocus();
		normalMode();
		
		mobileShell.layout();
		mobileShell.open();
		
		mobileShell.setBackground(new Color(Display.getCurrent(), 25, 255, 25));
	}
	

	public void paintControl(PaintEvent e) {
		buildDoubleBufferingGC();
		
		
//		Rectangle rect = c.getClientArea();
		
		
	    Rectangle rc = textRectangle(keyCodeString + (keycode != null ? keycode : "")); //$NON-NLS-1$
		if (e.height == rc.height && e.width == rc.width) {
			if (colWhite == null) {
			    colWhite = new Color(mobileShell.getDisplay(), 255, 255, 255);
			}
			backbufferGC.setBackground(colWhite);
			backbufferGC.setForeground(colWhite);
		    backbufferGC.fillRectangle(new Rectangle(e.x, e.y, e.width, e.height));
		}
		else {
		    drawBackground();
		}
		DrawText();
		
		e.gc.drawImage(backbufferImage, 0, 0);	
		
		
	}
	
	
	/**
	 * Draw the backgound of the mobileshell
	 */
	private void drawBackground() {
		Rectangle area = c.getClientArea();
		
		// Draw the blue border
		if (colBlue == null) {
		    colBlue = new Color(mobileShell.getDisplay(), 0, 0, 255);
		}
		backbufferGC.setBackground(colBlue);
		backbufferGC.setForeground(colBlue);
		backbufferGC.fillRectangle(area);
		
		Rectangle insideRect = new Rectangle(	area.x+BACKGROUND_BORDER_WIDTH,
												area.y+BACKGROUND_BORDER_WIDTH,
												area.width-BACKGROUND_BORDER_WIDTH*2,
												area.height-BACKGROUND_BORDER_WIDTH*2);
		if (colWhite == null) {
		    colWhite = new Color(mobileShell.getDisplay(), 255, 255, 255);
		}
		backbufferGC.setBackground(colWhite);
		backbufferGC.setForeground(colWhite);
		backbufferGC.fillRectangle(insideRect);
		
		// draw the red rectangles
		int nb_red_rectangle_x = area.width/(RED_RECTANGLES_WIDTH*2)+1;
		int nb_red_rectangle_y = area.height/(RED_RECTANGLES_WIDTH*2)+1;
		if (colRed == null) {
		    colRed = new Color(mobileShell.getDisplay(), 255, 0, 0);
		}
		backbufferGC.setBackground(colRed);
		backbufferGC.setForeground(colRed);
		for (int i=0;i<nb_red_rectangle_x;i++) {
			backbufferGC.fillRectangle((i*2)*RED_RECTANGLES_WIDTH,0,RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH);
		}
		for (int i=0;i<nb_red_rectangle_x;i++) {
			backbufferGC.fillRectangle((i*2)*RED_RECTANGLES_WIDTH,area.height-RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH);
		}
		for (int i=0;i<nb_red_rectangle_y;i++) {
			backbufferGC.fillRectangle(0,(i*2)*RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH);
		}
		for (int i=0;i<nb_red_rectangle_y;i++) {
			backbufferGC.fillRectangle(area.width-RED_RECTANGLES_WIDTH,(i*2)*RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH,RED_RECTANGLES_WIDTH);
		}
	}

	/**
	 * draw informations and instructions 
	 *
	 */
	private void DrawText() {
		// set color of the texts
		backbufferGC.setBackground(mobileShell.getDisplay().getSystemColor(SWT.COLOR_WIDGET_BACKGROUND));
		backbufferGC.setForeground(mobileShell.getDisplay().getSystemColor(SWT.COLOR_BLACK));

		// draw key input text
		String text = Messages.getString("MobileShellShowCase.6"); //$NON-NLS-1$
		if (keycode != null) {
			text = text+keycode;
		}
		
		Rectangle r = textRectangle(text);
		backbufferGC.drawText(text, r.x, r.y);
		
		if (mode==MODE_FULLSCREEN) {
			// draw fullscreen mode instruction
			Rectangle area = mobileShell.getClientArea();
			text = Messages.getString("MobileShellShowCase.7"); //$NON-NLS-1$
			Point textextent = backbufferGC.textExtent(text);
			if (textextent.x < area.width) {
				backbufferGC.drawText(text, area.x + (area.width - textextent.x) / 2, area.y + (area.height / 2 - textextent.y ) / 2);
			} else {
				// Fix display of too long text
			    text = Messages.getString("MobileShellShowCase.8"); //$NON-NLS-1$
			    String text2 = Messages.getString("MobileShellShowCase.9"); //$NON-NLS-1$
			    String text3 = Messages.getString("MobileShellShowCase.10"); //$NON-NLS-1$
			    textextent = backbufferGC.textExtent(text);
			    Point textextent2 = backbufferGC.textExtent(text2);
			    Point textextent3 = backbufferGC.textExtent(text3);
			    backbufferGC.drawText(text, area.x + (area.width - textextent.x) / 2, area.y + (area.height / 2 - textextent.y ) / 2);
			    backbufferGC.drawText(text2, area.x + (area.width - textextent2.x) / 2, area.y + (area.height / 2 - textextent.y ) / 2 + textextent.y );
			    backbufferGC.drawText(text3, area.x + (area.width - textextent3.x) / 2, area.y + (area.height / 2 - textextent.y ) / 2 + + textextent.y + textextent2.y);

			}
		}


	}
	
	public Rectangle textRectangle(String text) {
		Rectangle area = mobileShell.getClientArea();
		Rectangle keycodetextarea = area;
		
		if (mode==MODE_FULLSCREEN) {
			keycodetextarea = new Rectangle(area.x, area.y + (area.height / 2), area.width, area.height / 2);
		}
		else {
			keycodetextarea = area;
		}
		Point textextent = backbufferGC.textExtent(text);
	    return new Rectangle(keycodetextarea.x + (keycodetextarea.width - textextent.x) / 2, keycodetextarea.y + (keycodetextarea.height - textextent.y) / 2, textextent.x, textextent.y);
	}
	
	public void keyPressed(KeyEvent e) {
	    Rectangle oldRect = textRectangle(keyCodeString + (keycode != null ? keycode : "")); //$NON-NLS-1$
		keypressed = true;
		keycode = new Integer(e.keyCode).toString();
		
		String text = keyCodeString;
		if (keycode != null) {
			text = text + keycode;
		}
		
		Rectangle newRect = textRectangle(text);
		Rectangle maxRect = oldRect.width > newRect.width ? oldRect : newRect;
		
		c.redraw(maxRect.x, maxRect.y, maxRect.width, maxRect.height, true);
		
		// special key to go back from Fullscreen mode
		// use rocker key in this mode
		if (mode==MODE_FULLSCREEN) {
			if ((e.keyCode==SWT.ARROW_DOWN) ||
					(e.keyCode==SWT.ARROW_UP) ||
					(e.keyCode==SWT.ARROW_LEFT) ||
					(e.keyCode==SWT.ARROW_RIGHT) ||
					(e.keyCode==174)) {
				normalMode();
			}
		}
	}
	
    public void keyTraversed(TraverseEvent arg0) {
    	// The show case displays the key code of every pressed keys. 
    	// But if a key used by the platform to do traverse event is pressed, 
    	// the traverse event is executed without displaying its key code 
    	// We want no traverse in this showcase, grab all pressed keys as keyevents
        arg0.doit=false;
    }
    
	public void keyReleased(KeyEvent e) {
		keypressed = false;
//	    Rectangle rc = textRectangle(keyCodeString + (keycode != null ? keycode : ""));
//		getComposite().redraw(rc.x, rc.y, rc.width, rc.height, true);

		//keycode = "";
	}
	
	public void widgetSelected(SelectionEvent e) {
		if (e.widget==commandFullscreen) {
			fullscreenMode();
		} 
		else if (e.widget==commandFullscreenWithCmd) {
			fullscreenModeWithCommands();
		} 
		else if (e.widget==commandExit) {
			quit();
		} 
		else if (e.widget == b || e.widget==commandBack) {
			normalMode();
		} 
 	}

	public void widgetDefaultSelected(SelectionEvent e) {
  	}
	
	
	/**
	 * switch to the normal mode
	 *
	 */
	private void normalMode() {
		releaseCommands();
		switchmode = true;
		mode = MODE_NORMAL;
		
		mobileShell.setFullScreenMode(false);
		
		// Add commands
		commandFullscreen = new Command(mobileShell, Command.GENERAL, 3);
		commandFullscreen.setText(Messages.getString("MobileShellShowCase.14")); //$NON-NLS-1$
		commandFullscreen.addSelectionListener(this);

		commandFullscreenWithCmd = new Command(mobileShell, Command.GENERAL, 2);
		commandFullscreenWithCmd.setText(Messages.getString("MobileShellShowCase.15")); //$NON-NLS-1$
		commandFullscreenWithCmd.addSelectionListener(this);

		commandExit = new Command(mobileShell, Command.EXIT, 1);
		commandExit.setText(Messages.getString("MobileShellShowCase.16")); //$NON-NLS-1$
		commandExit.setLongLabel(Messages.getString("MobileShellShowCase.17")); //$NON-NLS-1$
		commandExit.addSelectionListener(this);
	}
	
	/**
	 * Switch to fullscreen mode
	 *
	 */
	private void fullscreenMode() {
		releaseCommands();
		switchmode = true;
		mode = MODE_FULLSCREEN;
		
		mobileShell.setFullScreenMode(true);
		
	}
	
	/**
	 * Switch to fullscreen mode, with commands
	 *
	 */
	private void fullscreenModeWithCommands() {
		releaseCommands();
		switchmode = true;
		mode = MODE_FULLSCREENWITHCMD;
		
		commandBack = new Command(mobileShell, Command.BACK, 2);
		commandBack.setText(Messages.getString("MobileShellShowCase.18")); //$NON-NLS-1$
		commandBack.addSelectionListener(this);
		
		mobileShell.setFullScreenMode(true);
	}
	
	/**
	 * Build back buffer and GC, if needed (i.e MobileShell was resized)
	 *
	 */
	private void buildDoubleBufferingGC() {
		if (switchmode) {
			if (backbufferImage!=null)
				backbufferImage.dispose();
			if (backbufferGC!=null)
				backbufferGC.dispose();
			backbufferImage = new Image(mobileShell.getDisplay(), mobileShell.getClientArea());
			backbufferGC = new GC(backbufferImage);
			switchmode = false;
		}
	}
	
	/**
	 * dispose the commands
	 *
	 */
	private void releaseCommands() {
		if (commandFullscreen!=null) {
			commandFullscreen.dispose();
			commandFullscreen=null;
		}
		if (commandFullscreenWithCmd!=null) {
			commandFullscreenWithCmd.dispose();
			commandFullscreenWithCmd=null;
		}
		if (commandExit!=null) {
			commandExit.dispose();
			commandExit=null;
		}
		if (commandBack!=null) {
			commandBack.dispose();
			commandBack=null;
		}
	}
	
	/**
	 * Quit show case, dispose objects
	 *
	 */
	private void quit() {
		if (backbufferImage != null) {
			backbufferImage.dispose();
		}
		if (backbufferGC != null) {
			backbufferGC.dispose();
		}
		if (colBlue != null) {
		    colBlue.dispose();
		    colBlue = null;
		}
		if (colWhite != null) {
		    colWhite.dispose();
		    colWhite = null;
		}
		if (colRed != null) {
		    colRed.dispose();
		    colRed = null;
		}
		releaseCommands();

		mobileShell.removeTraverseListener(this);
//		mobileShell.removePaintListener(this);
		
		c.removePaintListener(this);
		mobileShell.removeKeyListener(this);
		mobileShell.dispose();
		dispose();
	}

	protected void setFocus() {
		mobileShell.forceActive();
	}
}
