/*******************************************************************************
 * Copyright (c) 2005 Nokia.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nokia - Demo
 *******************************************************************************/
package org.eclipse.ercp.swt.samples.eswtdemo.MultiPageDialog;

import java.util.Vector;

import org.eclipse.ercp.swt.mobile.*;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.ScrolledComposite;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.graphics.*;

/**
 *
 *
 */
public class MultiPageDialogShowCase extends ShowCase implements SelectionListener, PaintListener, ModifyListener, Listener {
    MultiPageDialog multipagedialog;

    Command commandDone, commandNextPage;

    Vector images;
    Image	image;
    int     pageIndex = 0;
    Text userName;
    Color color;
    
    // Page1
    CaptionedControl name;
    
    // Page2
    CaptionedControl	captionCtrlPage2;
    Combo				comboPage2;
    Command 			commandAddLanguagePage2;
    
    // Page3
    CaptionedControl	captionCtrl1Page3;
    ProgressBar			progressBarPage3;
    Text				textPage3;
    int 				maxChar = 50;
    
    // Page4
    CaptionedControl 	captionRedPage4;
    Slider 				sliderRedPage4;
    
    CaptionedControl 	captionGreenPage4;
    Slider 				sliderGreenPage4;
    
    CaptionedControl 	captionBluePage4;
    Slider 				sliderBluePage4;
    
    Canvas				chosenColor;
    String              osName;
    
    // Page5
    Button buttonPage5;
    Canvas imagePage5;
    boolean isNokia = false;
    
    
    public MultiPageDialogShowCase() {
    }
    
    public String getName() {
        return Messages.getString("MultiPageDialogShowCase.0"); //$NON-NLS-1$
    }


    public void show() {
    	osName = System.getProperty("os.name");
    	if(osName != null) {
			osName = osName.toLowerCase();
	        if(osName.indexOf("symbian") >= 0 || osName.indexOf("epoc32") >= 0){
	        	isNokia = true;
	        }
		}
        
        //In order to bypass the Nokia's bug: BMHL7SPDS6
        //I should set the shell invisible while the MPD is shown
        //In order to make the screen transition more smoothly
        //I add FocusIn filter to this class before MPD is created
        //When focus is in MPD, we set the parent Shell invisible
        if(isNokia){
        	getComposite().getDisplay().addFilter(SWT.FocusIn, this);
        }
        
        images = new Vector();
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/png.png"))); //$NON-NLS-1$
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/jpeg.jpg"))); //$NON-NLS-1$
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/animatedgif1.gif"))); //$NON-NLS-1$
        images.add(new Image(getComposite().getDisplay(), getClass().getResourceAsStream("/res/smith.png"))); //$NON-NLS-1$
        
        image = (Image) images.get(0);

        createMultiPageDialog();

        fillPage1();
        fillPage2();
        fillPage3();
        fillPage4();
        fillPage5();
        multipagedialog.setSelection(pageIndex);
        multipagedialog.open();
        
        //After MPD is closed, we should set parent shell visible
        if(isNokia){
       	   getComposite().getShell().setVisible(true);
        }  
        
        quit();
    }
    
    void createMultiPageDialog() {
        // create the multipage dialog
        multipagedialog = new MultiPageDialog(getComposite().getShell());
        multipagedialog.setText(Messages.getString("MultiPageDialogShowCase.5")); //$NON-NLS-1$
        
        multipagedialog.addSelectionListener(this);
    }
    
    void centerControlInParent(Control control) {
    	Point controlsize	= control.getSize();
    	Point parentSize	= control.getParent().getSize();

    	Point centerPosition= new Point( (parentSize.x - controlsize.x) / 2, (parentSize.y - controlsize.y) / 2);

    	control.setLocation(centerPosition);
    }

    // first page
    // User information
    void fillPage1() {
        Composite page = multipagedialog.createPage(Messages.getString("MultiPageDialogShowCase.6"),null); //$NON-NLS-1$
        Rectangle viewPortMax = page.getClientArea();
        
        ScrolledComposite scrolledComposite = new ScrolledComposite(page, SWT.BORDER | SWT.V_SCROLL | SWT.H_SCROLL);
        scrolledComposite.setLayout(new FormLayout());
        if(viewPortMax.height>viewPortMax.width){
        	scrolledComposite.setBounds(viewPortMax.x, viewPortMax.y, viewPortMax.width, viewPortMax.height-50);
        }else{
        	scrolledComposite.setBounds(viewPortMax);
        }

    	// Composite which contains all controls
        Composite composite = new Composite(scrolledComposite, SWT.NONE);
        
        composite.setLayout(new RowLayout(SWT.FILL_WINDING));

        // Name
        name = new CaptionedControl(composite, SWT.LEFT_TO_RIGHT);
        name.setText(Messages.getString("MultiPageDialogShowCase.7")); //$NON-NLS-1$
        userName = new Text(name, SWT.SINGLE);
        userName.setText(Messages.getString("MultiPageDialogShowCase.8")); //$NON-NLS-1$
        userName.setEditable(true);

        // Surname
        CaptionedControl surname = new CaptionedControl(composite, SWT.LEFT_TO_RIGHT);
        surname.setText(Messages.getString("MultiPageDialogShowCase.9")); //$NON-NLS-1$
        Text userSurname = new Text(surname, SWT.SINGLE);
        userSurname.setText(Messages.getString("MultiPageDialogShowCase.10")); //$NON-NLS-1$

        // Date of birth
        CaptionedControl birthDate = new CaptionedControl(composite, SWT.LEFT_TO_RIGHT);
        birthDate.setSize(200,30);
        birthDate.setText(Messages.getString("MultiPageDialogShowCase.11")); //$NON-NLS-1$
        DateEditor birthDateEditor = new DateEditor(birthDate, SWT.NORMAL, DateEditor.DATE | DateEditor.FULL);

        // Phone number
        CaptionedControl phoneNumber = new CaptionedControl(composite, SWT.LEFT_TO_RIGHT);
        phoneNumber.setText(Messages.getString("MultiPageDialogShowCase.12")); //$NON-NLS-1$
        ConstrainedText userPhoneNumber = new ConstrainedText(phoneNumber, SWT.NORMAL, ConstrainedText.PHONENUMBER);
        userPhoneNumber.setText("6902690369"); //$NON-NLS-1$
        if(isNokia){
	        commandNextPage = new Command(page.getShell(), Command.GENERAL, 3);
	        commandNextPage.setText(Messages.getString("MultiPageDialogShowCase.47"));
	        commandNextPage.addSelectionListener(this);
        }
        commandDone = new Command(page.getShell(), Command.EXIT, 0);
        commandDone.setText(Messages.getString("MultiPageDialogShowCase.14")); //$NON-NLS-1$
        commandDone.addSelectionListener(this);
        
        composite.pack();
        scrolledComposite.setContent(composite);
        scrolledComposite.setAutoScroll(true);
        page.layout();
    }

    // second page
    void fillPage2() {
        Composite page = multipagedialog.createPage(Messages.getString("MultiPageDialogShowCase.15"),null); //$NON-NLS-1$

        captionCtrlPage2 = new CaptionedControl(page, SWT.LEFT_TO_RIGHT|SWT.BORDER);
        captionCtrlPage2.setText(Messages.getString("MultiPageDialogShowCase.16")); //$NON-NLS-1$

        comboPage2 = new Combo(captionCtrlPage2,SWT.DROP_DOWN|SWT.BORDER );
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.17") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.18") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.19") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.20") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.21") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.22") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.23") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.24") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.25") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.26") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.27") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.28") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.29") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.30") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.31") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.32") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.33") ); //$NON-NLS-1$
        comboPage2.add(Messages.getString("MultiPageDialogShowCase.34") ); //$NON-NLS-1$
        
        comboPage2.select(1);
        captionCtrlPage2.pack();
  
        commandAddLanguagePage2 = new Command(comboPage2, Command.GENERAL,3);
	    commandAddLanguagePage2.setText(Messages.getString("MultiPageDialogShowCase.35")); //$NON-NLS-1$
	    commandAddLanguagePage2.addSelectionListener(this);
	         
        centerControlInParent(captionCtrlPage2);
    }

    // third page
    void fillPage3() {        
        Composite page = multipagedialog.createPage(Messages.getString("MultiPageDialogShowCase.36"),null); //$NON-NLS-1$
        Rectangle bounds = page.getBounds();
        
        textPage3 = new Text(page, SWT.MULTI|SWT.BORDER);
        textPage3.setBounds(5, 5, bounds.width-10, 75);
        textPage3.setTextLimit(maxChar);
        textPage3.addModifyListener(this);
        
        captionCtrl1Page3 = new CaptionedControl(page, SWT.LEFT_TO_RIGHT);
        captionCtrl1Page3.setText(Messages.getString("MultiPageDialogShowCase.37")); //$NON-NLS-1$
        progressBarPage3 = new ProgressBar(captionCtrl1Page3,SWT.HORIZONTAL);
        progressBarPage3.setMinimum(0);
        progressBarPage3.setMaximum(maxChar);
        progressBarPage3.setSelection(0);   
        captionCtrl1Page3.setBounds(5, 85, bounds.width-10, 50);
    }

    // 4th page
    void fillPage4() {
//    	int widthOfChosenColor =  180;
        Composite page = multipagedialog.createPage(Messages.getString("MultiPageDialogShowCase.38"),null); //$NON-NLS-1$
        
        GridLayout gridlayout = new GridLayout();
        gridlayout.numColumns = 2;
        page.setLayout(gridlayout);
        
        Composite page1 = new Composite(page,SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        page1.setLayoutData(gridData);        
        
        
        Composite page2 = new Composite(page,SWT.NONE);       
        FillLayout fillLayout2 = new FillLayout();
        fillLayout2.type = SWT.HORIZONTAL;
        page2.setLayout(fillLayout2);
        
       
        //set the content in page1 as RowLayout
        RowLayout layout = new RowLayout(SWT.VERTICAL);
        page1.setLayout(layout);
        
        page.layout();//here layout first, thus we can get page1.getClientArea().width
        // Control the size of the following three CaptionControl adjustable to screen size 
        RowData rowData = new RowData(page1.getClientArea().width-5, SWT.DEFAULT);

        
        // Red
        captionRedPage4 = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
        captionRedPage4.setText(Messages.getString("MultiPageDialogShowCase.39")); //$NON-NLS-1$
        sliderRedPage4 = new Slider(captionRedPage4,SWT.HORIZONTAL);
        sliderRedPage4.setMinimum(0);
        sliderRedPage4.setMaximum(11);
        sliderRedPage4.setSelection(2);
        sliderRedPage4.setThumb(1);
        sliderRedPage4.addSelectionListener(this);      
        captionRedPage4.setTrailingText(sliderRedPage4.getSelection()*10 + " %"); //$NON-NLS-1$
        captionRedPage4.setLayoutData(rowData);
        
        
        // Green
        captionGreenPage4 = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
        captionGreenPage4.setText(Messages.getString("MultiPageDialogShowCase.41")); //$NON-NLS-1$
        sliderGreenPage4 = new Slider(captionGreenPage4,SWT.HORIZONTAL);
        sliderGreenPage4.setMinimum(0);
        sliderGreenPage4.setMaximum(11);
        sliderGreenPage4.setSelection(3);
        sliderGreenPage4.setThumb(1);
        sliderGreenPage4.addSelectionListener(this);
        captionGreenPage4.setTrailingText(sliderGreenPage4.getSelection()*10 + " %"); //$NON-NLS-1$
        captionGreenPage4.setLayoutData(rowData);
        
         
        // Blue
        captionBluePage4 = new CaptionedControl(page1, SWT.LEFT_TO_RIGHT);
        captionBluePage4.setText(Messages.getString("MultiPageDialogShowCase.43")); //$NON-NLS-1$
        sliderBluePage4 = new Slider(captionBluePage4,SWT.HORIZONTAL);
        sliderBluePage4.setMinimum(0);
        sliderBluePage4.setMaximum(11);
        sliderBluePage4.setSelection(5);
        sliderBluePage4.setThumb(1);
        sliderBluePage4.addSelectionListener(this);
        captionBluePage4.setTrailingText(sliderBluePage4.getSelection()*10 + " %"); //$NON-NLS-1$
        captionBluePage4.setLayoutData(rowData);

        
		// The chosen color.
        chosenColor = new Canvas(page2, SWT.BORDER | SWT.NO_BACKGROUND);
        chosenColor.setEnabled(false);
        
        chosenColor.addPaintListener(this);
        chosenColor.redraw();        

        page1.layout();
        page2.layout();
        page.layout();
        
        
//        if (chosenColor.getSize().x > widthOfChosenColor) {
//            layout.marginWidth = (chosenColor.getSize().x - widthOfChosenColor)/2;
//        }
    }

    // 5th page
    void fillPage5() {
        Composite page = multipagedialog.createPage(Messages.getString("MultiPageDialogShowCase.45"),null); //$NON-NLS-1$
               
        Point pagesSize = page.getSize();
        
        imagePage5 = new Canvas(page, SWT.BORDER);
        imagePage5.setEnabled(false);
        
        imagePage5.addPaintListener(this);
        imagePage5.redraw();
        
        buttonPage5 = new Button(page,SWT.NORMAL);
        buttonPage5.setText(Messages.getString("MultiPageDialogShowCase.46")); //$NON-NLS-1$
        buttonPage5.setSize(100,50);
        buttonPage5.addSelectionListener(this);

        buttonPage5.setLocation(pagesSize.x-buttonPage5.getSize().x,(pagesSize.y-buttonPage5.getSize().y)/2);
        
        imagePage5.setSize(pagesSize.x-buttonPage5.getSize().x,pagesSize.y);
    }


    private void quit() {
    	multipagedialog.dispose();
        if (color != null) {
        	if(!color.isDisposed()){
        		color.dispose();
        		color = null;
        	}
        }
       
        for (int i = 0; i < images.size(); i++) {
        	((Image)(images.get(i))).dispose();
        }
        
        if(commandDone != null){
        	if(!commandDone.isDisposed()){
        		commandDone.dispose();
        		commandDone = null;
        	}
        }
        
        if(isNokia){
        	if(commandNextPage != null){
        		if(!commandNextPage.isDisposed()){
        			commandNextPage.dispose();
                	commandNextPage = null;
            	}
            }
        }
        
        if(image != null){
        	 if(!image.isDisposed()){
        		 image.dispose();
        		 image = null;
        	 }
        }
        
        if(userName != null){
        	if(!userName.isDisposed()){
        		userName.dispose();
        		userName = null;
        	}
        }
        
       
        if(isNokia){
        	getComposite().getDisplay().removeFilter(SWT.FocusIn, this);
        }
        
        if(name != null){
        	if(!name.isDisposed()){
        		name.dispose();
        		name = null;
        	}
        }
        
        if(captionCtrlPage2 != null){
        	if(!captionCtrlPage2.isDisposed()){
        		captionCtrlPage2.dispose();
        		captionCtrlPage2 = null;
        	}
        }
        
        if(comboPage2 != null){
        	if(!comboPage2.isDisposed()){
        		comboPage2.dispose();
        		comboPage2 = null;
        	}
        }
        if(commandAddLanguagePage2 != null){
        	if(!commandAddLanguagePage2.isDisposed()){
        		commandAddLanguagePage2.dispose();
        		commandAddLanguagePage2 = null;
        	}
        }
        if(captionCtrl1Page3 != null){
        	if(!captionCtrl1Page3.isDisposed()){
        		captionCtrl1Page3.dispose();
        		captionCtrl1Page3 = null;
        	}
        }
        if(progressBarPage3 != null){
        	if(!progressBarPage3.isDisposed()){
        		progressBarPage3.dispose();
        		progressBarPage3 = null;
        	}
        }
        if(textPage3 != null){
        	if(!textPage3.isDisposed()){
        		textPage3.dispose();
        		textPage3 = null;
        	}
        }
        if(captionRedPage4 != null){
        	if(!captionRedPage4.isDisposed()){
        		captionRedPage4.dispose();
        		captionRedPage4 = null;
        	}
        }
        if(sliderRedPage4 != null){
        	if(!sliderRedPage4.isDisposed()){
        		sliderRedPage4.dispose();
        		sliderRedPage4 = null;
        	}
        }
        if(captionGreenPage4 != null){
        	if(!captionGreenPage4.isDisposed()){
        		captionGreenPage4.dispose();
        		captionGreenPage4 = null;
        	}
        }
        if(sliderGreenPage4 != null){
        	if(!sliderGreenPage4.isDisposed()){
        		sliderGreenPage4.dispose();
        		sliderGreenPage4 = null;
        	}
        }
        if(captionBluePage4 != null){
        	if(!captionBluePage4.isDisposed()){
        		captionBluePage4.dispose();
        		captionBluePage4 = null;
        	}
        }
        if(sliderBluePage4 != null){
        	if(!sliderBluePage4.isDisposed()){
        		sliderBluePage4.dispose();
        		sliderBluePage4 = null;
        	}
        }
        if(chosenColor != null ){
        	if(!chosenColor.isDisposed()){
        		chosenColor.dispose();
        		chosenColor = null;
        	}
        }
        if(buttonPage5 != null){
        	if(!buttonPage5.isDisposed()){
        		buttonPage5.dispose();
        		buttonPage5 = null;
        	}
        }
        if(imagePage5 != null){
        	if(!imagePage5.isDisposed()){
        		imagePage5.dispose();
        		imagePage5 = null;
        	}
        }
        
        dispose();
    }
    
    public void widgetSelected(SelectionEvent e) {
    	if (e.widget == sliderRedPage4) {
    		captionRedPage4.setTrailingText(sliderRedPage4.getSelection()*10 + " %"); //$NON-NLS-1$
    		chosenColor.redraw();
    	} else if (e.widget == sliderGreenPage4) {
    		captionGreenPage4.setTrailingText(sliderGreenPage4.getSelection()*10 + " %"); //$NON-NLS-1$
    		chosenColor.redraw();
    	} else if (e.widget == sliderBluePage4) {
    		captionBluePage4.setTrailingText(sliderBluePage4.getSelection()*10 + " %"); //$NON-NLS-1$
    		chosenColor.redraw();
		} else if (e.widget == commandDone) {
		    multipagedialog.close();
//            quit();
        } else if (e.widget == commandAddLanguagePage2) {
        	String stringToAdd = comboPage2.getText();
        	if (comboPage2.indexOf(stringToAdd) == -1) {
            	comboPage2.add(stringToAdd);
        	}
        } else if (e.widget == buttonPage5) {
            int index = images.indexOf(image);

        	index++;
            if (index >= images.size()) {
            	index = 0;
            }
            image = (Image) images.get(index);
            
            imagePage5.redraw();
        }  else if(e.widget == commandNextPage){
        	pageIndex++;
        	
        	if(pageIndex == multipagedialog.getPageCount()){
        		pageIndex = 0;
        	}
        	multipagedialog.setSelection(pageIndex);
        }
    }


    public void widgetDefaultSelected(SelectionEvent e) {
        
        
    }

	public void paintControl(PaintEvent e) {
		if (e.widget == imagePage5) {
			GC gc = new GC(imagePage5);
			
			Point centered = new Point ((imagePage5.getSize().x - image.getBounds().width)/2, (imagePage5.getSize().y - image.getBounds().height)/2);
			if (image.getBounds().width > imagePage5.getSize().x || image.getBounds().height > imagePage5.getSize().y) {
				gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, imagePage5.getSize().x, imagePage5.getSize().y);
			} else {
				gc.drawImage(image, centered.x, centered.y);	
			}
			
			gc.dispose();
		} else if (e.widget == chosenColor) {
    		RGB rgb = new RGB((int) (sliderRedPage4.getSelection()*25.5),(int) (sliderGreenPage4.getSelection()*25.5),(int) (sliderBluePage4.getSelection()*25.5) );
    		if (color != null) {
    		    color.dispose();
    		}
    		color = new Color(chosenColor.getDisplay(), rgb);
    		
    		e.gc.setForeground(color);
    		e.gc.setBackground(color);
    		e.gc.fillRectangle(new Rectangle(0, 0, chosenColor.getBounds().width, chosenColor.getBounds().height));
		}
	}


	public void modifyText(ModifyEvent e) {
		if (e.widget == textPage3) {
			progressBarPage3.setSelection(textPage3.getCharCount());
		}
	}

	public void handleEvent(Event e) {
		//If you relaunch this app on Nokia, it will launch the page you saw last time 
		//and focus in the first widget. So, each first widget of each page should 
		//handle this event.
		if(e.widget==userName||e.widget==comboPage2||e.widget==textPage3||e.widget==sliderRedPage4||e.widget==buttonPage5) {
			getComposite().getShell().setVisible(false);
		}
		
	}
}
